/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.treetable;

import com.triloggroup.gantt.GanttGlobalContext;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.ITimeUnits;
import com.triloggroup.gantt.ProjectContext;
import com.triloggroup.gantt.TGChartModel;
import com.triloggroup.gantt.TGComputableDuration;
import com.triloggroup.gantt.TGDuration;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TimeUnit;
import com.triloggroup.gantt.treetable.TGTreeTableModel;
import com.triloggroup.util.NLSBundle;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GanttTreeTableModel
extends TGTreeTableModel {
    public static final String DEADLINE_TABLECOL = "Deadline";
    public static final String PRIORITY_TABLECOL = "Priority";
    public static final String STATUS_TABLECOL = "Status";
    public static final String PROGRESS_TABLECOL = "Progress";
    public static final String DURATION_TABLECOL = "Duration";
    public static final String WORK_TABLECOL = "Work";
    public static final String DESCRIPTION_TABLECOL = "Description";
    public static final String REMAINING_WORK_TABLECOL = "RemainingWork";
    public static final String ACTUAL_WORK_TABLECOL = "ActualWork";
    public static final String TIMESHEET_HOURS_TABLECOL = "WorkedHours";
    public static final String ACTUAL_START_TABLECOL = "ActualStart";
    public static final String ACTUAL_FINISH_TABLECOL = "ActualFinish";
    public static final String TOTAL_SLACK_ID_TABLECOL = "TotalSlack";
    public static final String PREDECESSORS_TABLECOL = "predecessors";
    public static final String SCHEDULING_MODE_TABLECOL = "schedulingConstraint";
    public static final String ADDITIONAL_COST_TABLECOL = "AdditionalCost";
    public static final String ACTUAL_ADDITIONAL_COST_TABLECOL = "ActualAdditionalCost";
    public static final String ADDITIONAL_COST_DESC_TABLECOL = "AdditionalCostDescription";
    public static final String SUM_INITIALLY_PLANNED_ADDITIONAL_COST_TABLECOL = "InitiallyPlannedAdditionalCostSum";
    public static final String SUM_ACTUAL_ADDITIONAL_COST_TABLECOL = "ActualAdditionalCostSum";
    public static final String SUM_PROJECTED_ADDITIONAL_COST_TABLECOL = "ProjectedAdditionalCostSum";
    public static final String SUM_INITIALLY_PLANNED_RESOURCE_COST_TABLECOL = "InitiallyPlannedResourceCostSum";
    public static final String SUM_ACTUAL_RESOURCE_COST_TABLECOL = "ActualResourceCostSum";
    public static final String SUM_PROJECTED_RESOURCE_COST_TABLECOL = "ProjectedResourceCostSum";
    public static final String SUM_INITIALLY_PLANNED_COST_TABLECOL = "InitiallyPlannedCostSum";
    public static final String SUM_ACTUAL_COST_TABLECOL = "ActualCostSum";
    public static final String SUM_PROJECTED_COST_TABLECOL = "ProjectedCostSum";
    public static final String INTERNAL_ID_TABLECOL = "Internal Id";

    public GanttTreeTableModel(TGChartModel tGChartModel, NLSBundle nLSBundle, Locale locale) {
        this(tGChartModel, nLSBundle, locale, true, true, true, true);
    }

    public GanttTreeTableModel(TGChartModel tGChartModel, NLSBundle nLSBundle, Locale locale, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(tGChartModel, nLSBundle, locale, GanttTreeTableModel.getColumnKeyNames(bl, bl2, bl3, bl4));
    }

    public GanttTreeTableModel(TGChartModel tGChartModel, NLSBundle nLSBundle, Locale locale, String[] stringArray) {
        super(tGChartModel, nLSBundle, locale, stringArray);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        String string = this.columnKeyNames[n];
        if (string == "StartDate" || string == "EndDate" || string == ACTUAL_START_TABLECOL || string == ACTUAL_FINISH_TABLECOL || string == DEADLINE_TABLECOL) {
            return Date.class;
        }
        if (string == PRIORITY_TABLECOL) {
            return Integer.class;
        }
        return String.class;
    }

    @Override
    public Object getValueAt(Object object, int n) {
        if (!(object instanceof GanttNode)) {
            return null;
        }
        GanttNode ganttNode = (GanttNode)object;
        if (n < this.columnKeyNames.length) {
            String string = this.columnKeyNames[n];
            if (string == "Name") {
                return ganttNode.getName();
            }
            if (string == "Id") {
                if (object instanceof GanttWBS) {
                    GanttWBS ganttWBS = (GanttWBS)object;
                    if (ganttWBS.isSubProject()) {
                        return ganttWBS.getHierarchicalId() + "/1";
                    }
                    if (ganttWBS.isProjectRoot() && ganttWBS.getParent() != null) {
                        return ganttWBS.getParent().getHierarchicalId() + "/1";
                    }
                }
                return ganttNode.getHierarchicalId();
            }
            if (string == "StartDate") {
                return ganttNode.getStartDate();
            }
            if (string == "EndDate") {
                return ganttNode.getFinishDate();
            }
            if (string == "Resources") {
                if (ganttNode instanceof GanttTask) {
                    return ((GanttTask)ganttNode).getResources();
                }
                if (ganttNode instanceof GanttWBS) {
                    return ((GanttWBS)ganttNode).getResources();
                }
                return null;
            }
            if (string == DEADLINE_TABLECOL) {
                if (ganttNode instanceof GanttTask) {
                    return ((GanttTask)ganttNode).getDeadlineDate();
                }
                return null;
            }
            if (string == PRIORITY_TABLECOL) {
                if (ganttNode instanceof GanttTask) {
                    return new Integer(((GanttTask)ganttNode).getPriority());
                }
                return null;
            }
            if (string == STATUS_TABLECOL) {
                if (ganttNode instanceof GanttTask) {
                    return ganttNode.getLocalizedStatus();
                }
                return null;
            }
            if (string == PROGRESS_TABLECOL) {
                ProjectContext projectContext = ganttNode.getProjectContext();
                if (projectContext.showPercentComplete()) {
                    return new Integer(ganttNode.getPercentage());
                }
                return null;
            }
            if (string == DURATION_TABLECOL) {
                double d = ganttNode.getDurationDisplay();
                int n2 = ganttNode.getDurationFormat();
                ITimeUnits iTimeUnits = ganttNode.getGlobalContext().getTimeUnits();
                TimeUnit timeUnit = iTimeUnits.fromCode(n2);
                if (timeUnit == null) {
                    return null;
                }
                return new TGDuration(d, timeUnit);
            }
            if (string == WORK_TABLECOL) {
                double d = ganttNode.getWorkDisplay();
                int n3 = ganttNode.getWorkFormat();
                ITimeUnits iTimeUnits = ganttNode.getGlobalContext().getTimeUnits();
                TimeUnit timeUnit = iTimeUnits.fromCode(n3);
                if (timeUnit == null) {
                    return null;
                }
                return new TGDuration(d, timeUnit);
            }
            if (string == DESCRIPTION_TABLECOL) {
                return ganttNode.getNodeDescription();
            }
            if (string == REMAINING_WORK_TABLECOL) {
                if (ganttNode instanceof GanttTask) {
                    GanttTask ganttTask = (GanttTask)ganttNode;
                    boolean bl = false;
                    double d = ganttTask.getSpecifiedRemainingWork();
                    if (d < 0.0) {
                        bl = true;
                        d = ganttTask.getEstimatedRemainingWork();
                    }
                    ITimeUnits iTimeUnits = ganttNode.getGlobalContext().getTimeUnits();
                    return new TGComputableDuration(d, iTimeUnits.getHourTimeUnit(), bl);
                }
                return null;
            }
            if (string == ACTUAL_WORK_TABLECOL) {
                if (ganttNode instanceof GanttTask) {
                    GanttTask ganttTask = (GanttTask)ganttNode;
                    boolean bl = false;
                    double d = ganttTask.getSpecifiedActualWork();
                    if (d < 0.0) {
                        bl = true;
                        d = ganttTask.getEstimatedActualWork();
                    }
                    ITimeUnits iTimeUnits = ganttNode.getGlobalContext().getTimeUnits();
                    return new TGComputableDuration(d, iTimeUnits.getHourTimeUnit(), bl);
                }
                if (ganttNode instanceof GanttWBS) {
                    GanttWBS ganttWBS = (GanttWBS)ganttNode;
                    ArrayList<TGNode> arrayList = ganttWBS.getAllChildrenAndSubChildren(true);
                    boolean bl = true;
                    double d = 0.0;
                    for (TGNode tGNode : arrayList) {
                        if (!(tGNode instanceof GanttTask)) continue;
                        GanttTask ganttTask = (GanttTask)tGNode;
                        double d2 = ganttTask.getSpecifiedActualWork();
                        if (d2 >= 0.0) {
                            bl = false;
                            d += d2;
                            continue;
                        }
                        d += ganttTask.getEstimatedActualWork();
                    }
                    ITimeUnits iTimeUnits = ganttNode.getGlobalContext().getTimeUnits();
                    return new TGComputableDuration(d, iTimeUnits.getHourTimeUnit(), bl);
                }
                return null;
            }
            if (string == TIMESHEET_HOURS_TABLECOL) {
                if (ganttNode instanceof GanttTask) {
                    double d = ((GanttTask)ganttNode).getTimeSheetHours();
                    ITimeUnits iTimeUnits = ganttNode.getGlobalContext().getTimeUnits();
                    return new TGDuration(d, iTimeUnits.getHourTimeUnit());
                }
                return null;
            }
            if (string == ACTUAL_START_TABLECOL) {
                if (ganttNode instanceof GanttTask) {
                    return ((GanttTask)ganttNode).getActualStartDate();
                }
                return null;
            }
            if (string == ACTUAL_FINISH_TABLECOL) {
                if (ganttNode instanceof GanttTask) {
                    return ((GanttTask)ganttNode).getActualFinishDate();
                }
                return null;
            }
            if (string == INTERNAL_ID_TABLECOL) {
                return ganttNode.getUid();
            }
            if (string == TOTAL_SLACK_ID_TABLECOL) {
                if (ganttNode instanceof GanttTask) {
                    double d = ((GanttTask)ganttNode).getTotalSlack();
                    if (d == -1.0) {
                        return this.nlsBundle.getString("slack_Critical");
                    }
                    if (d == -99.0) {
                        return this.nlsBundle.getString("slack_NotApplicable");
                    }
                    if (d == 0.0) {
                        return null;
                    }
                    GanttGlobalContext ganttGlobalContext = (GanttGlobalContext)ganttNode.getGlobalContext();
                    int n4 = ganttGlobalContext.getCriticalPathConf().getSlackDisplayUnitCode();
                    ITimeUnits iTimeUnits = ganttNode.getGlobalContext().getTimeUnits();
                    TimeUnit timeUnit = iTimeUnits.fromCode(n4);
                    return this.getSlack(ganttNode, d, iTimeUnits, timeUnit);
                }
                return null;
            }
            if (string == PREDECESSORS_TABLECOL) {
                if (ganttNode instanceof GanttTask) {
                    return ((GanttTask)ganttNode).getPredecessorsList();
                }
                return null;
            }
            if (string == ADDITIONAL_COST_TABLECOL) {
                return new Double(ganttNode.getAdditionalCost());
            }
            if (string == ACTUAL_ADDITIONAL_COST_TABLECOL) {
                return ganttNode.getSpecifiedActualAdditionalCost();
            }
            if (string == ADDITIONAL_COST_DESC_TABLECOL) {
                return ganttNode.getAdditionalCostDescription();
            }
        }
        return null;
    }

    protected TGDuration getSlack(GanttNode ganttNode, double d, ITimeUnits iTimeUnits, TimeUnit timeUnit) {
        return new TGDuration(d, iTimeUnits.getHourTimeUnit());
    }
}

