/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.pe.app.ws;

import com.flowbuilder.util.TString;
import com.flowbuilder.util.xml.JDOMUtil;
import com.triloggroup.gantt.GanttChartException;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.GanttExceptionWS;
import com.triloggroup.gantt.app.applet.GanttAppletBase;
import com.triloggroup.gantt.pe.app.PEAppProjectContext;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.util.UString;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

public abstract class WebServiceHelper {
    private static final String soapEnvNs_prefix = "SOAP-ENV";
    private static final String soapEnvNs_uri = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final Namespace soapEnvNs = Namespace.getNamespace((String)"SOAP-ENV", (String)"http://schemas.xmlsoap.org/soap/envelope/");
    private static final String soapEncNs_prefix = "soapenc";
    private static final String soapEncNs_uri = "http://schemas.xmlsoap.org/soap/encoding/";
    protected static final Namespace soapEncNs = Namespace.getNamespace((String)"soapenc", (String)"http://schemas.xmlsoap.org/soap/encoding/");
    private static final String xsNs_prefix = "xs";
    private static final String xsNs_uri = "http://www.w3.org/2001/XMLSchema";
    private static final Namespace xsNs = Namespace.getNamespace((String)"xs", (String)"http://www.w3.org/2001/XMLSchema");
    private static final String xsdNs_prefix = "xsd";
    private static final String xsdNs_uri = "http://www.w3.org/2001/XMLSchema";
    private static final Namespace xsdNs = Namespace.getNamespace((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema");
    private static final String xsiNs_prefix = "xsi";
    private static final String xsiNs_uri = "http://www.w3.org/2001/XMLSchema-instance";
    protected static final Namespace xsiNs = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    private static final String implNs_prefix = "impl";
    private static final String implNs_uri = "fbws:FlowBuilderWebServices";
    private static final Namespace implNs = Namespace.getNamespace((String)"impl", (String)"fbws:FlowBuilderWebServices");
    private final PEAppProjectContext projectCtx;
    private final String webServiceName;

    protected WebServiceHelper(PEAppProjectContext pEAppProjectContext, String string) {
        this.projectCtx = pEAppProjectContext;
        this.webServiceName = string;
    }

    protected GanttAppletBase getApplet() {
        return this.projectCtx == null ? null : this.projectCtx.getGlobalContext().getApplet();
    }

    protected String getCookies() {
        if (this.projectCtx == null) {
            return null;
        }
        return this.projectCtx.getGlobalContext().getCookies();
    }

    protected String getSessionId() {
        return this.projectCtx.getGlobalContext().getWSSessionId();
    }

    protected String getSiteId() {
        return this.projectCtx.getGlobalContext().getSiteId();
    }

    protected String getProjectId() {
        return this.projectCtx.getProjectId();
    }

    public boolean touchSession() throws Exception {
        Element element;
        Element element2;
        Element element3 = this.createSOAPDoc("touchSession");
        element3.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        Document document = this.callWebService(element3.getDocument());
        Element element4 = document.getRootElement().getChild("Body", soapEnvNs);
        if (element4 != null && (element2 = element4.getChild("touchSessionResponse", implNs)) != null && (element = element2.getChild("touchSessionReturn")) != null) {
            return JDOMUtil.parseBoolean(element.getText());
        }
        throw new GanttChartException("No valid data in web service response");
    }

    protected String getBaseWSUrl() {
        String string = this.projectCtx != null ? this.projectCtx.getGlobalContext().getServerBaseUrl() : this.getApplet().getServerBaseUrl();
        return string + "/pservices/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document callWebService(Document document) throws Exception {
        String string;
        if (TString.isEmpty(this.getSessionId())) {
            throw new GanttExceptionWS(AppGanttChart.NLS_BUNDLE.getString("invalid_session_id"));
        }
        Locale locale = Workbench.get().getLocale();
        String string2 = locale.getLanguage();
        if (!UString.isEmpty(locale.getCountry())) {
            string2 = string2 + '-' + locale.getCountry();
        }
        GanttAppletBase ganttAppletBase = this.getApplet();
        String string3 = this.getBaseWSUrl() + this.webServiceName;
        if (ganttAppletBase != null && "true".equals(ganttAppletBase.getParameter("browserwscalls"))) {
            try {
                String string4 = JDOMUtil.toString(document, true);
                String string5 = (String)ganttAppletBase.callJSWithResult("tg_callWS", string3, string4);
                if (string5 == null) {
                    throw new GanttExceptionWS("Unknown Server Error (from js).");
                }
                return JDOMUtil.read(string5);
            }
            catch (GanttExceptionWS ganttExceptionWS) {
                throw ganttExceptionWS;
            }
            catch (Exception exception) {
                throw new GanttExceptionWS("Unknown Server Error (from js).", exception);
            }
        }
        URL uRL = new URL(string3);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setRequestProperty("SOAPAction", "\"\"");
        uRLConnection.setRequestProperty("Content-Type", "text/xml;charset=\"utf-8\"");
        String string6 = this.getCookies();
        if (string6 != null) {
            uRLConnection.setRequestProperty("Cookie", string6);
        }
        uRLConnection.setRequestProperty("Accept-Language", string2);
        uRLConnection.setDoOutput(true);
        uRLConnection.setDoInput(true);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(uRLConnection.getOutputStream(), "UTF-8");
        try {
            string = JDOMUtil.toString(document, true);
            outputStreamWriter.write(string);
            outputStreamWriter.flush();
        }
        finally {
            outputStreamWriter.close();
        }
        string = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Object object;
            Object object2;
            if (uRLConnection instanceof HttpURLConnection) {
                object2 = (HttpURLConnection)uRLConnection;
                int n = ((HttpURLConnection)object2).getResponseCode();
                object = ((HttpURLConnection)object2).getResponseMessage();
                if (n != 200) {
                    throw new Exception("HttpURLConnection error: " + n + " - " + (String)object);
                }
            }
            object2 = uRLConnection.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object2, "UTF-8");
            object = new char[512];
            try {
                int n = inputStreamReader.read((char[])object);
                while (n != -1) {
                    stringBuilder.append((char[])object, 0, n);
                    n = inputStreamReader.read((char[])object);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                inputStreamReader.close();
            }
            return JDOMUtil.read(stringBuilder.toString());
        }
        catch (Exception exception) {
            Element element;
            String string7;
            Object object;
            exception.printStackTrace();
            if (uRLConnection instanceof HttpURLConnection) {
                object = ((HttpURLConnection)uRLConnection).getErrorStream();
                string7 = this.readUTF8String((InputStream)object, 4096);
                if (!UString.isEmpty(string7)) {
                    try {
                        string = JDOMUtil.read(string7);
                    }
                    catch (Exception exception2) {
                        System.err.println("WebService response Error: \n" + string7);
                        throw new GanttExceptionWS("Unknown Server Error", exception2);
                    }
                } else {
                    if (stringBuilder.length() > 0) {
                        System.err.println("WebService response parsing error: \n" + stringBuilder.toString());
                    }
                    throw new GanttExceptionWS("Unknown Server Error");
                }
            }
            if (UString.equals((element = this.getBodyContentElement((Document)string)).getName(), "Fault")) {
                object = null;
                string7 = element.getChild("detail");
                if (string7 != null) {
                    Element element2 = string7.getChild("com.triloggroup.pe.webservices.gantt.GanttServerExceptionWS");
                    if (element2 != null) {
                        int n = JDOMUtil.getInteger(element2, "code") + 10000;
                        String string8 = n == 10001 ? AppGanttChart.NLS_BUNDLE.getString("invalid_session_id") : JDOMUtil.getString(element2, "message");
                        object = new GanttExceptionWS(n, string8);
                    } else {
                        object = new GanttExceptionWS(JDOMUtil.getString(element, "faultstring"));
                    }
                } else {
                    object = new GanttExceptionWS("Unknown Server Error");
                }
                throw object;
            }
            return string;
        }
    }

    private Element getResponseReturnElement(Document document, String string) {
        Element element = document.getRootElement().getChild("Body", soapEnvNs);
        if (element == null) {
            return null;
        }
        Element element2 = element.getChild(string + "Response", implNs);
        if (element2 == null) {
            return null;
        }
        return this.getChildWithoutTakingCareOfNS(element2, string + "Return");
    }

    private Element getChildWithoutTakingCareOfNS(Element element, String string) {
        Element element2 = element.getChild(string);
        if (element2 != null) {
            return element2;
        }
        List list = element.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            Element element3 = (Element)list.get(i);
            if (!string.equals(element3.getName())) continue;
            return element3;
        }
        return null;
    }

    protected Element callWebService(Element element) throws Exception {
        Document document = this.callWebService(element.getDocument());
        String string = element.getName();
        return this.getResponseReturnElement(document, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readUTF8String(InputStream inputStream, int n) {
        if (inputStream == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            char[] cArray = new char[128];
            int n2 = inputStreamReader.read(cArray);
            while (n2 != -1) {
                stringBuilder.append(cArray, 0, n2);
                if (n > 0 && stringBuilder.length() >= n) {
                    stringBuilder.append(" (...)");
                    break;
                }
                n2 = inputStreamReader.read(cArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                inputStreamReader.close();
            }
            catch (IOException iOException) {}
        }
        return stringBuilder.toString();
    }

    private Document createEmptySOAPDoc() {
        Document document = new Document();
        Element element = new Element("Envelope", soapEnvNs);
        element.addNamespaceDeclaration(soapEnvNs);
        element.addNamespaceDeclaration(soapEncNs);
        element.addNamespaceDeclaration(xsNs);
        element.addNamespaceDeclaration(xsdNs);
        element.addNamespaceDeclaration(xsiNs);
        document.setRootElement(element);
        Element element2 = new Element("Body", soapEnvNs);
        element.addContent(element2);
        return document;
    }

    protected Element createSOAPDoc(String string) {
        Document document = this.createEmptySOAPDoc();
        Element element = document.getRootElement().getChild("Body", soapEnvNs);
        Element element2 = new Element(string, implNs);
        element2.addNamespaceDeclaration(soapEnvNs);
        element.addContent(element2);
        return element2;
    }

    protected Element getBodyContentElement(Document document) {
        List list;
        Element element;
        Element element2;
        if (document != null && (element2 = document.getRootElement()) != null && (element = element2.getChild("Body", soapEnvNs)) != null && (list = element.getChildren()) != null && list.size() > 0) {
            return (Element)list.get(0);
        }
        return null;
    }

    protected Element createStringSOAPParamElt(String string, String string2) {
        Element element = new Element(string);
        element.setAttribute("type", "soapenc:string", xsiNs);
        element.setText(string2);
        return element;
    }

    protected Element createStringArraySOAPParamElt(String string, String[] stringArray) {
        Element element = new Element(string);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                Element element2 = new Element("item");
                element2.setText(stringArray[i]);
                element.addContent(element2);
            }
        }
        return element;
    }

    protected Element createBooleanArraySOAPParamElt(String string, boolean[] blArray) {
        Element element = new Element(string);
        if (blArray != null) {
            for (int i = 0; i < blArray.length; ++i) {
                Element element2 = new Element("item");
                element2.setText(String.valueOf(blArray[i]));
                element.addContent(element2);
            }
        }
        return element;
    }

    protected Element createIntSOAPParamElt(String string, int n) {
        Element element = new Element(string);
        element.setAttribute("type", "xsd:int", xsiNs);
        element.setText(String.valueOf(n));
        return element;
    }

    protected Element createLongSOAPParamElt(String string, long l) {
        Element element = new Element(string);
        element.setAttribute("type", "xsd:long", xsiNs);
        element.setText(String.valueOf(l));
        return element;
    }

    protected Element createBooleanSOAPParamElt(String string, boolean bl) {
        Element element = new Element(string);
        element.setAttribute("type", "xsd:boolean", xsiNs);
        element.setText(String.valueOf(bl));
        return element;
    }

    protected Element createDateTimeSOAPParamElt(String string, Date date) {
        Element element = new Element(string);
        element.setAttribute("type", "xsd:dateTime", xsiNs);
        String string2 = "yyyy-MM-dd'T'HH:mm:ssZ";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        String string3 = simpleDateFormat.format(date);
        int n = string3.length() - 2;
        string3 = string3.substring(0, n) + ':' + string3.substring(n);
        element.setText(string3);
        return element;
    }
}

