/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.pe.app.dialog;

import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.TGDuration;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TimeUnit;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.AppGanttChartModel;
import com.triloggroup.gantt.app.IActionCallback;
import com.triloggroup.gantt.app.Status;
import com.triloggroup.gantt.app.TaskPredecessorsPanel;
import com.triloggroup.gantt.app.TaskResourcesPanel;
import com.triloggroup.gantt.app.change.ChangeException;
import com.triloggroup.gantt.app.dialog.StartEditWithPredecessorQuestionDialog;
import com.triloggroup.gantt.app.dialog.WorkOrDurationEditQuestionDialog;
import com.triloggroup.gantt.app.ui.AsyncActionRunner;
import com.triloggroup.gantt.app.ui.CancelAsyncActionException;
import com.triloggroup.gantt.app.ui.IAsyncAction;
import com.triloggroup.gantt.app.ui.LineWrapTextArea;
import com.triloggroup.gantt.app.ui.WDButton;
import com.triloggroup.gantt.app.ui.WDDatePicker;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDExpandableSection;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.gantt.pe.PETimeUnits;
import com.triloggroup.gantt.pe.app.AppScheduleComputation;
import com.triloggroup.gantt.pe.app.CalendarAccessor;
import com.triloggroup.gantt.pe.app.PEAppGanttChart;
import com.triloggroup.gantt.pe.app.PEAppGanttChartModel;
import com.triloggroup.gantt.pe.app.PEAppProjectModel;
import com.triloggroup.gantt.pe.app.SchedulingMode;
import com.triloggroup.gantt.pe.app.TaskUpdater;
import com.triloggroup.gantt.pe.app.alerts.AlertManager;
import com.triloggroup.gantt.pe.app.alerts.TaskAlert;
import com.triloggroup.gantt.pe.app.dialog.GanttNodeCostSection;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.project.schedule.IPredecessor;
import com.triloggroup.project.schedule.ScheduleCalendar;
import com.triloggroup.ui.DoubleTextField;
import com.triloggroup.ui.IntTextField;
import com.triloggroup.ui.NumberTextField;
import com.triloggroup.util.NLSBundle;
import com.triloggroup.util.date.TGTime;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class TaskDetailDialog
extends WDDialog
implements ActionListener {
    private GanttTask originalTask;
    private GanttTask taskCopy;
    private GanttNode insertAfter;
    private PEAppGanttChart ganttCtrl;
    private PEAppProjectModel projectModel;
    private IActionCallback callback;
    private JPanel alertsPanel;
    private WDButton okButton;
    private JTextField nameTxtField;
    private JTextField idTxtField;
    private JComboBox wbsEntryCombo;
    private JComboBox statusCombo;
    private IntTextField completeTxtField;
    private WDDatePicker startDatePicker;
    private WDDatePicker endDatePicker;
    private DoubleTextField durationTxtField;
    private JComboBox durationUnitsCombo;
    private DoubleTextField workTxtField;
    private JComboBox workUnitsCombo;
    private JTextArea descriptionTA;
    private TaskResourcesPanel resourcesPanel;
    private TaskPredecessorsPanel predecessorsPanel;
    private GanttNodeCostSection costsSection;
    private WDExpandableSection advancedSection;
    private IntTextField tfPriority;
    private DoubleTextField tfRemain;
    private boolean remainSpecified;
    private WDButton btRemain;
    private DoubleTextField tfActualWork;
    private boolean actualWorkSpecified;
    private WDButton btActualWork;
    private JTextField tfWorked;
    private WDDatePicker tfActualStart;
    private WDDatePicker tfActualFinish;
    private WDDatePicker tfDeadline;
    private JComboBox cbSchedulingMode;
    private JCheckBox checkSkipAutoReschedule;
    private JComboBox cbCalendar;
    private JCheckBox checkIgnoreUserCalendar;
    private NumberFormat decimalFormat;
    private Font italicFont;
    private Font defaultFont;
    private boolean updating;
    private boolean disposed = false;

    public static void showDetail(GanttTask ganttTask, PEAppGanttChart pEAppGanttChart, Point point) {
        TaskDetailDialog.showDetail(ganttTask, pEAppGanttChart, point, null);
    }

    public static void showDetail(GanttTask ganttTask, PEAppGanttChart pEAppGanttChart, Point point, IActionCallback iActionCallback) {
        Window window = SwingUtilities.getWindowAncestor(pEAppGanttChart.getView());
        GraphicsConfiguration graphicsConfiguration = WDUtil.getGraphicsConfiguration(point);
        TaskDetailDialog taskDetailDialog = new TaskDetailDialog(ganttTask, window, pEAppGanttChart, graphicsConfiguration);
        if (iActionCallback != null) {
            taskDetailDialog.setCallBack(iActionCallback);
        }
        taskDetailDialog.setLocation(point);
        taskDetailDialog.setVisible(true);
    }

    public static void showNewTaskDetail(PEAppGanttChart pEAppGanttChart, Point point) {
        TaskDetailDialog.showNewTaskDetail(null, pEAppGanttChart, point, null, false);
    }

    public static void showNewTaskDetail(GanttWBS ganttWBS, PEAppGanttChart pEAppGanttChart, Point point, GanttNode ganttNode, boolean bl) {
        Window window = SwingUtilities.getWindowAncestor(pEAppGanttChart.getView());
        GraphicsConfiguration graphicsConfiguration = WDUtil.getGraphicsConfiguration(point);
        TaskDetailDialog taskDetailDialog = new TaskDetailDialog(ganttWBS, window, pEAppGanttChart, ganttNode, bl, graphicsConfiguration);
        taskDetailDialog.setLocation(point);
        taskDetailDialog.setVisible(true);
    }

    protected TaskDetailDialog(GanttTask ganttTask, Window window, PEAppGanttChart pEAppGanttChart, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
        this.initForExistingTask(ganttTask, pEAppGanttChart);
    }

    protected void initForExistingTask(GanttTask ganttTask, PEAppGanttChart pEAppGanttChart) {
        this.ganttCtrl = pEAppGanttChart;
        this.projectModel = pEAppGanttChart.getModel().getProjectModel(ganttTask.getProjectId());
        this.originalTask = ganttTask;
        this.taskCopy = ganttTask.clone();
        this.initAlertPanel();
        this.createUI();
        if (!this.isEditable()) {
            this.setAllFieldsReadonly();
        } else {
            this.setReadonlySchedulingFields(true);
        }
        this.updateFieldsFromTask();
        this.restrictPreferredSizes();
        if (this.isEditable()) {
            this.registerListeners();
            this.pack();
            this.nameTxtField.requestFocusInWindow();
        }
    }

    protected TaskDetailDialog(GanttWBS ganttWBS, Window window, PEAppGanttChart pEAppGanttChart, GanttNode ganttNode, boolean bl, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
        this.initForNewTask(ganttWBS, pEAppGanttChart, ganttNode, bl);
    }

    private void initForNewTask(GanttWBS ganttWBS, PEAppGanttChart pEAppGanttChart, GanttNode ganttNode, boolean bl) {
        this.ganttCtrl = pEAppGanttChart;
        this.insertAfter = ganttNode;
        PEAppGanttChartModel pEAppGanttChartModel = pEAppGanttChart.getModel();
        this.taskCopy = bl ? pEAppGanttChartModel.newMilestone(ganttWBS, ganttNode) : pEAppGanttChartModel.newGanttTask(ganttWBS, ganttNode);
        this.projectModel = pEAppGanttChart.getModel().getProjectModel(this.taskCopy.getProjectId());
        TaskUpdater taskUpdater = new TaskUpdater(null, this.taskCopy, pEAppGanttChart.getModel(), this, 0);
        try {
            taskUpdater.checkAndCompute();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            WDDialog.showMsgDialog(this, AppGanttChart.NLS_BUNDLE.getString("schedule_commputation_error"));
        }
        this.createUI();
        this.setReadonlySchedulingFields(true);
        this.updateFieldsFromTask();
        this.restrictPreferredSizes();
        this.registerListeners();
        this.pack();
        this.nameTxtField.requestFocusInWindow();
    }

    public IActionCallback getCallback() {
        return this.callback;
    }

    public void setCallBack(IActionCallback iActionCallback) {
        this.callback = iActionCallback;
    }

    private void createUI() {
        this.setDragHeader(true);
        this.setResizable(true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.createButtonsPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        this.getContentPane().add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        NLSBundle nLSBundle = AppGanttChart.NLS_BUNDLE;
        Insets insets = new Insets(5, 0, 0, 0);
        Insets insets2 = new Insets(5, 0, 0, 5);
        Insets insets3 = new Insets(5, 3, 0, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 18, 2, insets, 0, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 2, insets2, 0, 0);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(1, -1, 2, 1, 1.0, 0.0, 18, 2, insets, 0, 0);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints(1, -1, 2, 1, 1.0, 0.0, 18, 0, insets, 10, 0);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints(1, -1, 1, 1, 0.25, 0.0, 18, 2, insets, 0, 0);
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints(2, -1, 1, 1, 1.0, 0.0, 17, 0, insets, 10, 0);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints(2, -1, 1, 1, 1.0, 0.0, 17, 0, insets3, 10, 0);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (this.alertsPanel != null) {
            jPanel.add((Component)this.alertsPanel, gridBagConstraints);
        }
        JLabel jLabel = new JLabel(nLSBundle.getString("taskName"));
        jPanel.add((Component)jLabel, gridBagConstraints2);
        this.nameTxtField = new JTextField();
        WDUtil.setDocumentWithMaxLength(this.nameTxtField, 256);
        this.nameTxtField.setInputVerifier(new NameInputVerifier());
        jPanel.add((Component)this.nameTxtField, gridBagConstraints3);
        JLabel jLabel2 = new JLabel(nLSBundle.getString("id"));
        jPanel.add((Component)jLabel2, gridBagConstraints2);
        this.idTxtField = new JTextField();
        this.idTxtField.setEditable(false);
        jPanel.add((Component)this.idTxtField, gridBagConstraints3);
        JLabel jLabel3 = new JLabel(nLSBundle.getString("wbsEntry"));
        jPanel.add((Component)jLabel3, gridBagConstraints2);
        this.createWbsEntryCombo();
        jPanel.add((Component)this.wbsEntryCombo, gridBagConstraints3);
        JLabel jLabel4 = new JLabel(nLSBundle.getString("status"));
        jPanel.add((Component)jLabel4, gridBagConstraints2);
        this.statusCombo = new JComboBox();
        Status[] statusArray = Status.getAllAvailableStatusForTask();
        for (int i = 0; i < statusArray.length; ++i) {
            this.statusCombo.addItem(statusArray[i]);
        }
        jPanel.add((Component)this.statusCombo, gridBagConstraints4);
        JLabel jLabel5 = new JLabel(nLSBundle.getString("percentComplete"));
        this.completeTxtField = new MinMaxIntTextField(0, 100, "percentCompletNumberError");
        jPanel.add((Component)jLabel5, gridBagConstraints2);
        jPanel.add((Component)this.completeTxtField, gridBagConstraints5);
        jPanel.add((Component)new JLabel("%"), gridBagConstraints6);
        JLabel jLabel6 = new JLabel(nLSBundle.getString("startDate"));
        this.startDatePicker = this.createDatePicker();
        jPanel.add((Component)jLabel6, gridBagConstraints2);
        jPanel.add((Component)this.startDatePicker, gridBagConstraints4);
        JLabel jLabel7 = new JLabel(nLSBundle.getString("endDate"));
        this.endDatePicker = this.createDatePicker();
        jPanel.add((Component)jLabel7, gridBagConstraints2);
        jPanel.add((Component)this.endDatePicker, gridBagConstraints4);
        JLabel jLabel8 = new JLabel(nLSBundle.getString("duration"));
        this.durationTxtField = new PositiveDoubleTextField("durationDisplayError");
        TimeUnit[] timeUnitArray = Workbench.get().getTimeUnits().getAllTimeUnits();
        this.durationUnitsCombo = new JComboBox();
        for (int i = 0; i < timeUnitArray.length; ++i) {
            this.durationUnitsCombo.addItem(timeUnitArray[i]);
        }
        jPanel.add((Component)jLabel8, gridBagConstraints2);
        jPanel.add((Component)this.durationTxtField, gridBagConstraints5);
        jPanel.add((Component)this.durationUnitsCombo, gridBagConstraints7);
        JLabel jLabel9 = new JLabel(nLSBundle.getString("work"));
        this.workTxtField = new PositiveDoubleTextField("workDisplayError");
        this.workUnitsCombo = new JComboBox();
        for (int i = 0; i < timeUnitArray.length; ++i) {
            this.workUnitsCombo.addItem(timeUnitArray[i]);
        }
        jPanel.add((Component)jLabel9, gridBagConstraints2);
        jPanel.add((Component)this.workTxtField, gridBagConstraints5);
        jPanel.add((Component)this.workUnitsCombo, gridBagConstraints7);
        JLabel jLabel10 = new JLabel(nLSBundle.getString("description"));
        jPanel.add((Component)jLabel10, gridBagConstraints2);
        this.descriptionTA = new LineWrapTextArea();
        WDUtil.setDocumentWithMaxLength(this.descriptionTA, 512);
        jPanel.add((Component)this.descriptionTA, gridBagConstraints3);
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 18, 2, insets, 0, 0);
        this.resourcesPanel = new TaskResourcesPanel((AppGanttChart)this.ganttCtrl, this.taskCopy);
        WDExpandableSection wDExpandableSection = new WDExpandableSection(nLSBundle.getString("resources"), this.resourcesPanel);
        jPanel.add((Component)wDExpandableSection, gridBagConstraints8);
        this.predecessorsPanel = new TaskPredecessorsPanel((AppGanttChart)this.ganttCtrl, this.taskCopy);
        WDExpandableSection wDExpandableSection2 = new WDExpandableSection(nLSBundle.getString("predecessors"), this.predecessorsPanel);
        jPanel.add((Component)wDExpandableSection2, gridBagConstraints8);
        PEAppGanttChartModel pEAppGanttChartModel = this.ganttCtrl.getModel();
        if (((AppGanttChartModel)pEAppGanttChartModel).getGlobalContext().hasFinancialModule()) {
            this.costsSection = new GanttNodeCostSection(this.ganttCtrl, this.taskCopy, nLSBundle);
            jPanel.add((Component)this.costsSection, gridBagConstraints8);
        }
        JPanel jPanel2 = this.createAdvancedPanel(nLSBundle);
        this.advancedSection = new WDExpandableSection(nLSBundle.getString("advanced"), jPanel2);
        jPanel.add((Component)this.advancedSection, gridBagConstraints8);
        jPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, -1, 3, 1, 0.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.defaultFont = this.workTxtField.getFont();
        this.italicFont = this.defaultFont.deriveFont(2);
    }

    protected void registerListeners() {
        this.statusCombo.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.statusCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TaskDetailDialog.this.statusModified();
                ((JComboBox)actionEvent.getSource()).hidePopup();
            }
        });
        this.completeTxtField.addValueChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TaskDetailDialog.this.pctCompleteModified();
            }
        });
        this.startDatePicker.addDateChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TaskDetailDialog.this.startDateModified(propertyChangeEvent);
            }
        });
        this.endDatePicker.addDateChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TaskDetailDialog.this.endDateModified(propertyChangeEvent);
            }
        });
        this.tfActualStart.addDateChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TaskDetailDialog.this.actualDateModified(propertyChangeEvent);
            }
        });
        this.tfActualFinish.addDateChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TaskDetailDialog.this.actualDateModified(propertyChangeEvent);
            }
        });
        this.durationTxtField.addValueChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TaskDetailDialog.this.durationModified();
            }
        });
        this.durationUnitsCombo.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.durationUnitsCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TaskDetailDialog.this.durationModified();
                ((JComboBox)actionEvent.getSource()).hidePopup();
            }
        });
        this.workTxtField.addValueChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TaskDetailDialog.this.workModified();
            }
        });
        this.workUnitsCombo.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.workUnitsCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TaskDetailDialog.this.workModified();
                ((JComboBox)actionEvent.getSource()).hidePopup();
            }
        });
        this.resourcesPanel.getTableModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                TaskDetailDialog.this.resourcesModified();
            }
        });
        this.predecessorsPanel.getTableModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                TaskDetailDialog.this.predecessorsModified();
            }
        });
        this.cbSchedulingMode.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.cbSchedulingMode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TaskDetailDialog.this.schedulingModeModified();
                ((JComboBox)actionEvent.getSource()).hidePopup();
            }
        });
        this.cbCalendar.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.cbCalendar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!TaskDetailDialog.this.updating) {
                    String string;
                    ScheduleCalendar scheduleCalendar = (ScheduleCalendar)TaskDetailDialog.this.cbCalendar.getSelectedItem();
                    String string2 = string = scheduleCalendar == null ? null : scheduleCalendar.getCalendarId();
                    if (string != TaskDetailDialog.this.taskCopy.getCalendarId()) {
                        TaskDetailDialog.this.calculateComputedFields();
                    }
                }
                ((JComboBox)actionEvent.getSource()).hidePopup();
            }
        });
        this.checkIgnoreUserCalendar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!TaskDetailDialog.this.updating) {
                    TaskDetailDialog.this.calculateComputedFields();
                }
            }
        });
        if (this.costsSection != null) {
            this.costsSection.registerListeners();
        }
    }

    private boolean isWorkingDay(Date date) {
        CalendarAccessor calendarAccessor = this.projectModel.getCalendarAccessor();
        return AppScheduleComputation.isWorkingDay(date, calendarAccessor.getProjectCalendar(), calendarAccessor.getTaskCalendar(this.taskCopy), calendarAccessor.getTaskCalendars(this.taskCopy));
    }

    protected void restrictPreferredSizes() {
        this.restrictPreferredSize(this.nameTxtField);
        this.nameTxtField.setCaretPosition(0);
        this.restrictPreferredSize(this.idTxtField);
        this.idTxtField.setCaretPosition(0);
        this.restrictPreferredSize(this.wbsEntryCombo);
    }

    protected void restrictPreferredSize(JComponent jComponent) {
        Dimension dimension = jComponent.getPreferredSize();
        if (dimension.width > 600) {
            jComponent.setPreferredSize(new Dimension(600, dimension.height));
        }
    }

    protected NumberFormat getDecimalFormat() {
        if (this.decimalFormat == null) {
            this.decimalFormat = NumberFormat.getNumberInstance(this.ganttCtrl.getLocale());
            this.decimalFormat.setMaximumFractionDigits(2);
        }
        return this.decimalFormat;
    }

    /*
     * WARNING - void declaration
     */
    protected void createWbsEntryCombo() {
        void var3_5;
        this.wbsEntryCombo = new JComboBox();
        this.wbsEntryCombo.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object instanceof GanttWBS) {
                    this.setText(((GanttWBS)object).getHierarchicalId() + " - " + ((GanttWBS)object).getName());
                }
                return this;
            }
        });
        ArrayList<GanttWBS> arrayList = new ArrayList<GanttWBS>();
        for (GanttWBS ganttWBS : this.projectModel.getAllWBS()) {
            if (!ganttWBS.isReadeable() || ganttWBS.isSubProject()) continue;
            arrayList.add(ganttWBS);
        }
        Collections.sort(arrayList, TGNode.sortedIdComparator);
        boolean i = false;
        while (var3_5 < arrayList.size()) {
            this.wbsEntryCombo.addItem(arrayList.get((int)var3_5));
            ++var3_5;
        }
        this.wbsEntryCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    TaskDetailDialog.this.parentModified();
                }
            }
        });
    }

    protected JPanel createAdvancedPanel(final NLSBundle nLSBundle) {
        SchedulingMode[] schedulingModeArray;
        JLabel jLabel;
        Insets insets = new Insets(5, 0, 0, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(1, -1, 3, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(0, -1, 4, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel2 = new JLabel(nLSBundle.getString("Priority"));
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.tfPriority = new MinMaxIntTextField(0, 1000, "priorityNumberError");
        this.tfPriority.setGroupingUsed(false);
        this.tfPriority.setHorizontalAlignment(2);
        jPanel.add((Component)this.tfPriority, gridBagConstraints2);
        if (this.ganttCtrl.getModel().getGlobalContext().hasTimesheetModule()) {
            jLabel = new JLabel(nLSBundle.getString("WorkedHours"));
            jPanel.add((Component)jLabel, gridBagConstraints);
            this.tfWorked = new JTextField();
            this.tfWorked.setEditable(false);
            this.tfWorked.setHorizontalAlignment(2);
            jPanel.add((Component)this.tfWorked, gridBagConstraints2);
        }
        jLabel = new JLabel(nLSBundle.getString("ActualWork"));
        String string = Workbench.get().getTimeUnits().getHourTimeUnit().getShortLabelPlural();
        JLabel jLabel3 = new JLabel(string);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.tfActualWork = new PositiveDoubleTextField("workDisplayError");
        this.btActualWork = new WDButton();
        if (this.isEditable()) {
            this.btActualWork.addActionListener(this);
        }
        jPanel.add((Component)this.tfActualWork, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        jPanel.add((Component)this.btActualWork, new GridBagConstraints(3, -1, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        String string2 = nLSBundle.getString("RemainingWork");
        JLabel jLabel4 = new JLabel(string2);
        jLabel3 = new JLabel(string);
        jPanel.add((Component)jLabel4, gridBagConstraints);
        this.tfRemain = new PositiveDoubleTextField("remainingWorkError");
        this.btRemain = new WDButton();
        if (this.isEditable()) {
            this.btRemain.addActionListener(this);
        }
        jPanel.add((Component)this.tfRemain, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        jPanel.add((Component)this.btRemain, new GridBagConstraints(3, -1, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        JLabel jLabel5 = new JLabel(nLSBundle.getString("ActualStart"));
        jPanel.add((Component)jLabel5, gridBagConstraints);
        this.tfActualStart = this.createDatePicker();
        jPanel.add((Component)this.tfActualStart, gridBagConstraints2);
        JLabel jLabel6 = new JLabel(nLSBundle.getString("ActualFinish"));
        jPanel.add((Component)jLabel6, gridBagConstraints);
        this.tfActualFinish = this.createDatePicker();
        jPanel.add((Component)this.tfActualFinish, gridBagConstraints2);
        JLabel jLabel7 = new JLabel(nLSBundle.getString("Deadline"));
        jPanel.add((Component)jLabel7, gridBagConstraints);
        this.tfDeadline = this.createDatePicker();
        jPanel.add((Component)this.tfDeadline, gridBagConstraints2);
        ScheduleCalendar scheduleCalendar = this.projectModel.getProjectCalendar();
        for (int i = 0; i < 7; ++i) {
            schedulingModeArray = scheduleCalendar.getWeekdayAt(i);
            if (!schedulingModeArray.isDayWorking || schedulingModeArray.workingTimes.length <= 0) continue;
            this.tfActualStart.setDefaultTime(schedulingModeArray.workingTimes[0].fromTime);
            this.tfActualFinish.setDefaultTime(schedulingModeArray.workingTimes[schedulingModeArray.workingTimes.length - 1].toTime);
            break;
        }
        this.tfDeadline.setDefaultTime(new TGTime(23, 59, 59));
        JLabel jLabel8 = new JLabel(nLSBundle.getString("schedulingConstraint"));
        jPanel.add((Component)jLabel8, gridBagConstraints);
        this.cbSchedulingMode = new JComboBox();
        schedulingModeArray = SchedulingMode.getAllSchedulingModes();
        for (int i = 0; i < schedulingModeArray.length; ++i) {
            this.cbSchedulingMode.addItem(schedulingModeArray[i]);
        }
        jPanel.add((Component)this.cbSchedulingMode, gridBagConstraints2);
        JLabel jLabel9 = new JLabel(nLSBundle.getString("calendar"));
        jPanel.add((Component)jLabel9, gridBagConstraints);
        this.cbCalendar = new JComboBox();
        this.cbCalendar.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                ScheduleCalendar scheduleCalendar = (ScheduleCalendar)object;
                String string = scheduleCalendar == null ? nLSBundle.getString("none") : scheduleCalendar.getName();
                return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            }
        });
        CalendarAccessor calendarAccessor = this.projectModel.getCalendarAccessor();
        this.cbCalendar.addItem(null);
        ScheduleCalendar[] scheduleCalendarArray = calendarAccessor.getBaseCalendars();
        for (int i = 0; i < scheduleCalendarArray.length; ++i) {
            this.cbCalendar.addItem(scheduleCalendarArray[i]);
        }
        jPanel.add((Component)this.cbCalendar, gridBagConstraints2);
        this.checkIgnoreUserCalendar = new JCheckBox(nLSBundle.getString("ignoreUserCalendar"));
        jPanel.add((Component)this.checkIgnoreUserCalendar, gridBagConstraints3);
        if (this.projectModel.isAutomaticReschedule()) {
            this.checkSkipAutoReschedule = new JCheckBox(nLSBundle.getString("skipautomaticreschedule"));
            jPanel.add((Component)this.checkSkipAutoReschedule, gridBagConstraints3);
        }
        return jPanel;
    }

    protected void updateTaskFromFields() throws ChangeException {
        ScheduleCalendar scheduleCalendar;
        Comparable<Double> comparable;
        Integer n;
        Double d;
        String string = this.nameTxtField.getText().trim();
        String string2 = Workbench.checkInvalidCharacters(string);
        if (string2 != null) {
            throw new ChangeException(string2, "name");
        }
        this.taskCopy.setName(string);
        Status status = (Status)this.statusCombo.getSelectedItem();
        this.taskCopy.setStatus(status.getCode());
        Integer n2 = this.completeTxtField.getValue();
        if (n2 == null || n2 < 0 || n2 > 100) {
            throw new ChangeException("percentCompletNumberError", "percentComplete");
        }
        this.taskCopy.setPercentComplete((double)n2.intValue() / 100.0);
        Date date = this.startDatePicker.getDate();
        if (date == null) {
            throw new ChangeException("startDateEmpty", "startDate");
        }
        Date date2 = this.endDatePicker.getDate();
        if (date2 == null) {
            throw new ChangeException("endDateEmpty", "endDate");
        }
        this.taskCopy.setDuration(date, date2);
        if (date2.before(date)) {
            this.taskCopy.getDuration().getEnd().setTime(date2.getTime());
        }
        if ((d = this.durationTxtField.getValue()) == null) {
            throw new ChangeException("durationDisplayError", "durationdisplay");
        }
        double d2 = d;
        this.taskCopy.setDurationDisplay(d2);
        TimeUnit timeUnit = (TimeUnit)this.durationUnitsCombo.getSelectedItem();
        this.taskCopy.setDurationFormat(timeUnit.getCode());
        Double d3 = this.workTxtField.getValue();
        if (d3 == null) {
            throw new ChangeException("workDisplayError", "workdisplay");
        }
        this.taskCopy.setWorkDisplay(d3);
        timeUnit = (TimeUnit)this.workUnitsCombo.getSelectedItem();
        this.taskCopy.setWorkFormat(timeUnit.getCode());
        String string3 = this.descriptionTA.getText().trim();
        string2 = Workbench.checkInvalidCharacters(string3);
        if (string2 != null) {
            throw new ChangeException(string2, "description");
        }
        this.taskCopy.setNodeDescription(string3);
        if (this.costsSection != null) {
            this.costsSection.updateNodefromFields();
        }
        if ((n = this.tfPriority.getValue()) == null) {
            throw new ChangeException("priorityNumberError", "priority");
        }
        this.taskCopy.setPriority(n);
        if (this.remainSpecified) {
            comparable = this.tfRemain.getValue();
            if (comparable == null || ((Number)((Object)comparable)).doubleValue() < 0.0) {
                throw new ChangeException("remainingWorkError", "remainWork");
            }
            this.taskCopy.setSpecifiedRemainingWork(((Number)((Object)comparable)).doubleValue());
        } else {
            this.taskCopy.setSpecifiedRemainingWork(-1.0);
        }
        if (this.actualWorkSpecified) {
            comparable = this.tfActualWork.getValue();
            if (comparable == null || ((Number)((Object)comparable)).doubleValue() < 0.0) {
                throw new ChangeException("workDisplayError", "actualWork");
            }
            this.taskCopy.setSpecifiedActualWork(((Number)((Object)comparable)).doubleValue());
        } else {
            this.taskCopy.setSpecifiedActualWork(-1.0);
        }
        if (!this.tfActualStart.isEditValid()) {
            throw new ChangeException("invalidDate", "actualstart");
        }
        comparable = this.tfActualStart.getDate();
        if (!this.tfActualFinish.isEditValid()) {
            throw new ChangeException("invalidDate", "actualfinish");
        }
        Date date3 = this.tfActualFinish.getDate();
        this.taskCopy.setActualStartDate((Date)comparable);
        this.taskCopy.setActualFinishDate(date3);
        if (!this.tfDeadline.isEditValid()) {
            throw new ChangeException("invalidDate", "deadline");
        }
        this.taskCopy.setDeadlineDate(this.tfDeadline.getDate());
        SchedulingMode schedulingMode = (SchedulingMode)this.cbSchedulingMode.getSelectedItem();
        this.taskCopy.setSchedulingMode(schedulingMode.getCode());
        if (this.checkSkipAutoReschedule != null) {
            this.taskCopy.setSkipAutoReschedule(this.checkSkipAutoReschedule.isSelected());
        }
        this.taskCopy.setCalendarId((scheduleCalendar = (ScheduleCalendar)this.cbCalendar.getSelectedItem()) == null ? null : scheduleCalendar.getCalendarId());
        this.taskCopy.setIgnoreResourcesCalendar(this.checkIgnoreUserCalendar.isSelected());
        GanttWBS ganttWBS = (GanttWBS)this.wbsEntryCombo.getSelectedItem();
        if (ganttWBS != this.taskCopy.getParent()) {
            String string4 = ganttWBS.getHierarchicalId();
            int n3 = this.ganttCtrl.getModel().getNextTaskSubId(ganttWBS);
            this.taskCopy.setHierarchicalId(string4 + '.' + n3);
            this.taskCopy.setParent(ganttWBS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFieldsFromTask() {
        if (this.updating) {
            throw new IllegalStateException("Update fields in progress");
        }
        this.updating = true;
        try {
            double d;
            this.nameTxtField.setText(this.taskCopy.getName());
            this.idTxtField.setText(this.taskCopy.getHierarchicalId());
            GanttNode ganttNode = (GanttNode)this.taskCopy.getParent();
            this.wbsEntryCombo.setSelectedItem(ganttNode);
            this.statusCombo.setSelectedItem(Status.fromCode(this.taskCopy.getStatus()));
            Double d2 = this.taskCopy.getPercentComplete();
            this.completeTxtField.setValue(d2 == null ? 0 : (int)(d2 * 100.0));
            this.startDatePicker.setDate(this.taskCopy.getDuration().getStart());
            this.endDatePicker.setDate(this.taskCopy.getDuration().getEnd());
            PETimeUnits pETimeUnits = Workbench.get().getTimeUnits();
            this.durationTxtField.setValue(this.taskCopy.getDurationDisplay());
            this.durationUnitsCombo.setSelectedItem(pETimeUnits.fromCode(this.taskCopy.getDurationFormat()));
            this.workTxtField.setValue(this.taskCopy.getWorkDisplay());
            this.workUnitsCombo.setSelectedItem(pETimeUnits.fromCode(this.taskCopy.getWorkFormat()));
            this.descriptionTA.setText(this.taskCopy.getNodeDescription());
            this.resourcesPanel.getTableModel().fireTableDataChanged();
            if (this.costsSection != null) {
                this.costsSection.updateFieldsFromNode();
            }
            this.tfPriority.setValue(this.taskCopy.getPriority());
            if (this.tfWorked != null) {
                this.tfWorked.setText(this.getDecimalFormat().format(this.taskCopy.getTimeSheetHours()));
            }
            if ((d = this.taskCopy.getSpecifiedActualWork()) >= 0.0) {
                this.setActualWorkSpecified(d);
            } else {
                this.setActualWorkComputed();
            }
            double d3 = this.taskCopy.getSpecifiedRemainingWork();
            if (d3 >= 0.0) {
                this.setRemainSpecified(d3);
            } else {
                this.setRemainComputed();
            }
            this.tfActualStart.setDate(this.taskCopy.getActualStartDate());
            this.tfActualFinish.setDate(this.taskCopy.getActualFinishDate());
            this.tfDeadline.setDate(this.taskCopy.getDeadlineDate());
            SchedulingMode schedulingMode = SchedulingMode.fromCode(this.taskCopy.getSchedulingMode());
            this.cbSchedulingMode.setSelectedItem(schedulingMode);
            CalendarAccessor calendarAccessor = this.projectModel.getCalendarAccessor();
            this.cbCalendar.setSelectedItem(calendarAccessor.getCalendar(this.taskCopy.getCalendarId()));
            this.checkIgnoreUserCalendar.setSelected(this.taskCopy.isIgnoreResourcesCalendar());
            if (this.checkSkipAutoReschedule != null) {
                this.checkSkipAutoReschedule.setSelected(this.taskCopy.isSkipAutoReschedule());
            }
        }
        finally {
            this.updating = false;
        }
    }

    protected void setReadonlySchedulingFields(boolean bl) {
        if (this.isEditable()) {
            int n;
            int n2 = this.taskCopy.getSchedulingMode();
            boolean bl2 = this.taskCopy.isDone();
            this.workTxtField.setEditable(!bl2);
            this.workUnitsCombo.setEnabled(!bl2);
            boolean bl3 = !bl2 && (n2 == 1 || n2 == 0);
            this.durationTxtField.setEditable(bl3);
            this.durationUnitsCombo.setEnabled(bl3);
            bl3 = !bl2 && (n2 == 0 || n2 == 1 || n2 == 2);
            this.startDatePicker.setEditable(bl3);
            if (bl2) {
                bl3 = false;
            } else if (n2 == 2 || n2 == 3) {
                bl3 = true;
            } else {
                bl3 = true;
                IPredecessor[] iPredecessorArray = this.taskCopy.getPredecessors();
                for (n = 0; n < iPredecessorArray.length; ++n) {
                    if (iPredecessorArray[n].getType() != 0 && iPredecessorArray[n].getType() != 2) continue;
                    bl3 = false;
                    break;
                }
            }
            this.endDatePicker.setEditable(bl3);
            if (this.costsSection != null) {
                boolean bl4 = this.projectModel.getProjectContext().isFinancialEditable();
                this.costsSection.setEditable(bl4);
            }
            this.tfPriority.setEditable(!bl2);
            this.tfActualStart.setEditable(!bl2);
            this.tfDeadline.setEditable(!bl2);
            this.cbSchedulingMode.setEnabled(!bl2);
            this.cbCalendar.setEnabled(!bl2);
            this.checkIgnoreUserCalendar.setEnabled(!bl2);
            if (this.checkSkipAutoReschedule != null) {
                this.checkSkipAutoReschedule.setEnabled(!bl2);
            }
            this.tfRemain.setEditable(!bl2 && this.remainSpecified);
            this.btRemain.setEnabled(!bl2);
            boolean bl5 = !bl2 && this.taskCopy.isInProgress();
            this.tfActualWork.setEditable(this.actualWorkSpecified && (bl5 || bl2));
            this.btActualWork.setEnabled(!(!bl5 && !bl2 || !(this.taskCopy.getSpecifiedActualWork() >= 0.0) && this.taskCopy.getProjectContext().isActualWorkComputationModeTimesheet()));
            this.resourcesPanel.setEnabled(!bl2);
            this.predecessorsPanel.setEnabled(!bl2);
            bl3 = !bl2 && (n2 == 1 || n2 == 0);
            this.predecessorsPanel.setEnabled(bl3);
            n = !bl2 && this.taskCopy.getPredecessorsCount() > 0 ? 1 : 0;
            this.startDatePicker.setFont(n != 0 ? this.italicFont : this.defaultFont);
            n = !bl2 && n2 == 1 ? 1 : 0;
            this.workTxtField.setFont(n != 0 ? this.italicFont : this.defaultFont);
            n = !bl2 && n2 == 0 ? 1 : 0;
            this.durationTxtField.setFont(n != 0 ? this.italicFont : this.defaultFont);
        }
    }

    protected void setAllFieldsReadonly() {
        if (this.isEditable()) {
            return;
        }
        this.nameTxtField.setEditable(false);
        this.idTxtField.setEditable(false);
        this.wbsEntryCombo.setEnabled(false);
        this.statusCombo.setEnabled(false);
        this.completeTxtField.setEditable(false);
        this.startDatePicker.setEditable(false);
        this.endDatePicker.setEditable(false);
        this.durationTxtField.setEditable(false);
        this.durationUnitsCombo.setEnabled(false);
        this.workTxtField.setEditable(false);
        this.workUnitsCombo.setEnabled(false);
        this.descriptionTA.setEditable(false);
        this.resourcesPanel.setEnabled(false);
        this.predecessorsPanel.setEnabled(false);
        if (this.costsSection != null) {
            this.costsSection.setEditable(false);
        }
        this.tfPriority.setEditable(false);
        this.tfDeadline.setEditable(false);
        this.tfActualStart.setEditable(false);
        this.tfActualFinish.setEditable(false);
        this.tfRemain.setEditable(false);
        this.btRemain.setVisible(false);
        this.tfActualWork.setEditable(false);
        this.btActualWork.setVisible(false);
        this.cbSchedulingMode.setEnabled(false);
        this.cbCalendar.setEnabled(false);
        this.checkIgnoreUserCalendar.setEnabled(false);
        if (this.checkSkipAutoReschedule != null) {
            this.checkSkipAutoReschedule.setEnabled(false);
        }
    }

    private void initAlertPanel() {
        JLabel jLabel = new JLabel(AppGanttChart.NLS_BUNDLE.getString("loadingAlerts"));
        this.alertsPanel = new JPanel(new BorderLayout());
        if (this.originalTask == null) {
            return;
        }
        this.alertsPanel.add((Component)jLabel, "Center");
        IAsyncAction iAsyncAction = new IAsyncAction(){

            public Object awtBeforeRun() throws CancelAsyncActionException {
                return null;
            }

            public Object asyncRun(Object object) throws Throwable {
                AlertManager alertManager = TaskDetailDialog.this.ganttCtrl.getModel().getAlertManager();
                while (!TaskDetailDialog.this.disposed && !alertManager.waitUntilInitialized(1000L)) {
                }
                return null;
            }

            public void awtAfterRun(Object object, Throwable throwable) {
                TaskDetailDialog.this.updateAlerts(true);
            }
        };
        AsyncActionRunner asyncActionRunner = new AsyncActionRunner(iAsyncAction);
        asyncActionRunner.runAction();
    }

    private void updateAlerts(boolean bl) {
        Serializable serializable;
        Serializable serializable2;
        if (this.alertsPanel == null) {
            return;
        }
        AlertManager alertManager = this.ganttCtrl.getModel().getAlertManager();
        TaskAlert[] taskAlertArray = alertManager.computeAlerts(this.taskCopy);
        Dimension dimension = this.getSize();
        JPanel jPanel = null;
        if (taskAlertArray != null && taskAlertArray.length > 0) {
            serializable2 = new GridLayout(taskAlertArray.length, 1);
            jPanel = new JPanel((LayoutManager)((Object)serializable2));
            for (int i = 0; i < taskAlertArray.length; ++i) {
                serializable = WDUtil.getIcon(taskAlertArray[i].getIconName());
                JLabel jLabel = new JLabel(taskAlertArray[i].getMessage(), (Icon)((Object)serializable), 2);
                jLabel.setHorizontalTextPosition(4);
                jPanel.add(jLabel);
            }
            jPanel.validate();
        }
        this.alertsPanel.removeAll();
        if (jPanel != null) {
            this.alertsPanel.add(jPanel);
        }
        this.alertsPanel.revalidate();
        if (bl && jPanel != null) {
            serializable2 = this.getPreferredSize();
            Point point = this.getLocation();
            serializable = WDUtil.getDisplayBounds(this.getGraphicsConfiguration());
            if (((Dimension)serializable2).width > dimension.width) {
                point.x = Math.max(serializable.x, point.x - (((Dimension)serializable2).width - dimension.width));
            }
            if (((Dimension)serializable2).height > dimension.height) {
                point.y = Math.max(serializable.y, point.y - (((Dimension)serializable2).height - dimension.height));
            }
            ((Dimension)serializable2).width = Math.min(((Dimension)serializable2).width, serializable.width);
            ((Dimension)serializable2).height = Math.min(((Dimension)serializable2).height, serializable.height);
            this.setBounds(point.x, point.y, ((Dimension)serializable2).width, ((Dimension)serializable2).height);
        }
    }

    private JPanel createButtonsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.okButton = WDUtil.createOkButton();
        jPanel.add(this.okButton);
        this.okButton.addActionListener(this);
        if (this.isEditable()) {
            WDButton wDButton = WDUtil.createCancelButton();
            jPanel.add(wDButton);
            wDButton.addActionListener(this);
        }
        return jPanel;
    }

    private WDDatePicker createDatePicker() {
        WDDatePicker wDDatePicker = new WDDatePicker(this.ganttCtrl.getDateLocale());
        wDDatePicker.setShowTime(this.isTimePrecision());
        return wDDatePicker;
    }

    protected void setRemainComputed() {
        double d = this.taskCopy.getEstimatedRemainingWork();
        String string = '(' + this.getDecimalFormat().format(d) + ')';
        this.tfRemain.setText(string);
        this.tfRemain.setEditable(false);
        this.btRemain.setText(' ' + AppGanttChart.NLS_BUNDLE.getString("remainWorkSpecify") + ' ');
        this.remainSpecified = false;
    }

    protected void setRemainSpecified(double d) {
        this.tfRemain.setValue(d);
        this.tfRemain.setEditable(true);
        this.btRemain.setText(' ' + AppGanttChart.NLS_BUNDLE.getString("remainWorkAuto") + ' ');
        this.remainSpecified = true;
    }

    protected void setActualWorkComputed() {
        double d = this.taskCopy.getEstimatedActualWork();
        String string = '(' + this.getDecimalFormat().format(d) + ')';
        this.tfActualWork.setText(string);
        this.tfActualWork.setEditable(false);
        this.btActualWork.setText(' ' + AppGanttChart.NLS_BUNDLE.getString("remainWorkSpecify") + ' ');
        this.actualWorkSpecified = false;
    }

    protected void setActualWorkSpecified(double d) {
        this.tfActualWork.setValue(d);
        this.tfActualWork.setEditable(true);
        this.btActualWork.setText(' ' + AppGanttChart.NLS_BUNDLE.getString("remainWorkAuto") + ' ');
        this.actualWorkSpecified = true;
    }

    protected boolean calculateComputedFields() {
        try {
            this.updateTaskFromFields();
        }
        catch (Exception exception) {
            this.handleException(exception);
            return false;
        }
        TaskUpdater taskUpdater = new TaskUpdater(null, this.taskCopy, this.ganttCtrl.getModel(), this, 0);
        try {
            taskUpdater.checkAndCompute();
            taskUpdater.beforeUpdate();
        }
        catch (ChangeException changeException) {
            this.handleException(changeException);
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            WDDialog.showMsgDialog(this, AppGanttChart.NLS_BUNDLE.getString("schedule_commputation_error"));
            return false;
        }
        this.updateFieldsFromTask();
        this.resourcesPanel.updateHighlightedRows();
        this.setReadonlySchedulingFields(false);
        this.updateAlerts(false);
        return true;
    }

    protected void handleException(Exception exception) {
        ChangeException changeException;
        if (exception instanceof ChangeException && (changeException = (ChangeException)exception).getField() != null) {
            String string = changeException.getField();
            if (string == "name") {
                this.setFocus(this.nameTxtField);
            } else if (string == "status") {
                this.setFocus(this.statusCombo);
            } else if (string == "percentComplete") {
                this.setFocus(this.completeTxtField);
            } else if (string == "startDate") {
                this.setFocus(this.startDatePicker);
            } else if (string == "endDate") {
                this.setFocus(this.endDatePicker);
            } else if (string == "durationInHours" || string == "durationdisplay") {
                this.setFocus(this.durationTxtField);
            } else if (string == "work" || string == "workdisplay") {
                this.setFocus(this.workTxtField);
            } else if (string == "description") {
                this.setFocus(this.descriptionTA);
            } else if (string == "priority") {
                this.advancedSection.expand();
                this.setFocus(this.tfPriority);
            } else if (string == "actualstart") {
                this.advancedSection.expand();
                this.setFocus(this.tfActualStart);
            } else if (string == "actualfinish") {
                this.advancedSection.expand();
                this.setFocus(this.tfActualFinish);
            } else if (string == "deadline") {
                this.advancedSection.expand();
                this.setFocus(this.tfDeadline);
            } else if (string == "schedulingmode") {
                this.advancedSection.expand();
                this.setFocus(this.cbSchedulingMode);
            } else if (string == "parentInternalId") {
                this.setFocus(this.wbsEntryCombo);
            } else if (string == "remainWork") {
                this.setFocus(this.tfRemain);
            } else if (string == "actualWork") {
                this.advancedSection.expand();
                this.setFocus(this.tfActualWork);
            } else {
                if (string == "additionalcost") {
                    this.costsSection.expand();
                    this.setFocus(this.costsSection.tfAdditionalCost);
                    return;
                }
                if (string == "actualadditionalcost") {
                    this.costsSection.expand();
                    this.setFocus(this.costsSection.tfActualAdditionalCost);
                    return;
                }
                if (string == "additionalcostdescription") {
                    this.costsSection.expand();
                    this.costsSection.additionCostDescriptionTA.requestFocus();
                }
            }
        }
        WDDialog.showErrorMsgDialog(this, exception);
    }

    protected void setFocus(JComponent jComponent) {
        ((JComponent)jComponent.getParent()).scrollRectToVisible(jComponent.getBounds());
        jComponent.requestFocus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton && this.isEditable()) {
            boolean bl = false;
            try {
                this.updateTaskFromFields();
                bl = true;
                if (this.insertAfter != null && this.taskCopy.getParent() == this.insertAfter.getParent()) {
                    GanttWBS ganttWBS = (GanttWBS)this.taskCopy.getParent();
                    int n = this.ganttCtrl.getModel().getNextTaskSubId(ganttWBS);
                    this.taskCopy.setHierarchicalId(ganttWBS.getHierarchicalId() + '.' + n);
                    if (!this.ganttCtrl.getModel().checkComputeAndUpdateTaskValues(this.originalTask, this.taskCopy, this, 100)) {
                        return;
                    }
                    int n2 = this.insertAfter.getSubId() + 1;
                    this.ganttCtrl.getModel().reorderNodeToPosition(this.taskCopy, n2, true);
                } else if (!this.ganttCtrl.getModel().checkComputeAndUpdateTaskValues(this.originalTask, this.taskCopy, this, 100)) {
                    return;
                }
                if (this.originalTask == null) {
                    if (this.taskCopy.getStartDate().after(this.ganttCtrl.getDisplayEndDate()) || this.taskCopy.getFinishDate().before(this.ganttCtrl.getDisplayStartDate())) {
                        this.ganttCtrl.centerGraphOnNode(this.taskCopy);
                    }
                    this.ganttCtrl.scrollToNode(this.taskCopy);
                }
            }
            catch (Exception exception) {
                if (bl) {
                    this.updateFieldsFromTask();
                }
                this.handleException(exception);
                return;
            }
            this.dispose();
            if (this.callback != null) {
                this.callback.actionDone();
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (TaskDetailDialog.this.originalTask != null) {
                        TaskDetailDialog.this.ganttCtrl.setSelectedNode(TaskDetailDialog.this.originalTask);
                    } else {
                        TaskDetailDialog.this.ganttCtrl.setSelectedNode(TaskDetailDialog.this.taskCopy);
                    }
                }
            });
        } else if (object == this.btRemain) {
            if (this.remainSpecified) {
                this.setRemainComputed();
            } else {
                double d = this.roundTo2DecimalDigits(this.taskCopy.getEstimatedRemainingWork());
                this.setRemainSpecified(d);
                this.tfRemain.selectAll();
                this.tfRemain.requestFocusInWindow();
            }
        } else if (object == this.btActualWork) {
            if (this.actualWorkSpecified) {
                this.setActualWorkComputed();
            } else {
                double d = this.roundTo2DecimalDigits(this.taskCopy.getEstimatedActualWork());
                this.setActualWorkSpecified(d);
                this.tfActualWork.selectAll();
                this.tfActualWork.requestFocusInWindow();
            }
        } else {
            this.dispose();
            if (this.callback != null) {
                this.callback.actionCancelled();
            }
        }
    }

    private double roundTo2DecimalDigits(double d) {
        return (double)Math.round(d * 100.0) / 100.0;
    }

    public void close() {
        super.close();
        if (this.callback != null) {
            this.callback.actionCancelled();
        }
    }

    protected boolean isEditable() {
        return this.ganttCtrl.isEditable() && this.ganttCtrl.getModel().isProjectScheduleEditable(this.taskCopy);
    }

    public void dispose() {
        this.disposed = true;
        super.dispose();
    }

    protected void parentModified() {
        if (this.updating) {
            return;
        }
        GanttWBS ganttWBS = (GanttWBS)this.wbsEntryCombo.getSelectedItem();
        if (ganttWBS != null) {
            if (this.originalTask != null && ganttWBS == this.originalTask.getParent()) {
                this.idTxtField.setText(this.originalTask.getHierarchicalId());
            } else {
                int n = this.insertAfter != null && this.insertAfter.getParent() == ganttWBS ? this.insertAfter.getSubId() + 1 : this.ganttCtrl.getModel().getNextTaskSubId(ganttWBS);
                this.idTxtField.setText(ganttWBS.getHierarchicalId() + '.' + n);
            }
        }
    }

    protected void statusModified() {
        if (this.updating) {
            return;
        }
        String string = this.taskCopy.getStatus();
        int n = this.completeTxtField.getIntValue();
        Status status = (Status)this.statusCombo.getSelectedItem();
        if (status == Status.DONE) {
            this.completeTxtField.setValue(100);
        } else if (status == Status.PENDING) {
            this.tfActualStart.setDate(null);
            this.tfActualFinish.setDate(null);
            this.completeTxtField.setValue(0);
        } else {
            this.tfActualFinish.setDate(null);
            if (n == 100) {
                this.completeTxtField.setValue(99);
            } else if (this.tfActualStart.getDate() == null) {
                this.tfActualStart.setDate((Date)this.taskCopy.getStartDate().clone());
            }
        }
        if (!this.calculateComputedFields()) {
            this.taskCopy.setStatus(string);
            this.statusCombo.setSelectedItem(Status.fromCode(string));
            this.completeTxtField.setValue(n);
            this.setReadonlySchedulingFields(false);
        }
    }

    protected void resourcesModified() {
        if (this.updating) {
            return;
        }
        this.calculateComputedFields();
    }

    protected void predecessorsModified() {
        if (this.updating) {
            return;
        }
        this.calculateComputedFields();
    }

    protected void schedulingModeModified() {
        if (!this.isEditable() || this.updating) {
            return;
        }
        SchedulingMode schedulingMode = SchedulingMode.fromCode(this.taskCopy.getSchedulingMode());
        SchedulingMode schedulingMode2 = (SchedulingMode)this.cbSchedulingMode.getSelectedItem();
        if ((schedulingMode2 == SchedulingMode.DEADLINE_DRIVEN || schedulingMode2 == SchedulingMode.FORCE_DATES) && this.taskCopy.hasPredecessors()) {
            if (!WDDialog.showYesNoDialog(this, AppGanttChart.NLS_BUNDLE.getString("scheduling_constraint_no_predecessor"))) {
                this.cbSchedulingMode.setSelectedItem(schedulingMode);
                return;
            }
            this.taskCopy.getPredecessorsList().clear();
            this.predecessorsPanel.update();
        }
        if (!this.calculateComputedFields()) {
            this.cbSchedulingMode.setSelectedItem(schedulingMode);
            this.taskCopy.setSchedulingMode(schedulingMode.getCode());
        }
        this.setReadonlySchedulingFields(false);
    }

    private void pctCompleteModified() {
        if (this.updating) {
            return;
        }
        this.calculateComputedFields();
    }

    private void durationModified() {
        if (this.updating) {
            return;
        }
        if (this.taskCopy.getSchedulingMode() != 0) {
            this.calculateComputedFields();
            return;
        }
        int n = this.taskCopy.getDurationFormat();
        double d = this.taskCopy.getDurationDisplay();
        TimeUnit timeUnit = (TimeUnit)this.durationUnitsCombo.getSelectedItem();
        if (timeUnit == null) {
            return;
        }
        int n2 = timeUnit.getCode();
        double d2 = this.durationTxtField.getDoubleValue();
        if (d2 == d && n == n2) {
            return;
        }
        PETimeUnits pETimeUnits = Workbench.get().getTimeUnits();
        try {
            this.updateTaskFromFields();
        }
        catch (Exception exception) {
            this.handleException(exception);
            this.durationTxtField.setValue(d);
            this.taskCopy.setDurationDisplay(d);
            this.durationUnitsCombo.setSelectedItem(pETimeUnits.fromCode(n));
            this.taskCopy.setDurationFormat(n);
            return;
        }
        WorkOrDurationEditQuestionDialog workOrDurationEditQuestionDialog = WorkOrDurationEditQuestionDialog.create(this, false);
        workOrDurationEditQuestionDialog.setLocationRelativeTo(this);
        workOrDurationEditQuestionDialog.setVisible(true);
        if (workOrDurationEditQuestionDialog.getResult() == 2) {
            try {
                AppScheduleComputation appScheduleComputation = this.projectModel.getScheduleComputation();
                TGDuration tGDuration = new TGDuration(d2, pETimeUnits.fromCode(n2));
                appScheduleComputation.setWorkFromDuration(this.taskCopy, tGDuration);
                this.updateFieldsFromTask();
                this.calculateComputedFields();
            }
            catch (Exception exception) {
                WDDialog.showErrorMsgDialog(this, exception);
            }
        } else if (workOrDurationEditQuestionDialog.getResult() == 1) {
            this.cbSchedulingMode.setSelectedItem(SchedulingMode.DURATION_DRIVEN);
            this.calculateComputedFields();
        } else {
            this.durationTxtField.setValue(d);
            this.taskCopy.setDurationDisplay(d);
            this.durationUnitsCombo.setSelectedItem(pETimeUnits.fromCode(n));
            this.taskCopy.setDurationFormat(n);
            return;
        }
    }

    private void workModified() {
        if (this.updating) {
            return;
        }
        if (this.taskCopy.getSchedulingMode() != 1) {
            this.calculateComputedFields();
            return;
        }
        int n = this.taskCopy.getWorkFormat();
        double d = this.taskCopy.getWorkDisplay();
        TimeUnit timeUnit = (TimeUnit)this.workUnitsCombo.getSelectedItem();
        if (timeUnit == null) {
            return;
        }
        int n2 = timeUnit.getCode();
        double d2 = this.workTxtField.getDoubleValue();
        if (d2 == d && n == n2) {
            return;
        }
        PETimeUnits pETimeUnits = Workbench.get().getTimeUnits();
        try {
            this.updateTaskFromFields();
        }
        catch (Exception exception) {
            this.handleException(exception);
            this.workTxtField.setValue(d);
            this.taskCopy.setWorkDisplay(d);
            this.workUnitsCombo.setSelectedItem(pETimeUnits.fromCode(n));
            this.taskCopy.setWorkFormat(n);
            return;
        }
        WorkOrDurationEditQuestionDialog workOrDurationEditQuestionDialog = WorkOrDurationEditQuestionDialog.create(this, true);
        workOrDurationEditQuestionDialog.setLocationRelativeTo(this);
        workOrDurationEditQuestionDialog.setVisible(true);
        if (workOrDurationEditQuestionDialog.getResult() == 2) {
            try {
                AppScheduleComputation appScheduleComputation = this.projectModel.getScheduleComputation();
                TGDuration tGDuration = new TGDuration(d2, pETimeUnits.fromCode(n2));
                appScheduleComputation.setDurationFromWork(this.taskCopy, tGDuration);
                this.updateFieldsFromTask();
                this.calculateComputedFields();
            }
            catch (Exception exception) {
                WDDialog.showErrorMsgDialog(this, exception);
            }
        } else if (workOrDurationEditQuestionDialog.getResult() == 1) {
            this.cbSchedulingMode.setSelectedItem(SchedulingMode.EFFORT_DRIVEN);
            this.calculateComputedFields();
        } else {
            this.workTxtField.setValue(d);
            this.taskCopy.setWorkDisplay(d);
            this.workUnitsCombo.setSelectedItem(pETimeUnits.fromCode(n));
            this.taskCopy.setWorkFormat(n);
            return;
        }
    }

    private boolean isTimePrecision() {
        return this.ganttCtrl.getModel().getGlobalContext().isTimePrecision();
    }

    private void startDateModified(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        String string;
        Date date = (Date)propertyChangeEvent.getNewValue();
        Date date2 = (Date)propertyChangeEvent.getOldValue();
        if (date == null) {
            this.startDatePicker.setDate(date2);
            return;
        }
        if (date == date2 || date.equals(date2)) {
            return;
        }
        if (!this.isTimePrecision() && this.projectModel.getScheduleComputation().isSameDay(date, date2)) {
            return;
        }
        if (!this.isWorkingDay(date) && !WDDialog.showYesNoDialog((Component)this.endDatePicker, string = ((NLSBundle)(object = AppGanttChart.NLS_BUNDLE)).getString("not_starting_working_day") + '\n' + ((NLSBundle)object).getString("auto_adjust_nextdate"), true)) {
            this.startDatePicker.setDate(date2);
            return;
        }
        if (this.taskCopy.getPredecessorsCount() > 0) {
            object = StartEditWithPredecessorQuestionDialog.create(this);
            ((WDDialog)object).setLocationRelativeTo(this);
            ((WDDialog)object).setVisible(true);
            if (((StartEditWithPredecessorQuestionDialog)object).getResult() == 1) {
                this.taskCopy.getPredecessorsList().clear();
                this.predecessorsPanel.update();
            } else {
                this.startDatePicker.setDate(date2);
                return;
            }
        }
        this.calculateComputedFields();
    }

    private void endDateModified(PropertyChangeEvent propertyChangeEvent) {
        NLSBundle nLSBundle;
        Object object;
        Date date = (Date)propertyChangeEvent.getNewValue();
        Date date2 = (Date)propertyChangeEvent.getOldValue();
        if (date == null) {
            this.endDatePicker.setDate(date2);
            return;
        }
        if (date == date2 || date.equals(date2)) {
            return;
        }
        AppScheduleComputation appScheduleComputation = this.projectModel.getScheduleComputation();
        if (!this.isTimePrecision() && appScheduleComputation.isSameDay(date, date2)) {
            return;
        }
        if (!this.isWorkingDay(date) && !WDDialog.showYesNoDialog((Component)this.endDatePicker, (String)(object = (nLSBundle = AppGanttChart.NLS_BUNDLE).getString("not_finishing_working_day") + '\n' + nLSBundle.getString("auto_adjust_previousdate")), true)) {
            this.endDatePicker.setDate(date2);
            return;
        }
        int n = this.taskCopy.getSchedulingMode();
        if (n == 1 || n == 0) {
            if (date.before(this.taskCopy.getStartDate()) && (!appScheduleComputation.isSameDay(date, this.taskCopy.getStartDate()) || new TGTime(date).toMinutes() != 0L)) {
                object = WDDialog.createMsgDialog((Component)this, AppGanttChart.NLS_BUNDLE.getString("startAfterEnd"));
                ((WDDialog)object).setLocationRelativeTo(this);
                ((WDDialog)object).setVisible(true);
                ((Window)object).dispose();
                this.endDatePicker.setDate(date2);
                return;
            }
            try {
                this.updateTaskFromFields();
            }
            catch (Exception exception) {
                this.handleException(exception);
                this.endDatePicker.setDate(date2);
                return;
            }
            try {
                appScheduleComputation.setDurationFromDates(this.taskCopy, date);
                this.updateFieldsFromTask();
                this.calculateComputedFields();
            }
            catch (Exception exception) {
                WDDialog.showErrorMsgDialog(this, exception);
            }
        } else if (!this.calculateComputedFields()) {
            this.endDatePicker.setDate(date2);
        }
    }

    private void actualDateModified(PropertyChangeEvent propertyChangeEvent) {
        if (this.updating) {
            return;
        }
        Date date = (Date)propertyChangeEvent.getOldValue();
        if (!this.calculateComputedFields()) {
            WDDatePicker wDDatePicker = (WDDatePicker)propertyChangeEvent.getSource();
            wDDatePicker.setDate(date);
            wDDatePicker.requestFocus();
        }
    }

    protected class MinMaxIntTextField
    extends IntTextField {
        int min;
        int max;
        String msgKey;

        MinMaxIntTextField(int n, int n2, String string) {
            super(TaskDetailDialog.this.ganttCtrl.getDateLocale());
            this.min = n;
            this.max = n2;
            this.msgKey = string;
        }

        protected NumberTextField.ParseResult parse(String string) {
            int n;
            NumberTextField.ParseResult parseResult = super.parse(string);
            int n2 = n = parseResult.value == null ? -1 : parseResult.value.intValue();
            if (!parseResult.valid || n < this.min || n > this.max) {
                parseResult.valid = false;
                parseResult.errorMessage = AppGanttChart.NLS_BUNDLE.getString(this.msgKey);
            }
            return parseResult;
        }
    }

    protected class NameInputVerifier
    extends InputVerifier {
        private Border invalidBorder = BorderFactory.createLineBorder(Color.RED);
        private Border okBorder;

        protected NameInputVerifier() {
        }

        public boolean verify(JComponent jComponent) {
            return ((JTextField)jComponent).getText().length() > 0;
        }

        public boolean shouldYieldFocus(JComponent jComponent) {
            Border border = jComponent.getBorder();
            if (this.verify(jComponent)) {
                if (border == this.invalidBorder) {
                    jComponent.setBorder(this.okBorder);
                    jComponent.setToolTipText(null);
                    this.okBorder = null;
                }
                return true;
            }
            if (border != this.invalidBorder) {
                this.okBorder = border;
                jComponent.setBorder(this.invalidBorder);
            }
            jComponent.setToolTipText(AppGanttChart.NLS_BUNDLE.getString("name_empty"));
            return false;
        }
    }

    protected class PositiveDoubleTextField
    extends DoubleTextField {
        private String msgKey;

        public PositiveDoubleTextField(String string) {
            super(TaskDetailDialog.this.ganttCtrl.getDateLocale());
            this.msgKey = string;
            this.getNumberFormat().setMaximumFractionDigits(2);
        }

        protected NumberTextField.ParseResult parse(String string) {
            double d;
            NumberTextField.ParseResult parseResult = super.parse(string);
            double d2 = d = parseResult.value == null ? -1.0 : parseResult.value.doubleValue();
            if (!parseResult.valid || d < 0.0) {
                parseResult.valid = false;
                parseResult.errorMessage = AppGanttChart.NLS_BUNDLE.getString(this.msgKey);
            }
            return parseResult;
        }
    }
}

