/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.pe.app.alerts;

import com.triloggroup.gantt.GanttChartException;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.pe.app.alerts.AlertDefinition;
import com.triloggroup.gantt.pe.app.alerts.TaskAlert;
import com.triloggroup.gantt.pe.app.ws.GanttWSHelper;
import com.triloggroup.pe.schedule.AlertCst;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.jdom.Element;

public class AlertManager
implements AlertCst {
    private boolean loaded = false;
    private boolean loading = false;
    private AlertDefinition[] alertDefs;

    public void loadAsync(final GanttWSHelper ganttWSHelper) {
        new Thread(){

            public void run() {
                try {
                    AlertManager.this.load(ganttWSHelper);
                }
                catch (GanttChartException ganttChartException) {
                    ganttChartException.printStackTrace();
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(GanttWSHelper ganttWSHelper) throws GanttChartException {
        AlertManager alertManager = this;
        synchronized (alertManager) {
            if (this.loading) {
                return;
            }
            this.loading = true;
            if (this.loaded) {
                this.loaded = false;
                this.alertDefs = null;
            }
        }
        try {
            alertManager = ganttWSHelper.getAlertsMetadataFromWS();
            Element element = alertManager.getChild("alertDefs");
            List list = element.getChildren("alertDefs");
            this.alertDefs = new AlertDefinition[list.size()];
            for (int i = 0; i < this.alertDefs.length; ++i) {
                element = (Element)list.get(i);
                this.alertDefs[i] = AlertDefinition.decode(element.getText());
            }
            Arrays.sort(this.alertDefs);
            AlertManager alertManager2 = this;
            synchronized (alertManager2) {
                this.loaded = true;
                this.notifyAll();
            }
        }
        catch (Exception exception) {
            if (exception instanceof GanttChartException) {
                throw (GanttChartException)exception;
            }
            throw new GanttChartException(2, "Error to get task alerts metadata", exception);
        }
        finally {
            this.loading = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilInitialized(long l) {
        if (this.loaded) {
            return true;
        }
        AlertManager alertManager = this;
        synchronized (alertManager) {
            if (this.loaded) {
                return true;
            }
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.loaded;
        }
    }

    public TaskAlert[] computeAlerts(GanttTask ganttTask) {
        if (!this.loaded) {
            return null;
        }
        ArrayList<TaskAlert> arrayList = new ArrayList<TaskAlert>();
        for (int i = this.alertDefs.length - 1; i >= 0; --i) {
            double d;
            AlertDefinition alertDefinition = this.alertDefs[i];
            if (alertDefinition.id.equals("Event_00000004") && this.taskLateAndNotStarted(ganttTask)) {
                arrayList.add(new TaskAlert(alertDefinition.message, alertDefinition.level));
            }
            if (alertDefinition.id.equals("Event_00000005") && this.taskStartedLate(ganttTask)) {
                arrayList.add(new TaskAlert(alertDefinition.message, alertDefinition.level));
            }
            if (alertDefinition.id.equals("Event_00000009") && (d = this.taskTookMoreHours(ganttTask)) > 0.0 && d >= alertDefinition.parameter) {
                arrayList.add(new TaskAlert(alertDefinition.message, alertDefinition.level));
            }
            if (alertDefinition.id.equals("Event_00000002") && this.taskEndedLate(ganttTask)) {
                arrayList.add(new TaskAlert(alertDefinition.message, alertDefinition.level));
            }
            if (alertDefinition.id.equals("Event_00000007") && this.taskLateAndNotEnded(ganttTask)) {
                arrayList.add(new TaskAlert(alertDefinition.message, alertDefinition.level));
            }
            if (alertDefinition.id.equals("Event_00000008") && (d = this.taskProgressIsSlow(ganttTask)) > 0.0 && d >= alertDefinition.parameter) {
                arrayList.add(new TaskAlert(alertDefinition.message, alertDefinition.level));
            }
            if (!alertDefinition.id.equals("Event_00000011") || !this.taskPlannedExceededDeadline(ganttTask)) continue;
            arrayList.add(new TaskAlert(alertDefinition.message, alertDefinition.level));
        }
        return arrayList.toArray(new TaskAlert[0]);
    }

    private boolean taskStartedLate(GanttTask ganttTask) {
        return ganttTask.getActualStartDate() != null && ganttTask.getActualStartDate().after(ganttTask.getStartDate());
    }

    private boolean taskLateAndNotStarted(GanttTask ganttTask) {
        if (ganttTask.getActualStartDate() != null) {
            return false;
        }
        if (!ganttTask.isPending()) {
            return false;
        }
        Date date = new Date();
        return date.after(ganttTask.getStartDate());
    }

    private double taskTookMoreHours(GanttTask ganttTask) {
        double d;
        if (ganttTask.getActualStartDate() == null) {
            return 0.0;
        }
        double d2 = ganttTask.getTimeSheetHours();
        if (d2 > (d = ganttTask.getWorkInHours())) {
            return (d2 - d) / d * 100.0;
        }
        return 0.0;
    }

    private boolean taskEndedLate(GanttTask ganttTask) {
        if (ganttTask.getActualStartDate() == null) {
            return false;
        }
        return ganttTask.getActualFinishDate() != null && ganttTask.getActualFinishDate().after(ganttTask.getFinishDate());
    }

    private boolean taskLateAndNotEnded(GanttTask ganttTask) {
        if (ganttTask.getActualFinishDate() != null) {
            return false;
        }
        Date date = new Date();
        return date.after(ganttTask.getFinishDate());
    }

    private double taskProgressIsSlow(GanttTask ganttTask) {
        if (!ganttTask.isInProgress()) {
            return 0.0;
        }
        long l = System.currentTimeMillis();
        long l2 = ganttTask.getStartDate().getTime();
        long l3 = ganttTask.getFinishDate().getTime();
        double d = l3 < l ? 100.0 : (l2 > l ? 0.0 : (double)(l - l2) / (double)(l3 - l2) * 100.0);
        if ((double)ganttTask.getPercentage() < d) {
            return d - (double)ganttTask.getPercentage();
        }
        return 0.0;
    }

    private boolean taskPlannedExceededDeadline(GanttTask ganttTask) {
        return ganttTask.getFinishDate() != null && ganttTask.getDeadlineDate() != null && ganttTask.getFinishDate().getTime() - ganttTask.getDeadlineDate().getTime() > 1000L;
    }
}

