/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.pe.app;

import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.gantt.pe.app.ws.GanttWSHelper;
import com.triloggroup.project.schedule.ScheduleCalendar;
import com.triloggroup.util.UString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;

public class CalendarAccessor {
    protected String prjCalendarId;
    protected HashMap<String, ScheduleCalendar> calendars;
    protected ScheduleCalendar[] baseCalendars;

    public CalendarAccessor(GanttWSHelper ganttWSHelper) {
        this.loadCalendars(ganttWSHelper);
    }

    public ScheduleCalendar getProjectCalendar() {
        return this.getCalendar(this.prjCalendarId);
    }

    public ScheduleCalendar getTaskCalendar(GanttTask ganttTask) {
        String string = ganttTask.getCalendarId();
        if (!UString.isEmpty(string)) {
            return this.getCalendar(string);
        }
        return null;
    }

    public ScheduleCalendar[] getTaskCalendars(GanttTask ganttTask) {
        try {
            boolean bl = ganttTask.isIgnoreResourcesCalendar();
            TaskResource[] taskResourceArray = ganttTask.getResources();
            ScheduleCalendar[] scheduleCalendarArray = null;
            if (taskResourceArray != null) {
                ScheduleCalendar scheduleCalendar = this.getTaskCalendar(ganttTask);
                ScheduleCalendar scheduleCalendar2 = this.getProjectCalendar();
                scheduleCalendarArray = new ScheduleCalendar[taskResourceArray.length];
                for (int i = 0; i < taskResourceArray.length; ++i) {
                    String string;
                    if (!bl && !UString.isEmpty(string = taskResourceArray[i].getResource().getCalendarId())) {
                        scheduleCalendarArray[i] = this.getCalendar(string);
                    }
                    if (scheduleCalendarArray[i] != null) continue;
                    scheduleCalendarArray[i] = scheduleCalendar != null ? scheduleCalendar : scheduleCalendar2;
                }
            } else {
                scheduleCalendarArray = new ScheduleCalendar[]{};
            }
            return scheduleCalendarArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public ScheduleCalendar[] getBaseCalendars() {
        return this.baseCalendars;
    }

    public ScheduleCalendar getCalendar(String string) {
        String string2;
        ScheduleCalendar scheduleCalendar = this.calendars.get(string);
        if (!(scheduleCalendar == null || scheduleCalendar.isBaseCalendar() || scheduleCalendar.isMergedWithBaseCalendar() || UString.isEmpty(string2 = scheduleCalendar.getBaseCalendarId()))) {
            ScheduleCalendar scheduleCalendar2 = this.getCalendar(string2);
            if (scheduleCalendar2 != null) {
                scheduleCalendar.mergeWithBaseCalendar(scheduleCalendar2);
            } else {
                System.out.println("nnn");
            }
        }
        return scheduleCalendar;
    }

    private void loadCalendars(GanttWSHelper ganttWSHelper) {
        this.calendars = new HashMap();
        try {
            Document document = ganttWSHelper.getCalendarsFromWS();
            Element element = document.getRootElement();
            this.prjCalendarId = element.getAttributeValue("projectCalendarId");
            ArrayList<ScheduleCalendar> arrayList = new ArrayList<ScheduleCalendar>();
            List list = element.getChildren("calendar");
            if (list != null) {
                Element[] elementArray = new Element[list.size()];
                elementArray = list.toArray(elementArray);
                for (int i = 0; i < elementArray.length; ++i) {
                    Element element2 = elementArray[i];
                    element2.detach();
                    ScheduleCalendar scheduleCalendar = new ScheduleCalendar(element2);
                    this.calendars.put(scheduleCalendar.getCalendarId(), scheduleCalendar);
                    if (!scheduleCalendar.isBaseCalendar()) continue;
                    arrayList.add(scheduleCalendar);
                }
            }
            this.baseCalendars = arrayList.toArray(new ScheduleCalendar[0]);
            Arrays.sort(this.baseCalendars, new Comparator<ScheduleCalendar>(){

                @Override
                public int compare(ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2) {
                    String string = scheduleCalendar.getName();
                    String string2 = scheduleCalendar2.getName();
                    if (string == null) {
                        return string2 == null ? 0 : -1;
                    }
                    return string.compareTo(string2);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

