/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.ui;

import com.triloggroup.gantt.app.GanttKeyStrokes;
import com.triloggroup.gantt.app.ui.WDButton;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.util.UString;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class WDUtil {
    public static Color PE_BLUE = new Color(235, 241, 249);
    private static final HashMap<String, ImageIcon> iconCache = new HashMap();

    public static ImageIcon getIcon(String string) {
        return WDUtil.getIcon(string, true);
    }

    private static ImageIcon getIcon(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        String string2 = bl ? "com/triloggroup/gantt/app/resources/" + string : string;
        ImageIcon imageIcon = iconCache.get(string2);
        if (imageIcon != null) {
            return imageIcon;
        }
        URL uRL = WDUtil.class.getClassLoader() != null ? WDUtil.class.getClassLoader().getResource(string2) : Thread.currentThread().getContextClassLoader().getResource(string2);
        if (uRL == null) {
            return null;
        }
        imageIcon = new ImageIcon(uRL);
        iconCache.put(string2, imageIcon);
        return imageIcon;
    }

    private static String nls(String string) {
        return Workbench.getNLSString(string, new Object[0]);
    }

    public static WDButton createOkButton() {
        WDButton wDButton = new WDButton(WDUtil.nls("ok_button"), WDUtil.getIcon("ok.gif"));
        InputMap inputMap = wDButton.getInputMap(2);
        inputMap.put(GanttKeyStrokes.OK_PRESSED, "pressed");
        inputMap.put(GanttKeyStrokes.OK_RELEASED, "released");
        return wDButton;
    }

    public static WDButton createCancelButton() {
        WDButton wDButton = new WDButton(WDUtil.nls("cancel_button"), WDUtil.getIcon("close.gif"));
        InputMap inputMap = wDButton.getInputMap(2);
        inputMap.put(GanttKeyStrokes.CANCEL_PRESSED, "pressed");
        inputMap.put(GanttKeyStrokes.CANCEL_RELEASED, "released");
        return wDButton;
    }

    public static WDButton createApplyButton() {
        return new WDButton(WDUtil.nls("apply_button"), WDUtil.getIcon("ok.gif"));
    }

    public static Rectangle getDisplayBounds(Component component) {
        GraphicsConfiguration graphicsConfiguration = WDUtil.getGraphicsConfiguration(component);
        return WDUtil.getDisplayBounds(graphicsConfiguration);
    }

    public static Rectangle getDisplayBounds(Point point) {
        GraphicsConfiguration graphicsConfiguration = WDUtil.getGraphicsConfiguration(point);
        return WDUtil.getDisplayBounds(graphicsConfiguration);
    }

    public static Rectangle getDisplayBounds(GraphicsConfiguration graphicsConfiguration) {
        Rectangle rectangle = graphicsConfiguration.getBounds();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        return rectangle;
    }

    public static GraphicsConfiguration getGraphicsConfiguration(Component component) {
        if (component != null) {
            if (component.isShowing()) {
                return WDUtil.getGraphicsConfiguration(component.getLocationOnScreen());
            }
            GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
            if (graphicsConfiguration != null) {
                return graphicsConfiguration;
            }
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public static GraphicsConfiguration getGraphicsConfiguration(Point point) {
        Object object;
        GraphicsConfiguration graphicsConfiguration;
        int n;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (point == null) {
            return graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
        }
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (n = 0; n < graphicsDeviceArray.length; ++n) {
            graphicsConfiguration = graphicsDeviceArray[n].getDefaultConfiguration();
            object = graphicsConfiguration.getBounds();
            if (!((Rectangle)object).contains(point)) continue;
            return graphicsConfiguration;
        }
        n = Integer.MAX_VALUE;
        object = null;
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            graphicsConfiguration = graphicsDeviceArray[i].getDefaultConfiguration();
            Rectangle rectangle = graphicsConfiguration.getBounds();
            int n2 = WDUtil.computeDistanceSq(rectangle, point);
            if (n2 >= n) continue;
            n = n2;
            object = graphicsConfiguration;
        }
        if (object != null) {
            return object;
        }
        return graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
    }

    private static int computeDistanceSq(Rectangle rectangle, Point point) {
        int n;
        int n2;
        int n3 = 0;
        if (point.x < rectangle.x) {
            n2 = rectangle.x - point.x;
            n3 += n2 * n2;
        } else {
            n2 = rectangle.x + rectangle.width;
            if (point.x > n2) {
                n = point.x - n2;
                n3 += n * n;
            }
        }
        if (point.y < rectangle.y) {
            n2 = rectangle.y - point.y;
            n3 += n2 * n2;
        } else {
            n2 = rectangle.y + rectangle.height;
            if (point.y > n2) {
                n = point.y - n2;
                n3 += n * n;
            }
        }
        return n3;
    }

    public static boolean isMultiScreen() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        return graphicsDeviceArray.length > 1;
    }

    public static String swingHtmlEscape(String string) {
        if (UString.isEmpty(string)) {
            return string;
        }
        StringBuilder stringBuilder = null;
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            String string2 = WDUtil.getSwingHtmlReplaceChar(c);
            if (string2 != null) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                    stringBuilder.append(cArray, 0, i);
                }
                stringBuilder.append(string2);
                continue;
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(c);
        }
        return stringBuilder != null ? stringBuilder.toString() : string;
    }

    public static String getSwingHtmlReplaceChar(char c) {
        switch (c) {
            case '<': {
                return "&lt;";
            }
            case '&': {
                return "&amp;";
            }
            case '\n': {
                return "<br>";
            }
            case ' ': {
                return "&nbsp;";
            }
        }
        return null;
    }

    public static void setDocumentWithMaxLength(JTextComponent jTextComponent, final int n) {
        jTextComponent.setDocument(new PlainDocument(){

            public void insertString(int n3, String string, AttributeSet attributeSet) throws BadLocationException {
                int n2 = this.getLength();
                if (n2 + string.length() > n) {
                    Toolkit.getDefaultToolkit().beep();
                    if (n2 >= n) {
                        return;
                    }
                    string = string.substring(0, n - n2);
                }
                super.insertString(n3, string, attributeSet);
            }
        });
    }

    public static void setDialogIcon(JDialog jDialog, Image image) {
        try {
            Method method = JDialog.class.getMethod("setIconImage", Image.class);
            method.invoke((Object)jDialog, image);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

