/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.ui;

import com.triloggroup.gantt.app.ui.WDUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;
import javax.swing.text.View;

public class WDButtonUI
extends MetalButtonUI {
    private static final WDButtonUI wdButtonUI = new WDButtonUI();
    private ImageIcon bgImage = WDUtil.getIcon("ButtonBackground.gif");

    public static ComponentUI createUI(JComponent jComponent) {
        return wdButtonUI;
    }

    protected Color getSelectBorderColor() {
        return UIManager.getColor(this.getPropertyPrefix() + "borderSelect");
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Object object;
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Insets insets = jComponent.getInsets();
        Dimension dimension = abstractButton.getSize();
        Rectangle rectangle = new Rectangle(dimension);
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width = abstractButton.getWidth() - (insets.right + rectangle.x);
        rectangle.height = abstractButton.getHeight() - (insets.bottom + rectangle.y);
        this.paintBackIcon(graphics, jComponent, rectangle);
        Rectangle rectangle2 = new Rectangle();
        rectangle2.height = 0;
        rectangle2.width = 0;
        rectangle2.y = 0;
        rectangle2.x = 0;
        Rectangle rectangle3 = new Rectangle();
        rectangle3.height = 0;
        rectangle3.width = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        Font font = jComponent.getFont();
        graphics.setFont(font);
        String string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle, rectangle3, rectangle2, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
        this.clearTextShiftOffset();
        if (abstractButton.getIcon() != null) {
            this.paintIcon(graphics, jComponent, rectangle3);
        }
        if (string != null && !string.equals("")) {
            object = (View)jComponent.getClientProperty("html");
            if (object != null) {
                ((View)object).paint(graphics, rectangle2);
            } else {
                this.paintText(graphics, (JComponent)abstractButton, rectangle2, string);
            }
        }
        if (abstractButton.isFocusPainted() && abstractButton.hasFocus()) {
            this.paintFocus(graphics, abstractButton, rectangle, rectangle2, rectangle3);
        }
        if (buttonModel.isArmed() && buttonModel.isPressed()) {
            this.paintButtonPressed(graphics, abstractButton);
        }
        object = new Color(145, 145, 145);
        graphics.setColor((Color)object);
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
    }

    protected void paintBackIcon(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        int n = rectangle.y;
        int n2 = this.bgImage.getIconWidth();
        for (int i = rectangle.x; i < rectangle.width; i += n2) {
            this.bgImage.paintIcon(jComponent, graphics, i, n);
        }
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        if (abstractButton.isContentAreaFilled()) {
            Dimension dimension = abstractButton.getSize();
            graphics.setColor(this.getSelectBorderColor());
            graphics.drawRect(1, 1, dimension.width - 3, dimension.height - 3);
        }
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        if (abstractButton.isContentAreaFilled()) {
            Dimension dimension = abstractButton.getSize();
            graphics.setColor(this.getFocusColor());
            graphics.drawRect(2, 2, dimension.width - 5, dimension.height - 5);
        }
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        if (dimension.getHeight() < (double)this.bgImage.getIconHeight()) {
            dimension.height = this.bgImage.getIconHeight();
        }
        Insets insets = jComponent.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }
}

