/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.treetable.resource;

import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.treetable.resource.ResourceEditorDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

class WBSResourceEditorDialog
extends ResourceEditorDialog
implements ActionListener {
    private Resource[] allRes;
    protected boolean[] tableSelection;

    public static WBSResourceEditorDialog create(Component component) {
        Window window = SwingUtilities.getWindowAncestor(component);
        GraphicsConfiguration graphicsConfiguration = WDUtil.getGraphicsConfiguration(component);
        return new WBSResourceEditorDialog(window, graphicsConfiguration);
    }

    public WBSResourceEditorDialog(Window window, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
    }

    public void init(Resource[] resourceArray, Resource[] resourceArray2) {
        Resource[] resourceArray3;
        int n;
        int n2 = Math.max(resourceArray.length, resourceArray2.length);
        this.allRes = new Resource[n2];
        this.tableSelection = new boolean[n2];
        HashSet<Resource> hashSet = new HashSet<Resource>();
        for (n = 0; n < resourceArray2.length; ++n) {
            this.allRes[n] = resourceArray2[n];
            hashSet.add(resourceArray2[n]);
            this.tableSelection[n] = true;
        }
        n = resourceArray2.length;
        for (int i = 0; i < resourceArray.length; ++i) {
            if (hashSet.contains(resourceArray[i])) continue;
            if (n == this.allRes.length) {
                resourceArray3 = new Resource[n + 1];
                System.arraycopy(this.allRes, 0, resourceArray3, 0, n);
                this.allRes = resourceArray3;
                boolean[] blArray = new boolean[n + 1];
                System.arraycopy(this.tableSelection, 0, blArray, 0, n);
                this.tableSelection = blArray;
            }
            this.allRes[n++] = resourceArray[i];
        }
        AbstractTableModel abstractTableModel = new AbstractTableModel(){
            final String[] colNames = new String[]{AppGanttChart.NLS_BUNDLE.getString("Name")};

            public String getColumnName(int n) {
                return this.colNames[n];
            }

            public int getRowCount() {
                return WBSResourceEditorDialog.this.allRes.length;
            }

            public int getColumnCount() {
                return this.colNames.length;
            }

            public Object getValueAt(int n, int n2) {
                return WBSResourceEditorDialog.this.tableSelection[n];
            }

            public boolean isCellEditable(int n, int n2) {
                return true;
            }

            public void setValueAt(Object object, int n, int n2) {
                WBSResourceEditorDialog.this.tableSelection[n] = (Boolean)object;
            }
        };
        resourceArray3 = new JTable(abstractTableModel);
        this.initUI((JTable)resourceArray3);
    }

    protected void collectResult() {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        for (int i = 0; i < this.allRes.length; ++i) {
            if (!this.tableSelection[i]) continue;
            arrayList.add(this.allRes[i]);
        }
        this.result = arrayList.toArray(new Resource[0]);
    }

    protected Resource getResource(int n) {
        return this.allRes[n];
    }
}

