/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.treetable.resource;

import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.ITimeUnits;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TGComputableDuration;
import com.triloggroup.gantt.TGDuration;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.AppProjectModel;
import com.triloggroup.gantt.app.UserPreferences;
import com.triloggroup.gantt.app.treetable.resource.ComputableInt;
import com.triloggroup.gantt.util.ValueInterval;
import com.triloggroup.gantt.util.ValueIntervals;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskResourceTableModel
extends AbstractTableModel {
    private static final String[] colNames = new String[]{AppGanttChart.NLS_BUNDLE.getString("Name"), AppGanttChart.NLS_BUNDLE.getString("Units"), AppGanttChart.NLS_BUNDLE.getString("Work")};
    protected GanttTask task;
    private ITimeUnits units;
    protected HashSet<Resource> highlightedRows;
    protected AppProjectModel projectModel;
    private HashMap<Resource, ValueIntervals> baseAssignments;

    public TaskResourceTableModel(AppGanttChart appGanttChart, GanttTask ganttTask) {
        boolean bl;
        this.projectModel = appGanttChart.getModel().getProjectModel(ganttTask.getProjectId());
        this.task = ganttTask;
        this.units = ganttTask.getNodeContext().getGlobalContext().getTimeUnits();
        UserPreferences userPreferences = appGanttChart.getUserPreferences();
        if (userPreferences == null) {
            bl = false;
        } else {
            UserPreferences.HighlightOverallocationsMode highlightOverallocationsMode = userPreferences.getHighlightOverallocationsMode();
            boolean bl2 = bl = highlightOverallocationsMode == UserPreferences.HighlightOverallocationsMode.PROJECT;
        }
        if (bl) {
            this.initHighlightedRows();
        }
    }

    protected TaskResource[] getResources() {
        return this.task.getResources();
    }

    @Override
    public String getColumnName(int n) {
        return colNames[n];
    }

    @Override
    public int getRowCount() {
        return this.getResources().length;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 0) {
            return Resource.class;
        }
        if (n == 1) {
            return Integer.class;
        }
        if (n == 2) {
            return TGDuration.class;
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        TaskResource taskResource = this.getResources()[n];
        if (n2 == 0) {
            return taskResource.getResource();
        }
        if (n2 == 1) {
            boolean bl = taskResource.isWorkSpecified() || this.task.getSchedulingMode() == 2;
            return new ComputableInt(taskResource.getUnit(), bl);
        }
        double d = taskResource.getWork();
        if (d < 0.0) {
            return null;
        }
        return new TGComputableDuration(d, this.units.getHourTimeUnit(), !taskResource.isWorkSpecified());
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == 1) {
            return this.task.getSchedulingMode() != 2;
        }
        if (n2 == 2) {
            return this.projectModel.getScheduleComputation().canSpecifyUsersWork(this.task);
        }
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 1) {
            ComputableInt computableInt = (ComputableInt)object;
            TaskResource taskResource = this.getResources()[n];
            taskResource.setUnit(computableInt.value);
            taskResource.setWorkSpecified(computableInt.computed);
        } else if (n2 == 2) {
            TaskResource taskResource = this.getResources()[n];
            TGDuration tGDuration = (TGDuration)object;
            if (tGDuration == null) {
                taskResource.setUnit(100);
                taskResource.setWorkSpecified(false);
            } else {
                double d = tGDuration.getValue();
                taskResource.setWork(d);
                taskResource.setWorkSpecified(true);
            }
        } else {
            throw new IllegalStateException("Invalid column: " + n2);
        }
        this.fireTableRowsUpdated(n, n);
    }

    public void taskDataUpdated() {
        this.updateHighlightedRows();
    }

    public boolean isHighlightedResource(Resource resource) {
        return this.highlightedRows != null && this.highlightedRows.contains(resource);
    }

    public void initHighlightedRows() {
        block5: {
            long l;
            this.highlightedRows = new HashSet();
            this.baseAssignments = new HashMap();
            TaskResource[] taskResourceArray = this.task.getResources();
            if (taskResourceArray.length <= 0) break block5;
            long l2 = this.task.getStartDate().getTime();
            if (l2 != (l = this.task.getFinishDate().getTime())) {
                for (int i = 0; i < taskResourceArray.length; ++i) {
                    ValueIntervals valueIntervals = this.projectModel.getResourceAllocations(taskResourceArray[i].getResource());
                    if (valueIntervals.isValueOver(l2, l, 100)) {
                        this.highlightedRows.add(taskResourceArray[i].getResource());
                    }
                    ValueIntervals valueIntervals2 = (ValueIntervals)valueIntervals.clone();
                    ValueInterval valueInterval = new ValueInterval(l2, l, taskResourceArray[i].getUnit());
                    valueIntervals2.removeInterval(valueInterval);
                    this.baseAssignments.put(taskResourceArray[i].getResource(), valueIntervals2);
                }
            } else {
                for (int i = 0; i < taskResourceArray.length; ++i) {
                    if (taskResourceArray[i].getUnit() <= 100) continue;
                    this.highlightedRows.add(taskResourceArray[i].getResource());
                }
            }
        }
    }

    public void updateHighlightedRows() {
        block6: {
            long l;
            if (this.highlightedRows == null) {
                return;
            }
            this.highlightedRows.clear();
            TaskResource[] taskResourceArray = this.task.getResources();
            if (taskResourceArray.length <= 0) break block6;
            long l2 = this.task.getStartDate().getTime();
            if (l2 != (l = this.task.getFinishDate().getTime())) {
                for (int i = 0; i < taskResourceArray.length; ++i) {
                    int n;
                    Resource resource = taskResourceArray[i].getResource();
                    ValueIntervals valueIntervals = this.baseAssignments.get(resource);
                    if (valueIntervals == null) {
                        valueIntervals = this.projectModel.getResourceAllocations(resource);
                    }
                    if (!valueIntervals.isValueOver(l2, l, 100 - (n = taskResourceArray[i].getUnit()))) continue;
                    this.highlightedRows.add(taskResourceArray[i].getResource());
                }
            } else {
                for (int i = 0; i < taskResourceArray.length; ++i) {
                    if (taskResourceArray[i].getUnit() <= 100) continue;
                    this.highlightedRows.add(taskResourceArray[i].getResource());
                }
            }
        }
    }

    public static class EditInPlace
    extends TaskResourceTableModel {
        private TaskResource[] allResources;
        private boolean[] tableSelection;

        public EditInPlace(AppGanttChart appGanttChart, GanttTask ganttTask, Resource[] resourceArray) {
            super(appGanttChart, ganttTask);
            int n;
            TaskResource[] taskResourceArray = ganttTask.getResources();
            int n2 = Math.max(resourceArray.length, taskResourceArray.length);
            this.allResources = new TaskResource[n2];
            this.tableSelection = new boolean[n2];
            HashSet<Resource> hashSet = new HashSet<Resource>();
            for (n = 0; n < taskResourceArray.length; ++n) {
                this.allResources[n] = taskResourceArray[n].clone();
                hashSet.add(taskResourceArray[n].getResource());
                this.tableSelection[n] = true;
            }
            n = taskResourceArray.length;
            for (int i = 0; i < resourceArray.length; ++i) {
                if (hashSet.contains(resourceArray[i])) continue;
                if (n == this.allResources.length) {
                    TaskResource[] taskResourceArray2 = new TaskResource[n + 1];
                    System.arraycopy(this.allResources, 0, taskResourceArray2, 0, n);
                    this.allResources = taskResourceArray2;
                    boolean[] blArray = new boolean[n + 1];
                    System.arraycopy(this.tableSelection, 0, blArray, 0, n);
                    this.tableSelection = blArray;
                }
                this.allResources[n++] = new TaskResource(resourceArray[i], 100);
            }
        }

        protected TaskResource[] getResources() {
            return this.allResources;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                return true;
            }
            return super.isCellEditable(n, n2);
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.tableSelection[n];
            }
            if (!this.tableSelection[n]) {
                return null;
            }
            return super.getValueAt(n, n2);
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                boolean bl;
                this.tableSelection[n] = bl = ((Boolean)object).booleanValue();
                TaskResource taskResource = this.getResources()[n];
                if (!bl) {
                    taskResource.setUnit(100);
                    taskResource.setWorkSpecified(false);
                }
                this.fireTableRowsUpdated(n, n);
            } else {
                if (!this.tableSelection[n]) {
                    if (n2 == 1 && ((ComputableInt)object).computed) {
                        return;
                    }
                    this.tableSelection[n] = true;
                }
                super.setValueAt(object, n, n2);
            }
        }

        public TaskResource[] getSelectedResources() {
            ArrayList<TaskResource> arrayList = new ArrayList<TaskResource>();
            for (int i = 0; i < this.allResources.length; ++i) {
                if (!this.tableSelection[i]) continue;
                arrayList.add(this.allResources[i]);
            }
            return arrayList.toArray(new TaskResource[0]);
        }
    }

    public static class Form
    extends TaskResourceTableModel {
        public Form(AppGanttChart appGanttChart, GanttTask ganttTask) {
            super(appGanttChart, ganttTask);
        }

        public void removeRow(int n) {
            if (this.task.getResources().length > n) {
                if (this.task.getResources().length == 1) {
                    this.task.setResources(new TaskResource[0]);
                } else {
                    TaskResource[] taskResourceArray = this.task.getResources();
                    TaskResource[] taskResourceArray2 = new TaskResource[taskResourceArray.length - 1];
                    if (n == 0) {
                        System.arraycopy(taskResourceArray, 1, taskResourceArray2, 0, taskResourceArray2.length);
                    } else if (n == taskResourceArray.length - 1) {
                        System.arraycopy(taskResourceArray, 0, taskResourceArray2, 0, taskResourceArray2.length);
                    } else {
                        System.arraycopy(taskResourceArray, 0, taskResourceArray2, 0, n);
                        System.arraycopy(taskResourceArray, n + 1, taskResourceArray2, n, taskResourceArray.length - (n + 1));
                    }
                    this.task.setResources(taskResourceArray2);
                }
                this.fireTableRowsDeleted(n, n);
            }
        }

        public void addRow(TaskResource taskResource) {
            TaskResource[] taskResourceArray = this.task.getResources();
            TaskResource[] taskResourceArray2 = new TaskResource[taskResourceArray.length + 1];
            System.arraycopy(taskResourceArray, 0, taskResourceArray2, 0, taskResourceArray.length);
            taskResourceArray2[taskResourceArray.length] = taskResource;
            this.task.setResources(taskResourceArray2);
            this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
        }
    }
}

