/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.treetable;

import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.ITimeUnits;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TimeUnit;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.AppGanttChartModel;
import com.triloggroup.gantt.app.AppProjectModel;
import com.triloggroup.gantt.app.treetable.AppGanttTreeTable;
import com.triloggroup.gantt.app.treetable.AppGanttTreeTableModel;
import com.triloggroup.project.components.ui.table.TGTableCellRenderer;
import com.triloggroup.project.schedule.IPredecessor;
import com.triloggroup.project.schedule.Predecessor;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredecessorsRenderer
extends TGTableCellRenderer {
    private AppGanttTreeTable table;
    static final char SEPARATOR = ';';
    private GanttNode renderedNode;

    public PredecessorsRenderer(AppGanttTreeTable appGanttTreeTable) {
        this.table = appGanttTreeTable;
    }

    @Override
    public JComponent getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        TGNode tGNode;
        this.renderedNode = object == null ? null : ((tGNode = ((AppGanttTreeTableModel)jTable.getModel()).nodeForRow(n)) instanceof GanttNode ? (GanttNode)tGNode : null);
        return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
    }

    @Override
    protected void setValue(Object object) {
        this.setText(PredecessorsRenderer.format((List)object, this.table, this.renderedNode));
    }

    static String format(List<IPredecessor> list, AppGanttTreeTable appGanttTreeTable, GanttNode ganttNode) {
        if (list == null || list.size() == 0) {
            return "";
        }
        int n = list.size();
        AppGanttChartModel appGanttChartModel = appGanttTreeTable.getGanttControler().getModel();
        AppProjectModel appProjectModel = ganttNode == null ? appGanttChartModel.getMainProjectModel() : appGanttChartModel.getProjectModel(ganttNode.getProjectId());
        Object[] objectArray = new PredecessorData[n];
        for (int i = 0; i < n; ++i) {
            IPredecessor iPredecessor = list.get(i);
            objectArray[i] = new PredecessorData(iPredecessor, appProjectModel.getNodeByUid(iPredecessor.getId()));
        }
        Arrays.sort(objectArray);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(';');
            }
            PredecessorsRenderer.format((PredecessorData)objectArray[i], appGanttChartModel, stringBuilder, false);
        }
        return stringBuilder.toString();
    }

    static void format(PredecessorData predecessorData, AppGanttChartModel appGanttChartModel, StringBuilder stringBuilder, boolean bl) {
        int n;
        GanttNode ganttNode = predecessorData.node;
        IPredecessor iPredecessor = predecessorData.predecessor;
        if (ganttNode == null) {
            if (bl) {
                stringBuilder.append(iPredecessor.getId());
            } else {
                stringBuilder.append('?');
            }
        } else {
            stringBuilder.append(ganttNode.getLineId());
        }
        if (iPredecessor.getType() != 1 || iPredecessor.getLag() != 0) {
            String string = Predecessor.predecessorTypeAsString(iPredecessor.getType()) + "Abbr";
            stringBuilder.append(AppGanttChart.NLS_BUNDLE.getString(string));
        }
        if ((n = iPredecessor.getLag()) != 0) {
            if (n > 0) {
                stringBuilder.append('+');
            }
            stringBuilder.append(n);
            ITimeUnits iTimeUnits = appGanttChartModel.getGlobalContext().getTimeUnits();
            TimeUnit timeUnit = iTimeUnits.fromCode(iPredecessor.getLagFormat());
            stringBuilder.append(' ');
            stringBuilder.append(n < -1 || n > 1 ? timeUnit.getShortLabelPlural() : timeUnit.getShortLabel());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PredecessorData
    implements Comparable<PredecessorData> {
        IPredecessor predecessor;
        GanttNode node;

        PredecessorData(IPredecessor iPredecessor, GanttNode ganttNode) {
            this.predecessor = iPredecessor;
            this.node = ganttNode;
        }

        @Override
        public int compareTo(PredecessorData predecessorData) {
            GanttNode ganttNode = this.node;
            GanttNode ganttNode2 = predecessorData.node;
            if (ganttNode == null) {
                return ganttNode2 == null ? 0 : -1;
            }
            if (ganttNode2 == null) {
                return 1;
            }
            return ganttNode.getLineId() - ganttNode2.getLineId();
        }
    }
}

