/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.treetable;

import com.triloggroup.gantt.TGComputableDuration;
import com.triloggroup.gantt.TGDuration;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.project.components.ui.table.CellEditorWithLabel;
import com.triloggroup.project.components.util.format.TGDecimalFormat;
import com.triloggroup.util.UString;
import java.awt.Color;
import java.text.NumberFormat;
import javax.swing.JTable;
import javax.swing.border.LineBorder;

public class DurationEditor
extends CellEditorWithLabel {
    protected TGDuration value;
    protected NumberFormat format;

    public DurationEditor() {
        super("");
        this.getTextComponent().setHorizontalAlignment(4);
        this.format = TGDecimalFormat.getTGInstance(Workbench.get().getFormatLocale());
    }

    protected String getTextValue(JTable jTable, Object object, boolean bl, int n, int n2) {
        TGDuration tGDuration;
        if (object == null) {
            this.value = null;
            this.setLabelText("");
            return "";
        }
        this.getTextComponent().setEnabled(true);
        this.value = tGDuration = (TGDuration)object;
        double d = tGDuration.getValue();
        String string = d > 1.0 ? tGDuration.getUnit().getShortLabelPlural() : tGDuration.getUnit().getShortLabel();
        this.setLabelText(string);
        return this.format.format(d);
    }

    public Object getCellEditorValue() {
        return this.value;
    }

    public boolean stopCellEditing() {
        String string = this.getTextComponent().getText();
        try {
            if (UString.isEmpty(string) && this.value instanceof TGComputableDuration) {
                this.value = null;
            } else {
                double d;
                double d2 = Double.NEGATIVE_INFINITY;
                if (this.value != null && string.equals(this.format.format(d = this.value.getValue()))) {
                    d2 = d;
                }
                if (d2 == Double.NEGATIVE_INFINITY) {
                    d2 = TGDecimalFormat.parseFullString(string, this.format).doubleValue();
                }
                if (!this.acceptValue(d2)) {
                    this.panel.setBorder(new LineBorder(Color.red));
                    return false;
                }
                this.value = this.value != null ? new TGDuration(d2, this.value.getUnit()) : new TGDuration(d2, null);
            }
        }
        catch (Exception exception) {
            this.panel.setBorder(new LineBorder(Color.red));
            return false;
        }
        return super.stopCellEditing();
    }

    protected boolean acceptValue(double d) {
        return d >= 0.0;
    }
}

