/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.treetable;

import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttProjectContext;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.AppGlobalContext;
import com.triloggroup.gantt.app.UserPreferences;
import com.triloggroup.gantt.app.financial.SubprojectFinancialData;
import com.triloggroup.gantt.app.social.NodeSocialData;
import com.triloggroup.gantt.app.social.SocialManager;
import com.triloggroup.gantt.app.treetable.AppGanttTreeTable;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.gantt.treetable.TGTreeTableCellRenderer;
import com.triloggroup.project.components.ui.DoubleIcon;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.project.components.util.format.FormatUtil;
import com.triloggroup.project.financial.AbstractFinancialHealth;
import com.triloggroup.project.financial.FinancialSettings;
import com.triloggroup.util.NLSBundle;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;

public class AppTreeTableCellRenderer
extends TGTreeTableCellRenderer {
    private static final ImageIcon wbsDoneIcon;
    private static final ImageIcon[] wbsPendingIcons;
    private static final ImageIcon[] wbsInProgressIcons;
    private static ImageIcon abortedIcon;
    private static Icon[] moneyIcons;
    private AppGanttChart ganttChart;
    private boolean initialized = false;
    private TGNode currentNode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Icon getMoneyIcon(int n) {
        if (moneyIcons == null) {
            AppTreeTableCellRenderer appTreeTableCellRenderer = this;
            synchronized (appTreeTableCellRenderer) {
                if (moneyIcons == null) {
                    moneyIcons = new Icon[4];
                    AppTreeTableCellRenderer.moneyIcons[1] = WDUtil.getIcon("money_green.gif");
                    AppTreeTableCellRenderer.moneyIcons[2] = WDUtil.getIcon("money_orange.gif");
                    AppTreeTableCellRenderer.moneyIcons[3] = WDUtil.getIcon("money_red.gif");
                }
            }
        }
        return moneyIcons[n];
    }

    private void init(JTable jTable) {
        this.initialized = true;
        this.ganttChart = ((AppGanttTreeTable)jTable).getGanttControler();
    }

    private FinancialSettings getFinancialSettings(GanttNode ganttNode) {
        FinancialSettings financialSettings;
        if (this.ganttChart.getModel().getGlobalContext().hasFinancialModule() && (financialSettings = this.ganttChart.getModel().getMainProjectModel().getProjectContext().getFinancialSettings()) != null) {
            if (ganttNode != null) {
                if (GanttNode.isSubprojectLink(ganttNode)) {
                    if (ganttNode.getAllSubTaskCount() == 0) {
                        String string = ((GanttWBS)ganttNode).getSubProject().getId();
                        SubprojectFinancialData subprojectFinancialData = ((AppGlobalContext)ganttNode.getGlobalContext()).getSubprojectFinancialData(string);
                        return subprojectFinancialData == null ? null : subprojectFinancialData.getSettings();
                    }
                    ganttNode = ganttNode.getSubtaskInAll(0);
                }
                return ((GanttProjectContext)ganttNode.getProjectContext()).getFinancialSettings();
            }
            return financialSettings;
        }
        return null;
    }

    private double getComputedBudget(GanttWBS ganttWBS) {
        if (ganttWBS.isProjectRoot()) {
            return ((GanttProjectContext)ganttWBS.getProjectContext()).getComputedBudget();
        }
        String string = ganttWBS.getSubProject().getId();
        SubprojectFinancialData subprojectFinancialData = ((AppGlobalContext)ganttWBS.getGlobalContext()).getSubprojectFinancialData(string);
        return subprojectFinancialData.getComputedBudget();
    }

    public JComponent getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (!this.initialized) {
            this.init(jTable);
        }
        return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
    }

    protected Icon getIconForNode(TGNode tGNode) {
        this.currentNode = tGNode;
        Icon icon = this.getHealthIconForNode(tGNode);
        if (this.showFinancialIcon() && icon != null && tGNode instanceof GanttNode) {
            Icon icon2 = this.getFinancialIconForNode((GanttNode)tGNode);
            if (icon2 != null) {
                icon = new DoubleIcon(icon, icon2);
                this.setIconTextGap(8);
            } else {
                this.setIconTextGap(4);
            }
        } else {
            this.setIconTextGap(4);
        }
        return icon;
    }

    private Icon getFinancialIconForNode(GanttNode ganttNode) {
        int n;
        GanttWBS ganttWBS;
        if (GanttNode.isSubprojectLink(ganttNode) && (ganttWBS = (GanttWBS)ganttNode).isBrokenSubprojectLink()) {
            return null;
        }
        if (ganttNode.isProjectRoot() || GanttNode.isSubprojectLinkNotLoaded(ganttNode)) {
            FinancialSettings financialSettings = this.getFinancialSettings(ganttNode);
            if (financialSettings == null) {
                return null;
            }
            double d = financialSettings.getBudget() > 0.0 ? financialSettings.getBudget() : this.getComputedBudget((GanttWBS)ganttNode);
            double d2 = ganttNode.getProjectedResourceCost() + ganttNode.getProjectedAdditionalCost();
            n = AbstractFinancialHealth.computeStatus(d, d2, financialSettings);
        } else {
            n = ganttNode.getFinancialHealthStatus();
        }
        return this.getMoneyIcon(n);
    }

    private boolean showFinancialIcon() {
        return this.ganttChart.getModel().getGlobalContext().hasFinancialModule() && this.ganttChart.getModel().getMainProjectModel().getProjectContext().getFinancialSettings() != null && this.ganttChart.getUserPreferences().getShowFinancialTracking();
    }

    protected ImageIcon getWBSIcon(GanttWBS ganttWBS) {
        ImageIcon imageIcon;
        if (ganttWBS.isProjectRoot() && "Aborted".equals(((GanttProjectContext)ganttWBS.getProjectContext()).getProjectStatus())) {
            return this.getAbortedProjectIcon();
        }
        if (ganttWBS.isDone()) {
            return wbsDoneIcon;
        }
        int n = ganttWBS.getHealthStatus();
        if (ganttWBS.isInProgress()) {
            return wbsInProgressIcons[n];
        }
        if (ganttWBS.hasSubTask() && (imageIcon = wbsPendingIcons[n]) != null) {
            return imageIcon;
        }
        return this.getBasicWBSIcon();
    }

    protected Icon getSubprojectIcon(GanttWBS ganttWBS) {
        if (ganttWBS.isBrokenSubprojectLink()) {
            return this.getBrokenSubprojectLinkIcon();
        }
        if ("Aborted".equals(((GanttProjectContext)ganttWBS.getProjectContext()).getProjectStatus()) || "Aborted".equals(ganttWBS.getStatus())) {
            return this.getAbortedProjectIcon();
        }
        if (ganttWBS.isDone()) {
            return WDUtil.getIcon("subproject_done.gif");
        }
        int n = ganttWBS.getHealthStatus();
        if (ganttWBS.isInProgress()) {
            return WDUtil.getIcon("subproject_inprogress_" + n + ".gif");
        }
        if (ganttWBS.isPending()) {
            return WDUtil.getIcon("subproject_pending_" + n + ".gif");
        }
        return this.getBasicSubprojectIcon();
    }

    protected Icon computeRightIconForNode(TGNode tGNode) {
        if (tGNode instanceof GanttNode) {
            int n;
            int n2;
            Icon icon = null;
            Icon icon2 = null;
            Icon icon3 = null;
            NodeSocialData nodeSocialData = ((GanttNode)tGNode).getSocialData();
            if (nodeSocialData.getCommentCount() > 0) {
                UserPreferences userPreferences = this.ganttChart.getUserPreferences();
                if (userPreferences != null && userPreferences.getRecentCommentsHighlight()) {
                    long l;
                    n2 = userPreferences.getRecentCommentsDays();
                    Date date = nodeSocialData.getLastCommentDate();
                    if (date != null && n2 > 0 && (l = System.currentTimeMillis() - date.getTime()) < (long)(n2 * 3600 * 1000 * 24)) {
                        icon = SocialManager.MESSAGE_HIGHLIGHT_ICON;
                    }
                }
                if (icon == null) {
                    icon = SocialManager.MESSAGE_ICON;
                }
            }
            if ((n = nodeSocialData.getBookmarkCount()) > 0) {
                n2 = nodeSocialData.getDeliverableCount();
                if (n2 > 0) {
                    icon3 = SocialManager.DELIVERABLE_ICON;
                }
                if (n - n2 > 0) {
                    icon2 = SocialManager.BOOKMARK_ICON;
                }
            }
            if (icon != null || icon2 != null || icon3 != null) {
                return new DoubleIcon(icon, icon2, icon3);
            }
        }
        return null;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (!(this.currentNode instanceof GanttNode)) {
            return null;
        }
        GanttNode ganttNode = (GanttNode)this.currentNode;
        Insets insets = this.getBorder().getBorderInsets(this);
        int n = insets.left;
        int n2 = mouseEvent.getX() - n;
        if (n2 < 0) {
            return null;
        }
        Icon icon = this.getIcon();
        if (icon == null || n2 > icon.getIconWidth()) {
            int n3;
            Icon icon2 = this.getRightIcon();
            if (icon2 != null && (n3 = this.getX() + this.getWidth() - mouseEvent.getX()) >= 0 && n3 <= icon2.getIconWidth() + 2) {
                NodeSocialData nodeSocialData = ganttNode.getSocialData();
                return AppGanttChart.NLS_BUNDLE.getString("showBookmarksandComments", String.valueOf(nodeSocialData.getBookmarkCount()), String.valueOf(nodeSocialData.getCommentCount()));
            }
            return null;
        }
        if (icon instanceof DoubleIcon && n2 > ((DoubleIcon)icon).getIcons()[0].getIconWidth()) {
            double d;
            FinancialSettings financialSettings = this.getFinancialSettings(ganttNode);
            NLSBundle nLSBundle = AppGanttChart.NLS_BUNDLE;
            DecimalFormat decimalFormat = FormatUtil.getCostFormat(Workbench.get().getFormatLocale(), financialSettings);
            String string = financialSettings.getCurrencySymbol();
            boolean bl = "before".equals(financialSettings.getCurrencySymbolPlacement());
            StringBuilder stringBuilder = new StringBuilder();
            if (ganttNode.isProjectRoot() || GanttNode.isSubprojectLinkNotLoaded(ganttNode)) {
                d = financialSettings.getBudget();
                if (d > 0.0) {
                    stringBuilder.append(nLSBundle.getString("financial_budget")).append(": ");
                    stringBuilder.append(this.formatCost(decimalFormat, d, string, bl));
                } else {
                    double d2 = this.getComputedBudget((GanttWBS)ganttNode);
                    stringBuilder.append(nLSBundle.getString("financial_budget")).append(' ');
                    stringBuilder.append(nLSBundle.getString("financial_computed")).append(": ");
                    stringBuilder.append(this.formatCost(decimalFormat, d2, string, bl));
                }
            }
            if (stringBuilder.length() == 0) {
                d = ganttNode.getInitiallyPlannedResourceCost() + ganttNode.getInitiallyPlannedAdditionalCost();
                stringBuilder.append(nLSBundle.getString("financial_initiallyPlanned")).append(": ");
                stringBuilder.append(this.formatCost(decimalFormat, d, string, bl));
            }
            d = ganttNode.getProjectedResourceCost() + ganttNode.getProjectedAdditionalCost();
            stringBuilder.append('\n').append(nLSBundle.getString("financial_projectedCost")).append(": ");
            stringBuilder.append(this.formatCost(decimalFormat, d, string, bl));
            return stringBuilder.toString();
        }
        if (ganttNode.isProjectRoot() && "Aborted".equals(((GanttProjectContext)ganttNode.getProjectContext()).getProjectStatus()) || "Aborted".equals(ganttNode.getStatus())) {
            return AppGanttChart.NLS_BUNDLE.getString("Aborted");
        }
        return ganttNode.getLocalizedStatus();
    }

    private String formatCost(DecimalFormat decimalFormat, double d, String string, boolean bl) {
        String string2 = decimalFormat.format(d);
        return bl ? (string2 = string + ' ' + string2) : string2 + ' ' + string;
    }

    protected ImageIcon getAbortedProjectIcon() {
        if (abortedIcon == null) {
            abortedIcon = WDUtil.getIcon("subproject_cancelled.gif");
        }
        return abortedIcon;
    }

    static {
        int n;
        wbsDoneIcon = WDUtil.getIcon("wbs_done.gif");
        wbsPendingIcons = new ImageIcon[4];
        for (n = 1; n < 4; ++n) {
            AppTreeTableCellRenderer.wbsPendingIcons[n] = WDUtil.getIcon("wbs_pending_" + n + ".gif");
        }
        wbsInProgressIcons = new ImageIcon[4];
        for (n = 1; n < 4; ++n) {
            AppTreeTableCellRenderer.wbsInProgressIcons[n] = WDUtil.getIcon("wbs_inprogress_" + n + ".gif");
        }
    }
}

