/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.treetable;

import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.TGChartModel;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.AppProjectModel;
import com.triloggroup.gantt.app.UserPreferences;
import com.triloggroup.gantt.app.treetable.AppGanttTreeTable;
import com.triloggroup.gantt.app.treetable.AppGanttTreeTableModel;
import com.triloggroup.gantt.treetable.ResourcesRenderer;
import com.triloggroup.gantt.util.ValueIntervals;
import com.triloggroup.project.components.ui.TGLabelUI;
import com.triloggroup.project.components.ui.table.TGTableCellRendererWithEditIcon;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public class AppResourcesRenderer
extends ResourcesRenderer {
    private AppGanttChart chart = null;
    private GanttTask currentTask = null;
    private static Icon icon = TGTableCellRendererWithEditIcon.DEFAULT_ICON;
    private int redColorUpToIdx = 0;

    public AppResourcesRenderer(TGChartModel tGChartModel, Locale locale) {
        super(tGChartModel, locale);
        this.setHorizontalTextPosition(10);
    }

    public void updateUI() {
        this.setUI(new TGLabelUI(){

            protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
                if (AppResourcesRenderer.this.redColorUpToIdx <= 0) {
                    super.paintEnabledText(jLabel, graphics, string, n, n2);
                } else {
                    Color color = jLabel.getForeground();
                    if (AppResourcesRenderer.this.redColorUpToIdx >= string.length()) {
                        jLabel.setForeground(Color.RED);
                        super.paintEnabledText(jLabel, graphics, string, n, n2);
                        jLabel.setForeground(color);
                    } else {
                        String string2 = string.substring(0, AppResourcesRenderer.this.redColorUpToIdx);
                        String string3 = string.substring(AppResourcesRenderer.this.redColorUpToIdx);
                        int n3 = SwingUtilities.computeStringWidth(graphics.getFontMetrics(), string2);
                        jLabel.setForeground(Color.RED);
                        super.paintEnabledText(jLabel, graphics, string2, n, n2);
                        jLabel.setForeground(color);
                        super.paintEnabledText(jLabel, graphics, string3, n + n3, n2);
                    }
                }
            }
        });
    }

    public JComponent getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        AppGanttTreeTableModel appGanttTreeTableModel;
        TGNode tGNode;
        this.currentTask = null;
        TableModel tableModel = jTable.getModel();
        if (tableModel instanceof AppGanttTreeTableModel && (tGNode = (appGanttTreeTableModel = (AppGanttTreeTableModel)tableModel).nodeForRow(n)) instanceof GanttTask) {
            this.currentTask = (GanttTask)tGNode;
            this.chart = ((AppGanttTreeTable)jTable).getGanttControler();
        }
        this.setForeground(Color.BLACK);
        this.redColorUpToIdx = 0;
        boolean bl3 = bl2 ? jTable.getModel().isCellEditable(n, jTable.convertColumnIndexToModel(n2)) : false;
        this.setIcon(bl3 ? icon : null);
        return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
    }

    protected void setValue(Object object) {
        TaskResource[] taskResourceArray;
        Object object2;
        boolean bl;
        boolean bl2 = bl = object != null && this.currentTask != null;
        if (bl) {
            object2 = this.chart.getUserPreferences();
            if (object2 == null) {
                bl = false;
            } else {
                taskResourceArray = ((UserPreferences)object2).getHighlightOverallocationsMode();
                boolean bl3 = bl = taskResourceArray == UserPreferences.HighlightOverallocationsMode.PROJECT;
            }
        }
        if (bl) {
            object2 = null;
            if (object instanceof TaskResource[] && (taskResourceArray = (TaskResource[])object).length > 0) {
                int n;
                int n2;
                ArrayList<TaskResource> arrayList = new ArrayList<TaskResource>(taskResourceArray.length);
                ArrayList<TaskResource> arrayList2 = new ArrayList<TaskResource>(taskResourceArray.length);
                long l = this.currentTask.getStartDate().getTime();
                long l2 = this.currentTask.getFinishDate().getTime();
                AppProjectModel appProjectModel = this.chart.getModel().getProjectModel(this.currentTask.getProjectId());
                boolean bl4 = appProjectModel.includeAllocationsForDoneTasks();
                for (n2 = 0; n2 < taskResourceArray.length; ++n2) {
                    if (!bl4 && this.currentTask.isDone()) {
                        arrayList.add(taskResourceArray[n2]);
                        continue;
                    }
                    int n3 = n = taskResourceArray[n2].getUnit() > 100 ? 1 : 0;
                    if (n == 0) {
                        ValueIntervals valueIntervals = appProjectModel.getResourceAllocations(taskResourceArray[n2].getResource());
                        n = valueIntervals.isValueOver(l, l2, 100) ? 1 : 0;
                    }
                    if (n != 0) {
                        arrayList2.add(taskResourceArray[n2]);
                        continue;
                    }
                    arrayList.add(taskResourceArray[n2]);
                }
                object2 = new StringBuilder();
                if (arrayList2.isEmpty() || arrayList.isEmpty()) {
                    ArrayList<TaskResource> arrayList3;
                    if (arrayList2.isEmpty()) {
                        arrayList3 = arrayList;
                    } else {
                        arrayList3 = arrayList2;
                        this.setForeground(Color.RED);
                    }
                    for (n = 0; n < arrayList3.size(); ++n) {
                        if (n > 0) {
                            ((StringBuilder)object2).append(", ");
                        }
                        this.appendTaskResource((TaskResource)arrayList3.get(n), (StringBuilder)object2);
                    }
                } else {
                    for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                        if (n2 > 0) {
                            ((StringBuilder)object2).append(", ");
                        }
                        this.appendTaskResource((TaskResource)arrayList2.get(n2), (StringBuilder)object2);
                    }
                    this.redColorUpToIdx = ((StringBuilder)object2).length();
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        ((StringBuilder)object2).append(", ");
                        this.appendTaskResource((TaskResource)arrayList.get(n2), (StringBuilder)object2);
                    }
                }
            }
            this.setText(object2 == null ? "" : ((StringBuilder)object2).toString());
        } else {
            super.setValue(object);
        }
    }
}

