/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.social;

import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.UserPreferences;
import com.triloggroup.gantt.app.ui.WDButton;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.ui.IntTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class RecentCommentsSettingsDialog
extends WDDialog
implements ActionListener {
    private AppGanttChart ganttCtrl;
    private WDButton okButton;
    private JCheckBox cbHighlight;
    private JLabel lbDays;
    private IntTextField tfDays;

    static void showDialog(AppGanttChart appGanttChart, Component component) {
        Point point = component.getLocationOnScreen();
        point.y += component.getHeight() / 2;
        point.x += component.getWidth() / 2;
        GraphicsConfiguration graphicsConfiguration = WDUtil.getGraphicsConfiguration(point);
        Window window = SwingUtilities.getWindowAncestor(component);
        RecentCommentsSettingsDialog recentCommentsSettingsDialog = new RecentCommentsSettingsDialog(window, appGanttChart, graphicsConfiguration);
        recentCommentsSettingsDialog.setLocation(point);
        recentCommentsSettingsDialog.setModal(true);
        recentCommentsSettingsDialog.setVisible(true);
    }

    private RecentCommentsSettingsDialog(Window window, AppGanttChart appGanttChart, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
        this.ganttCtrl = appGanttChart;
        this.initUI();
    }

    private void initUI() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        Insets insets = new Insets(2, 2, 2, 2);
        Insets insets2 = new Insets(12, 2, 2, 2);
        Insets insets3 = new Insets(2, 25, 2, 2);
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.cbHighlight = new JCheckBox(AppGanttChart.NLS_BUNDLE.getString("recentcomment_highlight"));
        this.cbHighlight.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                RecentCommentsSettingsDialog.this.setFieldsState();
            }
        });
        jPanel.add((Component)this.cbHighlight, new GridBagConstraints(0, -1, 4, 1, 1.0, 1.0, 17, 0, insets2, 0, 0));
        JLabel jLabel = new JLabel(AppGanttChart.NLS_BUNDLE.getString("recentcomment_callout"));
        ImageIcon imageIcon = WDUtil.getIcon("UserAssistance.gif");
        if (imageIcon != null) {
            jLabel.setIcon(imageIcon);
            jLabel.setVerticalTextPosition(1);
        }
        jPanel.add((Component)jLabel, new GridBagConstraints(0, -1, 4, 1, 1.0, 1.0, 17, 2, insets3, 0, 0));
        this.lbDays = new JLabel(AppGanttChart.NLS_BUNDLE.getString("recentcomment_numberOfDays"));
        jPanel.add((Component)this.lbDays, new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 17, 2, insets3, 0, 0));
        this.tfDays = new IntTextField(this.ganttCtrl.getDateLocale());
        this.tfDays.setColumns(10);
        this.tfDays.setHorizontalAlignment(4);
        jPanel.add((Component)this.tfDays, new GridBagConstraints(1, -1, 1, 1, 0.0, 1.0, 17, 2, insets, 0, 0));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        this.okButton = WDUtil.createOkButton();
        jPanel2.add(this.okButton);
        WDButton wDButton = WDUtil.createCancelButton();
        jPanel2.add(wDButton);
        this.okButton.addActionListener(this);
        wDButton.addActionListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel2, "North");
        this.getContentPane().add((Component)jPanel, "Center");
        this.setDragHeader(true);
        this.setMaximizable(false);
        UserPreferences userPreferences = this.ganttCtrl.getUserPreferences();
        this.cbHighlight.setSelected(userPreferences.getRecentCommentsHighlight());
        this.tfDays.setValue(userPreferences.getRecentCommentsDays());
        this.setFieldsState();
    }

    private void setFieldsState() {
        boolean bl = this.cbHighlight.isSelected();
        this.lbDays.setEnabled(bl);
        this.tfDays.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            boolean bl = this.cbHighlight.isSelected();
            int n = this.tfDays.getIntValue();
            if (n <= 0) {
                if (bl) {
                    WDDialog.showMsgDialog(this, AppGanttChart.NLS_BUNDLE.getString("valueGreaterThan0"));
                    this.tfDays.requestFocusInWindow();
                    return;
                }
                n = this.ganttCtrl.getUserPreferences().getRecentCommentsDays();
            }
            this.ganttCtrl.getUserPreferences().updateRecentComments(bl, n);
        }
        this.dispose();
    }
}

