/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.social;

import com.triloggroup.gantt.app.social.BookmarksAndCommentsDialog;
import com.triloggroup.gantt.app.ui.ULabel;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.project.components.resourceeditor.ProjectResource;
import com.triloggroup.project.components.resourceeditor.ProjectTeam;
import com.triloggroup.project.components.ui.WrapLayout;
import com.triloggroup.project.social.NotificationConfig;
import com.triloggroup.project.social.NotificationItem;
import com.triloggroup.util.StringValidator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class NotificationsPanel
extends JPanel
implements MouseListener {
    private BookmarksAndCommentsDialog dialog;
    private NotificationConfig notificationConfig;
    private NotifType[] notifTypes = new NotifType[]{new NotifType(0), new NotifType(1), new NotifType(2), new NotifType(3)};
    private JPanel notifItemsPanel;
    private Insets insets = new Insets(1, 1, 1, 1);
    private JPanel notifSelectionPanel;
    private JComboBox cbNotif;
    private JTextField txtFieldEmail;
    private JComboBox cbUser;
    private JComboBox cbTeam;
    static final Color NOTIFITEM_BORDER_COLOR = new Color(196, 216, 242);
    static final Color NOTIFITEM_BACKGROUND_COLOR = new Color(244, 247, 252);

    public NotificationsPanel(NotificationConfig notificationConfig, BookmarksAndCommentsDialog bookmarksAndCommentsDialog) {
        this.notificationConfig = notificationConfig;
        this.dialog = bookmarksAndCommentsDialog;
        this.init();
    }

    private void init() {
        this.setBackground(BookmarksAndCommentsDialog.COMMENT_BACKGROUND_COLOR);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        JCheckBox jCheckBox = new JCheckBox(this.dialog.nls().getString("sendNotification"));
        jCheckBox.setFont(jCheckBox.getFont().deriveFont(0));
        jCheckBox.setSelected(this.notificationConfig.notify);
        jCheckBox.setBackground(BookmarksAndCommentsDialog.COMMENT_BACKGROUND_COLOR);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                ((NotificationsPanel)NotificationsPanel.this).notificationConfig.notify = jCheckBox.isSelected();
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, this.insets, 0, 0);
        this.add((Component)jCheckBox, gridBagConstraints);
        JCheckBox jCheckBox2 = new JCheckBox(this.dialog.nls().getString("sentAttachedFiles"));
        jCheckBox2.setFont(jCheckBox2.getFont().deriveFont(0));
        jCheckBox2.setSelected(this.notificationConfig.sendBookmarks);
        jCheckBox2.setBackground(BookmarksAndCommentsDialog.COMMENT_BACKGROUND_COLOR);
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                ((NotificationsPanel)NotificationsPanel.this).notificationConfig.sendBookmarks = jCheckBox.isSelected();
            }
        });
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, this.insets, 0, 0);
        this.add((Component)jCheckBox2, gridBagConstraints);
        this.notifSelectionPanel = this.createNotificationSelectionPanel();
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 1, this.insets, 0, 0);
        this.add((Component)this.notifSelectionPanel, gridBagConstraints);
        this.notifItemsPanel = new JPanel();
        this.notifItemsPanel.setOpaque(false);
        this.notifItemsPanel.setLayout(new WrapLayout(0, 2, 2));
        this.updateNotifItemsPanel();
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 1, this.insets, 0, 0);
        this.add((Component)this.notifItemsPanel, gridBagConstraints);
        this.validate();
    }

    private JPanel createNotificationSelectionPanel() {
        this.notifSelectionPanel = new JPanel();
        this.notifSelectionPanel.setBackground(BookmarksAndCommentsDialog.COMMENT_BACKGROUND_COLOR);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.notifSelectionPanel.setLayout(gridBagLayout);
        int n = 0;
        JLabel jLabel = new JLabel(this.dialog.nls().getString("notificationList") + ":");
        jLabel.setFont(jLabel.getFont().deriveFont(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.notifSelectionPanel.add((Component)jLabel, gridBagConstraints);
        this.cbNotif = new JComboBox<NotifType>(this.notifTypes);
        gridBagConstraints = new GridBagConstraints(n++, 0, 1, 1, 1.0, 0.0, 17, 2, this.insets, 0, 0);
        this.notifSelectionPanel.add((Component)this.cbNotif, gridBagConstraints);
        this.cbNotif.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    NotifType notifType = (NotifType)itemEvent.getItem();
                    NotificationsPanel.this.showInputNotifySelectorForType(notifType.type);
                }
            }
        });
        this.txtFieldEmail = new JTextField(30);
        gridBagConstraints = new GridBagConstraints(n++, 0, 1, 1, 1.0, 0.0, 17, 2, this.insets, 0, 0);
        this.notifSelectionPanel.add((Component)this.txtFieldEmail, gridBagConstraints);
        this.cbUser = new JComboBox<ProjectResource>(this.dialog.gantt.getModel().getProjectModel(this.dialog.getNode().getProjectId()).getProjectResources());
        gridBagConstraints = new GridBagConstraints(n++, 0, 1, 1, 1.0, 0.0, 17, 1, this.insets, 0, 0);
        this.notifSelectionPanel.add((Component)this.cbUser, gridBagConstraints);
        this.cbTeam = new JComboBox<ProjectTeam>(this.dialog.gantt.getModel().getProjectModel(this.dialog.getNode().getProjectId()).getProjectTeams());
        gridBagConstraints = new GridBagConstraints(n++, 0, 1, 1, 1.0, 0.0, 17, 1, this.insets, 0, 0);
        this.notifSelectionPanel.add((Component)this.cbTeam, gridBagConstraints);
        JLabel jLabel2 = ULabel.createLinkJLabel(this.dialog.nls().getString("Add"), true);
        gridBagConstraints = new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0);
        this.notifSelectionPanel.add((Component)jLabel2, gridBagConstraints);
        jLabel2.addMouseListener(this);
        this.cbNotif.setSelectedIndex(0);
        this.showInputNotifySelectorForType(0);
        return this.notifSelectionPanel;
    }

    private void updateNotifItemsPanel() {
        Dimension dimension = this.notifItemsPanel.getPreferredSize();
        this.notifItemsPanel.removeAll();
        for (int i = 0; i < this.notificationConfig.items.length; ++i) {
            this.notifItemsPanel.add(new NotificationItemLabel(this.notificationConfig.items[i]));
        }
        this.notifItemsPanel.validate();
        Dimension dimension2 = this.notifItemsPanel.getPreferredSize();
        if (dimension2.height != dimension.height) {
            this.dialog.invalidate();
            this.dialog.validate();
            this.dialog.fixHeight();
        }
    }

    protected void removeNotificationItem(NotificationItemLabel notificationItemLabel) {
        for (int i = 0; i < this.notificationConfig.items.length; ++i) {
            if (this.notificationConfig.items[i] != notificationItemLabel.notifItem) continue;
            NotificationItem[] notificationItemArray = new NotificationItem[this.notificationConfig.items.length - 1];
            System.arraycopy(this.notificationConfig.items, 0, notificationItemArray, 0, i);
            if (i < this.notificationConfig.items.length - 1) {
                System.arraycopy(this.notificationConfig.items, i + 1, notificationItemArray, i, this.notificationConfig.items.length - i - 1);
            }
            this.notificationConfig.items = notificationItemArray;
            this.notifItemsPanel.remove(notificationItemLabel);
            this.notifItemsPanel.validate();
            this.notifItemsPanel.repaint();
            break;
        }
    }

    private void showInputNotifySelectorForType(int n) {
        switch (n) {
            case 0: {
                this.txtFieldEmail.setVisible(false);
                this.cbUser.setVisible(false);
                this.cbTeam.setVisible(false);
                break;
            }
            case 2: {
                this.txtFieldEmail.setVisible(false);
                this.cbUser.setVisible(true);
                this.cbTeam.setVisible(false);
                break;
            }
            case 1: {
                this.txtFieldEmail.setVisible(false);
                this.cbUser.setVisible(false);
                this.cbTeam.setVisible(true);
                break;
            }
            default: {
                this.txtFieldEmail.setVisible(true);
                this.cbUser.setVisible(false);
                this.cbTeam.setVisible(false);
            }
        }
        this.invalidate();
        this.validate();
        this.dialog.fixHeight();
    }

    public NotificationConfig getNotificationConfig() {
        return this.notificationConfig;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        NotifType notifType = (NotifType)this.cbNotif.getSelectedItem();
        boolean bl = false;
        switch (notifType.type) {
            case 0: {
                bl = this.notificationConfig.addItem(new NotificationItem(0, "*", "Everyone"));
                break;
            }
            case 2: {
                ProjectResource projectResource = (ProjectResource)this.cbUser.getSelectedItem();
                NotificationItem notificationItem = new NotificationItem(2, projectResource.getDn(), projectResource.getCn());
                bl = this.notificationConfig.addItem(notificationItem) || bl;
                break;
            }
            case 1: {
                ProjectTeam projectTeam = (ProjectTeam)this.cbTeam.getSelectedItem();
                NotificationItem notificationItem = new NotificationItem(1, projectTeam.getId(), projectTeam.getLabel());
                bl = this.notificationConfig.addItem(notificationItem) || bl;
                break;
            }
            case 3: {
                String string = this.txtFieldEmail.getText();
                if (StringValidator.isValidEmailAddress(string)) {
                    bl = this.notificationConfig.addItem(new NotificationItem(3, string, string));
                    break;
                }
                WDDialog.showMsgDialog(this, this.dialog.nls().getString("email_invalid"));
            }
        }
        if (bl) {
            this.updateNotifItemsPanel();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private class NotifType {
        private int type;

        private NotifType(int n) {
            this.type = n;
        }

        public String toString() {
            return NotificationsPanel.this.dialog.nls().getString(NotificationItem.getTypeName(this.type) + "Notif");
        }
    }

    private class NotificationItemLabel
    extends JPanel
    implements MouseListener {
        private NotificationItem notifItem;

        public NotificationItemLabel(NotificationItem notificationItem) {
            this.notifItem = notificationItem;
            this.setOpaque(true);
            this.setLayout(new BoxLayout(this, 2));
            this.setBorder(new LineBorder(NOTIFITEM_BORDER_COLOR, 1, true));
            this.setBackground(NOTIFITEM_BACKGROUND_COLOR);
            JLabel jLabel = new JLabel(notificationItem.label);
            jLabel.setOpaque(false);
            jLabel.setFont(jLabel.getFont().deriveFont(0));
            jLabel.setForeground(ULabel.LINK_TEXT_COLOR);
            this.add(jLabel);
            JLabel jLabel2 = new JLabel(WDUtil.getIcon("window_close.gif"));
            jLabel2.setCursor(Cursor.getPredefinedCursor(12));
            jLabel2.addMouseListener(this);
            jLabel2.setOpaque(false);
            this.add(jLabel2);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            NotificationsPanel.this.removeNotificationItem(this);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

