/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.social;

import com.flowbuilder.util.TString;
import com.flowbuilder.util.xml.JDOMUtil;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TimeUnit;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.AppGlobalContext;
import com.triloggroup.gantt.app.GanttActions;
import com.triloggroup.gantt.app.GanttWorkbenchPage;
import com.triloggroup.gantt.app.UserPreferences;
import com.triloggroup.gantt.app.social.BookmarkTaskPickerDialog;
import com.triloggroup.gantt.app.social.BookmarksAndCommentsDialog;
import com.triloggroup.gantt.app.social.CustomBookmarkSupport;
import com.triloggroup.gantt.app.social.RecentCommentsSettingsDialog;
import com.triloggroup.gantt.app.social.SocialManager;
import com.triloggroup.gantt.app.social.XSPSocialActions;
import com.triloggroup.gantt.app.ui.AsyncActionRunner;
import com.triloggroup.gantt.app.ui.CancelAsyncActionException;
import com.triloggroup.gantt.app.ui.IAsyncAction;
import com.triloggroup.gantt.app.ui.WDButton;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.gantt.pe.app.PEAppProjectContext;
import com.triloggroup.gantt.pe.app.social.SocialWSHelper;
import com.triloggroup.gantt.treetable.TGTreeTable;
import com.triloggroup.project.social.Bookmark;
import com.triloggroup.util.NLSBundle;
import com.triloggroup.util.UString;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jdom.Element;

public class GanttActionsWithSocial
extends GanttActions {
    public GanttActionsWithSocial(AppGanttChart appGanttChart, JComponent jComponent) {
        super(appGanttChart, jComponent);
    }

    protected void initAdditionalActions() {
        super.initAdditionalActions();
    }

    public void showSocialData(GanttNode ganttNode, boolean bl) {
        try {
            if (bl && this.checkSubprojetNotLoaded(ganttNode)) {
                return;
            }
            TGTreeTable tGTreeTable = this.chart.getTreeTable();
            int n = this.chart.getModel().getRowIndex(ganttNode);
            if (n < 0) {
                throw new Exception("Node is not visible");
            }
            Rectangle rectangle = tGTreeTable.getCellRect(n, tGTreeTable.convertColumnIndexToView(0), false);
            BookmarksAndCommentsDialog bookmarksAndCommentsDialog = BookmarksAndCommentsDialog.createDialog(this.chart, ganttNode);
            bookmarksAndCommentsDialog.setAutoEditNewComment(bl);
            Point point = rectangle.getLocation();
            point.y += rectangle.height;
            SwingUtilities.convertPointToScreen(point, tGTreeTable);
            bookmarksAndCommentsDialog.setLocation(point);
            int n2 = Math.max(200, rectangle.width);
            bookmarksAndCommentsDialog.setMinimumSize(new Dimension(n2, 100));
            bookmarksAndCommentsDialog.pack();
            int n3 = n2 < 500 ? Math.min(500, tGTreeTable.getWidth()) : n2;
            int n4 = bookmarksAndCommentsDialog.getPreferredSize().height;
            bookmarksAndCommentsDialog.setSize(n3, n4);
            bookmarksAndCommentsDialog.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected JPopupMenu createViewOptionsPopupMenu(ActionEvent actionEvent, final Component component) {
        JPopupMenu jPopupMenu = super.createViewOptionsPopupMenu(actionEvent, component);
        jPopupMenu.addSeparator();
        UserPreferences userPreferences = this.chart.getUserPreferences();
        String string = AppGanttChart.NLS_BUNDLE.getString("recentcomment_highlight");
        if (userPreferences.getRecentCommentsDays() > 0) {
            int n = userPreferences.getRecentCommentsDays();
            TimeUnit timeUnit = this.chart.getModel().getGlobalContext().getTimeUnits().getDayTimeUnit();
            string = "<html>" + WDUtil.swingHtmlEscape(string) + " <i>(" + n + ' ' + WDUtil.swingHtmlEscape(n > 1 ? timeUnit.getShortLabelPlural() : timeUnit.getShortLabel()) + ")</i></html>";
        }
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
        final boolean bl = userPreferences.getRecentCommentsHighlight();
        jCheckBoxMenuItem.setSelected(bl);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl2 = !bl;
                GanttActionsWithSocial.this.chart.getUserPreferences().setRecentCommentsHighlight(bl2);
                GanttActionsWithSocial.this.chart.getTreeTable().repaint();
            }
        });
        jPopupMenu.add(jCheckBoxMenuItem);
        JMenuItem jMenuItem = new JMenuItem(AppGanttChart.NLS_BUNDLE.getString("recentcomment_settings"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RecentCommentsSettingsDialog.showDialog(GanttActionsWithSocial.this.chart, component);
                GanttActionsWithSocial.this.chart.getTreeTable().repaint();
            }
        });
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    public JMenu createNewBookmarkMenu(final GanttNode ganttNode, final BookmarksAndCommentsDialog bookmarksAndCommentsDialog) {
        JMenuItem jMenuItem;
        JMenuItem jMenuItem2;
        NLSBundle nLSBundle = AppGanttChart.NLS_BUNDLE;
        JMenu jMenu = new JMenu(nLSBundle.getString("addBookmark"));
        jMenu.setIcon(SocialManager.BOOKMARK_ICON);
        boolean bl = this.chart.getWorkbenchPage().isApplet();
        AppGlobalContext appGlobalContext = this.chart.getModel().getGlobalContext();
        if (bl) {
            jMenuItem2 = new JMenuItem(nLSBundle.getString("document"), WDUtil.getIcon("social/default.gif"));
            jMenuItem2.addActionListener(new CreateBookmarkActionListener(ganttNode, bookmarksAndCommentsDialog){

                protected void createBookmark() {
                    GanttActionsWithSocial.this.createXSPSociaActions().addDocumentBookmark(ganttNode, bookmarksAndCommentsDialog);
                }
            });
            jMenu.add(jMenuItem2);
        }
        jMenuItem2 = new JMenuItem(nLSBundle.getString("task"), WDUtil.getIcon("social/task.gif"));
        jMenuItem2.addActionListener(new CreateBookmarkActionListener(ganttNode, bookmarksAndCommentsDialog){

            protected void createBookmark() {
                GanttActionsWithSocial.this.addTaskBookmark(ganttNode, bookmarksAndCommentsDialog, this.getCloseDialogRunnable());
            }
        });
        jMenu.add(jMenuItem2);
        if (bl) {
            if (appGlobalContext.hasIssuesModule()) {
                jMenuItem = new JMenuItem(nLSBundle.getString("issue"), WDUtil.getIcon("social/issue.gif"));
                jMenuItem.addActionListener(new CreateBookmarkActionListener(ganttNode, bookmarksAndCommentsDialog){

                    protected void createBookmark() {
                        GanttActionsWithSocial.this.createXSPSociaActions().addIssueBookmark(ganttNode, bookmarksAndCommentsDialog);
                    }
                });
                jMenu.add(jMenuItem);
            }
            if (appGlobalContext.hasChangesModule()) {
                jMenuItem = new JMenuItem(nLSBundle.getString("changeRequest"), WDUtil.getIcon("social/change.gif"));
                jMenuItem.addActionListener(new CreateBookmarkActionListener(ganttNode, bookmarksAndCommentsDialog){

                    protected void createBookmark() {
                        GanttActionsWithSocial.this.createXSPSociaActions().addChangeBookmark(ganttNode, bookmarksAndCommentsDialog);
                    }
                });
                jMenu.add(jMenuItem);
            }
        }
        jMenuItem = new JMenuItem(nLSBundle.getString("link"), WDUtil.getIcon("social/url.gif"));
        jMenuItem.addActionListener(new CreateBookmarkActionListener(ganttNode, bookmarksAndCommentsDialog){

            protected void createBookmark() {
                GanttActionsWithSocial.this.addLinkBookmark(ganttNode, bookmarksAndCommentsDialog);
            }
        });
        jMenu.add(jMenuItem);
        if (bl && appGlobalContext.isLCActivityEnabled()) {
            JMenuItem jMenuItem3 = new JMenuItem(nLSBundle.getString("activity"), WDUtil.getIcon("social/activity.gif"));
            jMenuItem3.addActionListener(new CreateBookmarkActionListener(ganttNode, bookmarksAndCommentsDialog){

                protected void createBookmark() {
                    GanttActionsWithSocial.this.createXSPSociaActions().addActivityBookmark(ganttNode, bookmarksAndCommentsDialog);
                }
            });
            jMenu.add(jMenuItem3);
        }
        if (bl && appGlobalContext.hasBookmarkExtension()) {
            this.startUpdateBookmarkMenuUpdater(jMenu, ganttNode, bookmarksAndCommentsDialog);
        }
        return jMenu;
    }

    private boolean checkSubprojetNotLoaded(GanttNode ganttNode) {
        if (GanttNode.isSubprojectLinkNotLoaded(ganttNode)) {
            WDDialog.showMsgDialog(this.chart.getView(), AppGanttChart.NLS_BUNDLE.getString("actionNotAvailableSubprojectNotLoaded"));
            return true;
        }
        return false;
    }

    private void addTaskBookmark(GanttNode ganttNode, BookmarksAndCommentsDialog bookmarksAndCommentsDialog, Runnable runnable) {
        Object object;
        BookmarkTaskPickerDialog bookmarkTaskPickerDialog = BookmarkTaskPickerDialog.createBookmarkTaskPicker(this.chart.getView(), ganttNode instanceof GanttTask);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(ganttNode.getUid());
        if (ganttNode.getSocialData().getBookmarkCount() > 0) {
            try {
                for (Bookmark[] bookmarkArray : object = this.chart.getSocialManager().getBookmarksAndCommentsForNode((GanttNode)ganttNode).bookmarks) {
                    if (bookmarkArray.type != 3) continue;
                    hashSet.add(bookmarkArray.peId);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object = this.chart.getModel().getProjectModel(ganttNode.getProjectId()).getAllNodes().iterator();
        ArrayList arrayList = new ArrayList();
        while (object.hasNext()) {
            GanttNode ganttNode2 = (GanttNode)object.next();
            if (!ganttNode2.isReadeable() || !(ganttNode2 instanceof GanttTask) || hashSet.contains(ganttNode2.getUid())) continue;
            arrayList.add((GanttTask)ganttNode2);
        }
        GanttTask[] ganttTaskArray = arrayList.toArray(new GanttTask[arrayList.size()]);
        Arrays.sort(ganttTaskArray, TGNode.sortedIdComparator);
        bookmarkTaskPickerDialog.init(ganttTaskArray, false);
        bookmarkTaskPickerDialog.setVisible(-1, -1, -1, 600, this.chart.getView());
        GanttTask ganttTask = (GanttTask)bookmarkTaskPickerDialog.getSingleSelection();
        if (ganttTask != null) {
            Bookmark[] bookmarkArray;
            if (!this.chart.getSocialManager().checkOnServer(ganttTask, runnable)) {
                return;
            }
            bookmarkArray = new Bookmark[]{new Bookmark()};
            bookmarkArray[0].type = 3;
            AppGlobalContext appGlobalContext = this.chart.getModel().getGlobalContext();
            bookmarkArray[0].authorDn = appGlobalContext.getCurrentUserDn();
            bookmarkArray[0].authorCn = appGlobalContext.getCurrentUserCn();
            bookmarkArray[0].date = ganttTask.getStartDate();
            bookmarkArray[0].title = ganttTask.getName();
            bookmarkArray[0].docId = ganttTask.getDocId();
            bookmarkArray[0].peId = ganttTask.getUid();
            try {
                this.chart.getSocialManager().addBookmarksAndShow(ganttNode, bookmarkArray, new boolean[]{bookmarkTaskPickerDialog.isAddReverseBookmarkSelected()}, bookmarksAndCommentsDialog);
            }
            catch (Exception exception) {
                WDDialog.showErrorMsgDialog(this.chart.getView(), exception);
            }
        }
    }

    private void addLinkBookmark(GanttNode ganttNode, BookmarksAndCommentsDialog bookmarksAndCommentsDialog) {
        WDDialog wDDialog = WDDialog.createWDDialog(this.chart.getView(), true, false);
        wDDialog.setResizable(true);
        WDDialog.DisposeActionListener disposeActionListener = new WDDialog.DisposeActionListener(wDDialog);
        WDButton wDButton = WDUtil.createOkButton();
        WDButton wDButton2 = WDUtil.createCancelButton();
        wDButton.addActionListener(disposeActionListener);
        wDButton2.addActionListener(disposeActionListener);
        JTextField jTextField = new JTextField(30);
        JTextField jTextField2 = new JTextField(30);
        jTextField2.setText("http://");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 5, 5), 0, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 5, 5), 0, 0);
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        NLSBundle nLSBundle = AppGanttChart.NLS_BUNDLE;
        JLabel jLabel = new JLabel(nLSBundle.getString("Name") + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagLayout.setConstraints(jTextField, gridBagConstraints2);
        jPanel.add(jTextField);
        JLabel jLabel2 = new JLabel(nLSBundle.getString("link") + ": ");
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        gridBagLayout.setConstraints(jTextField2, gridBagConstraints2);
        jPanel.add(jTextField2);
        wDDialog.add((Component)jPanel, "North");
        wDDialog.add((Component)WDDialog.createButtonPanel(wDButton, wDButton2), "South");
        wDDialog.pack();
        wDDialog.setLocationRelativeTo(this.chart.getView());
        wDDialog.setVisible(true);
        wDDialog.dispose();
        if (disposeActionListener.source != wDButton) {
            return;
        }
        if (UString.isEmpty(jTextField2.getText())) {
            return;
        }
        Bookmark[] bookmarkArray = new Bookmark[]{new Bookmark()};
        bookmarkArray[0].type = 6;
        AppGlobalContext appGlobalContext = this.chart.getModel().getGlobalContext();
        bookmarkArray[0].authorDn = appGlobalContext.getCurrentUserDn();
        bookmarkArray[0].authorCn = appGlobalContext.getCurrentUserCn();
        bookmarkArray[0].date = new Date();
        bookmarkArray[0].title = jTextField.getText();
        bookmarkArray[0].url = jTextField2.getText();
        if (TString.isEmpty(bookmarkArray[0].title)) {
            bookmarkArray[0].title = bookmarkArray[0].url;
        }
        try {
            this.chart.getSocialManager().addBookmarksAndShow(ganttNode, bookmarkArray, new boolean[]{false}, bookmarksAndCommentsDialog);
        }
        catch (Exception exception) {
            WDDialog.showErrorMsgDialog(this.chart.getView(), exception);
        }
    }

    public XSPSocialActions createXSPSociaActions() {
        GanttWorkbenchPage ganttWorkbenchPage = this.chart.getWorkbenchPage();
        return new XSPSocialActions(this.chart.getView(), ganttWorkbenchPage.getApplet());
    }

    private void startUpdateBookmarkMenuUpdater(final JMenu jMenu, final GanttNode ganttNode, final BookmarksAndCommentsDialog bookmarksAndCommentsDialog) {
        IAsyncAction iAsyncAction = new IAsyncAction(){

            public Object awtBeforeRun() throws CancelAsyncActionException {
                jMenu.addSeparator();
                jMenu.add(AppGanttChart.NLS_BUNDLE.getString("loading"));
                return null;
            }

            public Object asyncRun(Object object) throws Throwable {
                SocialWSHelper socialWSHelper = new SocialWSHelper((PEAppProjectContext)ganttNode.getProjectContext());
                return socialWSHelper.getAvailableCustomBookmarks(ganttNode);
            }

            public void awtAfterRun(Object object, Throwable throwable) {
                jMenu.remove(jMenu.getItem(jMenu.getItemCount() - 1));
                if (throwable != null || object == null) {
                    return;
                }
                List list = ((Element)object).getChildren("bookmark");
                if (list.isEmpty()) {
                    return;
                }
                AppGlobalContext appGlobalContext = (AppGlobalContext)ganttNode.getGlobalContext();
                for (Element element : list) {
                    final String string = element.getChildText("addCode");
                    if (UString.isEmpty(string)) continue;
                    final int n = JDOMUtil.getInteger(element, "type");
                    String string2 = element.getChildText("label");
                    String string3 = element.getChildText("icon");
                    Icon icon = CustomBookmarkSupport.getBookmarkIcon(string3, appGlobalContext);
                    JMenuItem jMenuItem = new JMenuItem(string2, icon);
                    jMenuItem.addActionListener(new CreateBookmarkActionListener(ganttNode, bookmarksAndCommentsDialog){

                        protected void createBookmark() {
                            GanttActionsWithSocial.this.createXSPSociaActions().addCustomBookmark(ganttNode, bookmarksAndCommentsDialog, n, string);
                        }
                    });
                    jMenu.add(jMenuItem);
                }
                jMenu.getPopupMenu().pack();
            }
        };
        new AsyncActionRunner(iAsyncAction).runAction();
    }

    private abstract class CreateBookmarkActionListener
    implements ActionListener,
    Runnable {
        private GanttNode node;
        private BookmarksAndCommentsDialog dialog;

        private CreateBookmarkActionListener(GanttNode ganttNode, BookmarksAndCommentsDialog bookmarksAndCommentsDialog) {
            this.node = ganttNode;
            this.dialog = bookmarksAndCommentsDialog;
        }

        public void run() {
            if (this.dialog != null) {
                this.dialog.close();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!GanttActionsWithSocial.this.chart.getSocialManager().checkOnServer(this.node, this.getCloseDialogRunnable())) {
                return;
            }
            if (GanttActionsWithSocial.this.checkSubprojetNotLoaded(this.node)) {
                return;
            }
            this.createBookmark();
        }

        protected abstract void createBookmark();

        protected Runnable getCloseDialogRunnable() {
            return this;
        }
    }
}

