/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.social;

import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.social.BookmarkPanel;
import com.triloggroup.gantt.app.social.CommentBorder;
import com.triloggroup.gantt.app.social.CommentPanel;
import com.triloggroup.gantt.app.social.CustomBookmarkSupport;
import com.triloggroup.gantt.app.social.NotificationsPanel;
import com.triloggroup.gantt.app.social.SocialDateTimeFormat;
import com.triloggroup.gantt.app.social.SocialManager;
import com.triloggroup.gantt.app.social.XSPSocialActions;
import com.triloggroup.gantt.app.ui.AsyncActionRunner;
import com.triloggroup.gantt.app.ui.CancelAsyncActionException;
import com.triloggroup.gantt.app.ui.IAsyncAction;
import com.triloggroup.gantt.app.ui.ULabel;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.gantt.pe.app.PEAppProjectContext;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.project.social.Bookmark;
import com.triloggroup.project.social.BookmarksAndComments;
import com.triloggroup.project.social.CommentEntry;
import com.triloggroup.project.social.NotificationConfig;
import com.triloggroup.util.NLSBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.metal.MetalScrollBarUI;

class BookmarksAndCommentsDialog
extends WDDialog
implements ChangeListener,
BookmarkPanel.IDeleteBookmark {
    static final boolean USE_IC4_UI = true;
    static final Color COMMENT_BACKGROUND_COLOR = new Color(242, 242, 242);
    static final Color GRAY_TEXT_COLOR = new Color(102, 102, 102);
    static final int MIN_HEIGHT = 100;
    static final int PREF_MAX_HEIGHT = 500;
    static final int MIN_WIDTH = 200;
    static final int PREF_WIDTH = 500;
    private JScrollPane scroll;
    private JComponent bookmarksPanel;
    private JComponent commentsPanel;
    private GanttNode node;
    private BookmarksAndComments bookmarksAndComments;
    private ArrayList<CommentEntry> topLevelComments;
    private HashMap<String, ArrayList<CommentEntry>> childrenByParentId;
    DateFormat messageDateFormat;
    DateFormat bookmarkDateFormat;
    DateFormat scheduleBookmarkDateFormat;
    AppGanttChart gantt;
    private boolean autoEditNewComment = false;
    private ViewAllCommentsMouseListener viewAllCommentsLsnr = new ViewAllCommentsMouseListener();

    public static BookmarksAndCommentsDialog createDialog(AppGanttChart appGanttChart, GanttNode ganttNode) {
        JComponent jComponent = appGanttChart.getView();
        Window window = SwingUtilities.getWindowAncestor(jComponent);
        GraphicsConfiguration graphicsConfiguration = WDUtil.getGraphicsConfiguration(jComponent);
        BookmarksAndCommentsDialog bookmarksAndCommentsDialog = new BookmarksAndCommentsDialog(window, graphicsConfiguration);
        bookmarksAndCommentsDialog.init(appGanttChart, ganttNode);
        return bookmarksAndCommentsDialog;
    }

    protected BookmarksAndCommentsDialog(Window window, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
        this.setModalityGlassPane(true);
    }

    public boolean canDisposeByClickingOutside() {
        if (this.commentsPanel != null) {
            int n = this.commentsPanel.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = this.commentsPanel.getComponent(i);
                if (!(component instanceof CommentPanel) || !((CommentPanel)component).isEditInProgress()) continue;
                return false;
            }
        }
        return true;
    }

    private void init(AppGanttChart appGanttChart, GanttNode ganttNode) {
        this.gantt = appGanttChart;
        this.node = ganttNode;
        this.scrollWidth = 0;
        this.setDragHeader(true);
        this.load();
    }

    void load() {
        IAsyncAction iAsyncAction = new IAsyncAction(){

            public Object awtBeforeRun() throws CancelAsyncActionException {
                BookmarksAndCommentsDialog.this.getContentPane().removeAll();
                ImageIcon imageIcon = WDUtil.getIcon("loading.gif");
                JLabel jLabel = new JLabel(imageIcon);
                jLabel.setPreferredSize(new Dimension(100, 100));
                BookmarksAndCommentsDialog.this.getContentPane().add((Component)jLabel, "Center");
                return null;
            }

            public Object asyncRun(Object object) throws Throwable {
                return BookmarksAndCommentsDialog.this.gantt.getSocialManager().getBookmarksAndCommentsForNode(BookmarksAndCommentsDialog.this.node);
            }

            public void awtAfterRun(Object object, Throwable throwable) {
                if (throwable != null) {
                    BookmarksAndCommentsDialog.this.dispose();
                    WDDialog.showErrorMsgDialog(BookmarksAndCommentsDialog.this.gantt.getTreeTable(), throwable);
                    return;
                }
                if (BookmarksAndCommentsDialog.this.isVisible()) {
                    BookmarksAndCommentsDialog.this.setBookmarksAndComments((BookmarksAndComments)object);
                }
            }
        };
        new AsyncActionRunner(iAsyncAction).runAction();
    }

    public GanttNode getNode() {
        return this.node;
    }

    /*
     * WARNING - void declaration
     */
    private void setBookmarksAndComments(BookmarksAndComments bookmarksAndComments) {
        void var7_17;
        void var7_14;
        int n;
        this.gantt.getSocialManager().setIconChangeListener(this);
        this.bookmarksAndComments = bookmarksAndComments;
        String string = this.nls().getString("today_link");
        String string2 = this.nls().getString("yesterday");
        this.messageDateFormat = new SocialDateTimeFormat(string, string2);
        this.bookmarkDateFormat = new SocialDateTimeFormat();
        TimeZone timeZone = this.gantt.getModel().getGlobalContext().getClientTimeZone();
        if (timeZone != null && !timeZone.equals(Workbench.get().getTimeZone())) {
            this.scheduleBookmarkDateFormat = new SocialDateTimeFormat();
            this.messageDateFormat.setTimeZone(timeZone);
            this.bookmarkDateFormat.setTimeZone(timeZone);
        } else {
            this.scheduleBookmarkDateFormat = this.bookmarkDateFormat;
        }
        this.setResizable(true);
        MainPanel mainPanel = new MainPanel();
        this.bookmarksPanel = Box.createVerticalBox();
        for (Bookmark bookmark : bookmarksAndComments.bookmarks) {
            this.bookmarksPanel.add(new BookmarkPanel(this, bookmark, this));
        }
        if (this.gantt.getSocialManager().canAddBookmark() && !GanttNode.isSubprojectLinkNotLoaded(this.node)) {
            final JLabel jLabel = ULabel.createLinkJLabel(this.nls().getString("addBookmark"), true);
            jLabel.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    JMenu jMenu = BookmarksAndCommentsDialog.this.gantt.getActions().createNewBookmarkMenu(BookmarksAndCommentsDialog.this.node, BookmarksAndCommentsDialog.this);
                    jMenu.getPopupMenu().show(jLabel, mouseEvent.getX(), mouseEvent.getY());
                }
            });
            Box box = Box.createHorizontalBox();
            box.add(Box.createHorizontalGlue());
            box.add(jLabel);
            this.bookmarksPanel.add(box);
        }
        mainPanel.add(this.bookmarksPanel);
        this.topLevelComments = new ArrayList();
        this.childrenByParentId = new HashMap();
        for (CommentEntry commentEntry : bookmarksAndComments.comments) {
            if (commentEntry.parentId == null) {
                this.topLevelComments.add(commentEntry);
                continue;
            }
            ArrayList<CommentEntry> arrayList = this.childrenByParentId.get(commentEntry.parentId);
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.childrenByParentId.put(commentEntry.parentId, arrayList);
            }
            arrayList.add(commentEntry);
        }
        for (ArrayList jPanel : this.childrenByParentId.values()) {
            if (jPanel.size() <= 1) continue;
            Collections.sort(jPanel, Collections.reverseOrder(SocialManager.COMMENT_DATE_COMPARATOR));
        }
        Collections.sort(this.topLevelComments, new Comparator<CommentEntry>(){

            @Override
            public int compare(CommentEntry commentEntry, CommentEntry commentEntry2) {
                Date date = commentEntry.date;
                Date date2 = commentEntry2.date;
                ArrayList arrayList = (ArrayList)BookmarksAndCommentsDialog.this.childrenByParentId.get(commentEntry.id);
                if (arrayList != null) {
                    date = ((CommentEntry)arrayList.get((int)(arrayList.size() - 1))).date;
                }
                if ((arrayList = (ArrayList)BookmarksAndCommentsDialog.this.childrenByParentId.get(commentEntry2.id)) != null) {
                    date2 = ((CommentEntry)arrayList.get((int)(arrayList.size() - 1))).date;
                }
                return date.compareTo(date2);
            }
        });
        this.commentsPanel = Box.createVerticalBox();
        int n2 = n = this.topLevelComments.size() > 4 ? this.topLevelComments.size() - 3 : 0;
        if (n > 0) {
            JPanel i = this.createViewAllCommentsPanel(null);
            this.commentsPanel.add(i);
        }
        int jTextArea = n;
        while (var7_14 < this.topLevelComments.size()) {
            CommentEntry commentEntry = this.topLevelComments.get((int)var7_14);
            this.addComment(commentEntry, var7_14 == false);
            ++var7_14;
        }
        Object var7_15 = null;
        if (this.canAddComment()) {
            CommentPanel commentPanel = new CommentPanel(this, null);
            commentPanel.init(this.topLevelComments.size() == 0);
            if (this.autoEditNewComment) {
                JTextArea jTextArea2 = commentPanel.editTextArea;
            }
            this.commentsPanel.add(commentPanel);
        }
        mainPanel.add(this.commentsPanel);
        this.getContentPane().remove(0);
        this.scroll = new JScrollPane(mainPanel);
        this.scroll.getVerticalScrollBar().setUI(new MetalScrollBarUI(){

            public void paint(Graphics graphics, JComponent jComponent) {
                Rectangle rectangle = this.getThumbBounds();
                if (rectangle.height == 0) {
                    this.decrButton.setVisible(false);
                    this.incrButton.setVisible(false);
                } else {
                    this.decrButton.setVisible(true);
                    this.incrButton.setVisible(true);
                    super.paint(graphics, jComponent);
                }
            }
        });
        this.scroll.setVerticalScrollBarPolicy(22);
        this.getContentPane().add((Component)this.scroll, "Center");
        this.validate();
        this.fixHeight();
        if (var7_17 != null) {
            Rectangle rectangle = new Rectangle(0, mainPanel.getHeight(), 1, 1);
            this.scroll.getViewport().scrollRectToVisible(rectangle);
            var7_17.requestFocusInWindow();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BookmarksAndCommentsDialog.this.scroll.getViewport().setViewPosition(new Point(0, 0));
                }
            });
        }
    }

    void fixHeight() {
        Component component = this.scroll.getViewport().getView();
        Dimension dimension = component.getPreferredSize();
        Dimension dimension2 = this.scroll.getViewport().getSize();
        if (dimension.height != dimension2.height) {
            int n = dimension.height - dimension2.height;
            int n2 = this.getHeight() + n;
            if (n2 < 100) {
                n2 = 100;
            } else if (n2 > 500) {
                n2 = Math.max(500, this.getHeight());
            }
            this.setSize(this.getWidth(), n2);
        }
    }

    void bookmarksAdded(Bookmark[] bookmarkArray) {
        for (Bookmark bookmark : bookmarkArray) {
            BookmarkPanel bookmarkPanel = new BookmarkPanel(this, bookmark, this);
            this.bookmarksPanel.add((Component)bookmarkPanel, this.bookmarksPanel.getComponentCount() - 1);
        }
        this.getContentPane().validate();
    }

    public void deleteBookmark(final BookmarkPanel bookmarkPanel) {
        IAsyncAction iAsyncAction = new IAsyncAction(){

            public Object awtBeforeRun() throws CancelAsyncActionException {
                return null;
            }

            public Object asyncRun(Object object) throws Throwable {
                BookmarksAndCommentsDialog.this.gantt.getSocialManager().deleteBookmarkOnServer(bookmarkPanel.bookmark, BookmarksAndCommentsDialog.this.node);
                return null;
            }

            public void awtAfterRun(Object object, Throwable throwable) {
                if (throwable != null) {
                    throwable.printStackTrace();
                    WDDialog.showErrorMsgDialog(bookmarkPanel, throwable);
                    return;
                }
                BookmarksAndCommentsDialog.this.bookmarksPanel.remove(bookmarkPanel);
                BookmarksAndCommentsDialog.this.validate();
            }
        };
        AsyncActionRunner asyncActionRunner = new AsyncActionRunner(iAsyncAction, this, this.nls().getString("saving"));
        asyncActionRunner.setUseNewUI(false);
        asyncActionRunner.runAction();
    }

    void openBookmark(Bookmark bookmark, MouseEvent mouseEvent) {
        switch (bookmark.type) {
            case 3: {
                GanttNode ganttNode = this.gantt.getModel().getProjectModel(this.getNode().getProjectId()).getNodeByUid(bookmark.peId);
                this.gantt.showNodeDetail(ganttNode, this.getScreenPoint(mouseEvent));
                return;
            }
            case 1: 
            case 6: 
            case 7: {
                XSPSocialActions xSPSocialActions = this.getXSPSocialActions();
                if (xSPSocialActions.openBrowserTab(bookmark.url)) break;
                return;
            }
            case 4: 
            case 5: {
                XSPSocialActions xSPSocialActions = this.getXSPSocialActions();
                if (xSPSocialActions.showBookmarkForm(bookmark.type, bookmark.docId)) break;
                return;
            }
            default: {
                this.close();
                String string = new CustomBookmarkSupport(this.getNode()).getOpenBookmarkJsCode(bookmark);
                this.getXSPSocialActions().showCustomBookmark(bookmark, string);
            }
        }
        this.close();
    }

    protected XSPSocialActions getXSPSocialActions() {
        return this.gantt.getActions().createXSPSociaActions();
    }

    protected Point getScreenPoint(MouseEvent mouseEvent) {
        if (mouseEvent != null) {
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, (Component)mouseEvent.getSource());
            return point;
        }
        return null;
    }

    private void addComment(CommentEntry commentEntry, boolean bl) {
        this.addComment(commentEntry, bl, -1);
    }

    private void addComment(CommentEntry commentEntry, boolean bl, int n) {
        CommentPanel commentPanel = new CommentPanel(this, commentEntry);
        commentPanel.init(bl);
        this.commentsPanel.add((Component)commentPanel, n);
        if (commentEntry.parentId != null) {
            return;
        }
        ArrayList<CommentEntry> arrayList = this.childrenByParentId.get(commentEntry.id);
        if (arrayList != null) {
            int n2;
            int n3 = n2 = arrayList.size() > 4 ? arrayList.size() - 3 : 0;
            if (n2 > 0) {
                JPanel jPanel = this.createViewAllCommentsPanel(commentEntry.id);
                if (n > -1) {
                    ++n;
                }
                this.commentsPanel.add((Component)jPanel, n);
            }
            for (int i = n2; i < arrayList.size(); ++i) {
                if (n > -1) {
                    ++n;
                }
                this.addComment(arrayList.get(i), false, n);
            }
        }
    }

    NLSBundle nls() {
        return AppGanttChart.NLS_BUNDLE;
    }

    JPanel createViewAllCommentsPanel(String string) {
        boolean bl = string != null;
        PanelForComment panelForComment = new PanelForComment(string);
        panelForComment.setLayout(new BorderLayout());
        panelForComment.setBorder(CommentBorder.create(!bl, bl));
        panelForComment.setBackground(COMMENT_BACKGROUND_COLOR);
        JLabel jLabel = ULabel.createLinkJLabel(this.nls().getString("viewAllComments"), true);
        jLabel.setIcon(SocialManager.MESSAGE_ICON);
        jLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        jLabel.addMouseListener(this.viewAllCommentsLsnr);
        panelForComment.add((Component)jLabel, "West");
        return panelForComment;
    }

    JLabel createSubtitleJLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(GRAY_TEXT_COLOR);
        Font font = jLabel.getFont();
        font = font.deriveFont(0, font.getSize2D() - 1.0f);
        jLabel.setFont(font);
        return jLabel;
    }

    boolean canAddComment() {
        return this.gantt.getSocialManager().canAddComment() && !GanttNode.isSubprojectLinkNotLoaded(this.node);
    }

    boolean canEdit(CommentEntry commentEntry) {
        return ((PEAppProjectContext)this.node.getProjectContext()).isCurrentUserPM() && !GanttNode.isSubprojectLinkNotLoaded(this.node);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BookmarksAndCommentsDialog.this.commentsPanel.repaint();
            }
        });
    }

    void deleteComment(final CommentPanel commentPanel, final Runnable runnable) throws Exception {
        final CommentEntry commentEntry = commentPanel.comment;
        IAsyncAction iAsyncAction = new IAsyncAction(){

            public Object awtBeforeRun() throws CancelAsyncActionException {
                return null;
            }

            public Object asyncRun(Object object) throws Throwable {
                BookmarksAndCommentsDialog.this.gantt.getSocialManager().deleteCommentOnServer(commentEntry, BookmarksAndCommentsDialog.this.node);
                if (commentEntry.parentId == null) {
                    BookmarksAndCommentsDialog.this.topLevelComments.remove(commentEntry);
                    BookmarksAndCommentsDialog.this.childrenByParentId.remove(commentEntry.id);
                } else {
                    ((ArrayList)BookmarksAndCommentsDialog.this.childrenByParentId.get(commentEntry.parentId)).remove(commentEntry);
                }
                return null;
            }

            public void awtAfterRun(Object object, Throwable throwable) {
                if (throwable != null) {
                    WDDialog.showErrorMsgDialog(commentPanel, throwable);
                    return;
                }
                BookmarksAndCommentsDialog.this.commentsPanel.remove(commentPanel);
                Component[] componentArray = BookmarksAndCommentsDialog.this.commentsPanel.getComponents();
                for (Component component : componentArray) {
                    String string = ((PanelForComment)component).parentId;
                    if (string == null || !string.equals(commentEntry.id)) continue;
                    BookmarksAndCommentsDialog.this.commentsPanel.remove(component);
                }
                if (BookmarksAndCommentsDialog.this.commentsPanel.getComponentCount() > 0) {
                    JComponent jComponent = (JComponent)BookmarksAndCommentsDialog.this.commentsPanel.getComponent(0);
                    ((CommentBorder)jComponent.getBorder()).setFirst(true);
                    jComponent.invalidate();
                    if (BookmarksAndCommentsDialog.this.commentsPanel.getComponentCount() == 1) {
                        ((CommentPanel)jComponent).showPostOnWall(((CommentPanel)jComponent).comment == null);
                    }
                }
                BookmarksAndCommentsDialog.this.validate();
                BookmarksAndCommentsDialog.this.fixHeight();
                if (runnable != null) {
                    runnable.run();
                }
            }
        };
        AsyncActionRunner asyncActionRunner = new AsyncActionRunner(iAsyncAction, this, this.nls().getString("saving"));
        asyncActionRunner.setUseNewUI(false);
        asyncActionRunner.runAction();
    }

    void postComment(final CommentEntry commentEntry, final NotificationConfig notificationConfig, final CommentPanel commentPanel, final Runnable runnable) {
        final Container container = commentPanel != null ? commentPanel : this;
        IAsyncAction iAsyncAction = new IAsyncAction(){

            public Object awtBeforeRun() throws CancelAsyncActionException {
                return null;
            }

            public Object asyncRun(Object object) throws Throwable {
                BookmarksAndCommentsDialog.this.gantt.getSocialManager().postCommentOnServer(commentEntry, notificationConfig, BookmarksAndCommentsDialog.this.node, commentPanel.isPostCommentOnWall());
                if (commentEntry.parentId == null) {
                    BookmarksAndCommentsDialog.this.topLevelComments.add(commentEntry);
                } else {
                    ArrayList<CommentEntry> arrayList = (ArrayList<CommentEntry>)BookmarksAndCommentsDialog.this.childrenByParentId.get(commentEntry.parentId);
                    if (arrayList == null) {
                        arrayList = new ArrayList<CommentEntry>();
                        BookmarksAndCommentsDialog.this.childrenByParentId.put(commentEntry.parentId, arrayList);
                    }
                    arrayList.add(commentEntry);
                }
                return null;
            }

            public void awtAfterRun(Object object, Throwable throwable) {
                JComponent jComponent;
                boolean bl;
                if (throwable != null) {
                    WDDialog.showErrorMsgDialog(container, throwable);
                    return;
                }
                boolean bl2 = bl = ((BookmarksAndCommentsDialog)BookmarksAndCommentsDialog.this).bookmarksAndComments.comments.length < 2;
                if (bl) {
                    jComponent = (JComponent)BookmarksAndCommentsDialog.this.commentsPanel.getComponent(0);
                    ((CommentBorder)jComponent.getBorder()).setFirst(false);
                }
                jComponent = new CommentPanel(BookmarksAndCommentsDialog.this, commentEntry);
                ((CommentPanel)jComponent).init(bl);
                if (commentEntry.parentId == null) {
                    BookmarksAndCommentsDialog.this.commentsPanel.add((Component)jComponent, BookmarksAndCommentsDialog.this.commentsPanel.getComponentCount() - 1);
                } else {
                    Component[] componentArray = BookmarksAndCommentsDialog.this.commentsPanel.getComponents();
                    int n = -1;
                    for (int i = 0; i < componentArray.length; ++i) {
                        if (commentPanel != componentArray[i]) continue;
                        n = i;
                        break;
                    }
                    if (n < 0) {
                        throw new IllegalStateException("parent comment panel not found");
                    }
                    ++n;
                    while (n < componentArray.length) {
                        String string = ((PanelForComment)componentArray[n]).parentId;
                        if (!commentEntry.parentId.equals(string)) {
                            --n;
                            break;
                        }
                        ++n;
                    }
                    BookmarksAndCommentsDialog.this.commentsPanel.add((Component)jComponent, n + 1);
                }
                BookmarksAndCommentsDialog.this.validate();
                BookmarksAndCommentsDialog.this.fixHeight();
                if (runnable != null) {
                    runnable.run();
                }
            }
        };
        AsyncActionRunner asyncActionRunner = new AsyncActionRunner(iAsyncAction, container, this.nls().getString("saving"));
        asyncActionRunner.setUseNewUI(false);
        asyncActionRunner.runAction();
    }

    void updateComment(final CommentEntry commentEntry, final CommentPanel commentPanel, final Runnable runnable) {
        IAsyncAction iAsyncAction = new IAsyncAction(){

            public Object awtBeforeRun() throws CancelAsyncActionException {
                return null;
            }

            public Object asyncRun(Object object) throws Throwable {
                BookmarksAndCommentsDialog.this.gantt.getSocialManager().updateCommentOnServer(commentPanel.comment, commentEntry, BookmarksAndCommentsDialog.this.node);
                return null;
            }

            public void awtAfterRun(Object object, Throwable throwable) {
                if (throwable != null) {
                    WDDialog.showErrorMsgDialog(commentPanel, throwable);
                    return;
                }
                if (runnable != null) {
                    runnable.run();
                }
            }
        };
        AsyncActionRunner asyncActionRunner = new AsyncActionRunner(iAsyncAction, commentPanel, this.nls().getString("saving"));
        asyncActionRunner.setUseNewUI(false);
        asyncActionRunner.runAction();
    }

    void loadCommentNotificationConfig(final CommentPanel commentPanel, final Runnable runnable) {
        IAsyncAction iAsyncAction = new IAsyncAction(){

            public Object awtBeforeRun() throws CancelAsyncActionException {
                return null;
            }

            public Object asyncRun(Object object) throws Throwable {
                commentPanel.notificationPanel = new NotificationsPanel(BookmarksAndCommentsDialog.this.gantt.getSocialManager().loadNotificationConfig(BookmarksAndCommentsDialog.this.node), BookmarksAndCommentsDialog.this);
                return null;
            }

            public void awtAfterRun(Object object, Throwable throwable) {
                if (throwable != null) {
                    WDDialog.showErrorMsgDialog(commentPanel, throwable);
                    return;
                }
                if (runnable != null) {
                    runnable.run();
                }
            }
        };
        AsyncActionRunner asyncActionRunner = new AsyncActionRunner(iAsyncAction, commentPanel, this.nls().getString("loading"));
        asyncActionRunner.setUseNewUI(false);
        asyncActionRunner.runAction();
    }

    public void setAutoEditNewComment(boolean bl) {
        this.autoEditNewComment = bl;
    }

    private static class MainPanel
    extends Box
    implements Scrollable {
        MainPanel() {
            super(1);
            this.setBorder(new MatteBorder(0, 4, 0, 4, Color.WHITE));
        }

        public Dimension getPreferredScrollableViewportSize() {
            return super.getPreferredSize();
        }

        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return 20;
        }

        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return n == 0 ? rectangle.width : rectangle.height;
        }

        public boolean getScrollableTracksViewportWidth() {
            int n;
            int n2 = this.getWidth();
            return n2 <= (n = this.getParent().getWidth());
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    static class PanelForComment
    extends JPanel {
        private String parentId;

        PanelForComment(String string) {
            this.parentId = string;
        }
    }

    private class ViewAllCommentsMouseListener
    extends ULabel.LinkHoverMouseAdapter {
        ViewAllCommentsMouseListener() {
            super(false);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Container container = mouseEvent.getComponent().getParent();
            Component[] componentArray = BookmarksAndCommentsDialog.this.commentsPanel.getComponents();
            int n = -1;
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i] != container) continue;
                n = i;
                break;
            }
            BookmarksAndCommentsDialog.this.commentsPanel.remove(container);
            if (n < 0) {
                return;
            }
            CommentEntry commentEntry = null;
            if (componentArray.length > n + 1) {
                commentEntry = ((CommentPanel)componentArray[n + 1]).comment;
            }
            if (n == 0) {
                for (int i = BookmarksAndCommentsDialog.this.topLevelComments.size() - 1; i >= 0; --i) {
                    CommentEntry commentEntry2 = (CommentEntry)BookmarksAndCommentsDialog.this.topLevelComments.get(i);
                    if (commentEntry == null) {
                        BookmarksAndCommentsDialog.this.addComment(commentEntry2, i == 0, 0);
                        continue;
                    }
                    if (commentEntry != commentEntry2) continue;
                    commentEntry = null;
                }
            } else {
                CommentEntry commentEntry3 = ((CommentPanel)componentArray[n - 1]).comment;
                ArrayList arrayList = (ArrayList)BookmarksAndCommentsDialog.this.childrenByParentId.get(commentEntry3.id);
                if (arrayList != null) {
                    if (commentEntry != null && !commentEntry.parentId.equals(commentEntry3.id)) {
                        commentEntry = null;
                    }
                    for (int i = arrayList.size() - 1; i >= 0; --i) {
                        CommentEntry commentEntry4 = (CommentEntry)arrayList.get(i);
                        if (commentEntry == null) {
                            BookmarksAndCommentsDialog.this.addComment(commentEntry4, false, n);
                            continue;
                        }
                        if (commentEntry != commentEntry4) continue;
                        commentEntry = null;
                    }
                }
            }
            BookmarksAndCommentsDialog.this.commentsPanel.validate();
        }
    }
}

