/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.filter;

import com.flowbuilder.util.TString;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttProjectContext;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.ProjectModel;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TGDuration;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.AppGlobalContext;
import com.triloggroup.gantt.app.AppProjectModel;
import com.triloggroup.gantt.app.NodeRef;
import com.triloggroup.gantt.app.Status;
import com.triloggroup.gantt.app.filter.FinancialHealth;
import com.triloggroup.gantt.app.filter.Operator;
import com.triloggroup.gantt.app.filter.ProgressHealth;
import com.triloggroup.gantt.app.filter.ValueType;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

abstract class CriteriaDef {
    private static final CriteriaDef STATUS;
    private static final CriteriaDef TASK_NAME;
    private static final CriteriaDef TASK_DESCRIPTION;
    private static final CriteriaDef RESOURCE;
    private static final CriteriaDef PROGRESS_HEALTH;
    private static final CriteriaDef FINANCIAL_HEALTH;
    private static final CriteriaDef TASK_PROJECTED_COST;
    private static final CriteriaDef TASK_ACTUAL_COST;
    private static final CriteriaDef PROGRESS;
    private static final CriteriaDef PRIORITY;
    private static final CriteriaDef START_DATE;
    private static final CriteriaDef END_DATE;
    private static final CriteriaDef ACTUAL_START_DATE;
    private static final CriteriaDef ACTUAL_END_DATE;
    private static final CriteriaDef HIERARCHICAL_ID;
    private static final CriteriaDef WBS_ASCENDANT;
    private static final CriteriaDef WBS_ASCENDANT_NAME;
    private static final CriteriaDef WBS_ASCENDANT_SUPERVISOR;
    private static final CriteriaDef DURATION;
    private static final CriteriaDef WORK;
    private static final CriteriaDef TOTAL_SLACK;
    private static final CriteriaDef TIMESHEET_HOURS;
    private static final CriteriaDef BOOKMARK_COUNT;
    private static final CriteriaDef COMMENT_COUNT;
    private static final CriteriaDef LAST_COMMENT;
    private static HashMap<String, CriteriaDef> criteriaByCode;
    final String code;
    private final String labelKey;
    private final ValueType valueType;
    private final Operator[] availableOperators;
    private boolean projectSpecific = false;
    private static final long ONE_DAY_MS = 90000000L;

    public static CriteriaDef[] getAvailableCriteria(AppGlobalContext appGlobalContext) {
        boolean bl = appGlobalContext.hasFinancialModule();
        boolean bl2 = appGlobalContext.hasTimesheetModule();
        ArrayList<CriteriaDef> arrayList = new ArrayList<CriteriaDef>();
        arrayList.add(STATUS);
        arrayList.add(TASK_NAME);
        arrayList.add(RESOURCE);
        arrayList.add(PROGRESS_HEALTH);
        arrayList.add(PROGRESS);
        arrayList.add(PRIORITY);
        arrayList.add(DURATION);
        arrayList.add(WORK);
        arrayList.add(TOTAL_SLACK);
        if (bl2) {
            arrayList.add(TIMESHEET_HOURS);
        }
        if (bl) {
            arrayList.add(FINANCIAL_HEALTH);
            arrayList.add(TASK_PROJECTED_COST);
            arrayList.add(TASK_ACTUAL_COST);
        }
        arrayList.add(START_DATE);
        arrayList.add(END_DATE);
        arrayList.add(ACTUAL_START_DATE);
        arrayList.add(ACTUAL_END_DATE);
        arrayList.add(TASK_DESCRIPTION);
        arrayList.add(HIERARCHICAL_ID);
        arrayList.add(WBS_ASCENDANT);
        arrayList.add(WBS_ASCENDANT_NAME);
        arrayList.add(WBS_ASCENDANT_SUPERVISOR);
        arrayList.add(COMMENT_COUNT);
        arrayList.add(LAST_COMMENT);
        arrayList.add(BOOKMARK_COUNT);
        return arrayList.toArray(new CriteriaDef[0]);
    }

    static CriteriaDef fromCode(String string) {
        return criteriaByCode.get(string);
    }

    protected CriteriaDef(String string, String string2, ValueType valueType, Operator[] operatorArray) {
        this.code = string;
        this.labelKey = string2;
        this.valueType = valueType;
        this.availableOperators = operatorArray;
        criteriaByCode.put(string, this);
    }

    public Operator[] getAvailableOperators() {
        return this.availableOperators;
    }

    public String getLabelKey() {
        return this.labelKey;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public boolean isProjectSpecific() {
        return this.projectSpecific;
    }

    public abstract boolean accept(GanttTask var1, Operator var2, Object[] var3);

    protected boolean accept(String string, Operator operator, Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return false;
        }
        if (operator == Operator.IN || operator == Operator.EQUAL) {
            for (Object object : objectArray) {
                if (!TString.equalsIgnoreCase(string, (String)object)) continue;
                return true;
            }
            return false;
        }
        String string2 = (String)objectArray[0];
        if (TString.isEmpty(string2)) {
            return true;
        }
        string = string.toLowerCase();
        string2 = string2.toLowerCase();
        if (operator == Operator.CONTAINS) {
            return string.contains(string2);
        }
        if (operator == Operator.STARTS_WITH) {
            return string.startsWith(string2);
        }
        if (operator == Operator.ENDS_WITH) {
            return string.endsWith(string2);
        }
        throw new IllegalArgumentException("Unsupported operator: " + (Object)((Object)operator));
    }

    protected boolean accept(int n, Operator operator, Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return false;
        }
        if (operator == Operator.IN || operator == Operator.EQUAL) {
            for (Object object : objectArray) {
                if (n != ((Number)object).intValue()) continue;
                return true;
            }
            return false;
        }
        int n2 = ((Number)objectArray[0]).intValue();
        if (operator == Operator.LOWER_THAN_OR_EQUAL) {
            return n <= n2;
        }
        if (operator == Operator.GREATER_THAN_OR_EQUAL) {
            return n >= n2;
        }
        if (operator == Operator.LOWER_THAN) {
            return n < n2;
        }
        if (operator == Operator.GREATER_THAN) {
            return n > n2;
        }
        throw new IllegalArgumentException("Unsupported operator: " + (Object)((Object)operator));
    }

    protected boolean accept(double d, Operator operator, Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return false;
        }
        if (operator == Operator.IN || operator == Operator.EQUAL) {
            for (Object object : objectArray) {
                if (d != ((Number)object).doubleValue()) continue;
                return true;
            }
            return false;
        }
        double d2 = ((Number)objectArray[0]).doubleValue();
        if (operator == Operator.LOWER_THAN_OR_EQUAL) {
            return d <= d2;
        }
        if (operator == Operator.GREATER_THAN_OR_EQUAL) {
            return d >= d2;
        }
        if (operator == Operator.LOWER_THAN) {
            return d < d2;
        }
        if (operator == Operator.GREATER_THAN) {
            return d > d2;
        }
        throw new IllegalArgumentException("Unsupported operator: " + (Object)((Object)operator));
    }

    protected boolean accept(Date date, Operator operator, Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return false;
        }
        Date date2 = (Date)objectArray[0];
        if (date == null) {
            return date2 == null;
        }
        long l = date.getTime();
        long l2 = date2.getTime();
        if (operator == Operator.EQUAL || operator == Operator.IN) {
            if (Math.abs(l2 - l) > 90000000L) {
                return false;
            }
        } else if (operator == Operator.BEFORE || operator == Operator.LOWER_THAN_OR_EQUAL) {
            if (l <= l2) {
                return true;
            }
            if (l > l2 + 90000000L) {
                return false;
            }
        } else if (operator == Operator.AFTER || operator == Operator.GREATER_THAN_OR_EQUAL) {
            if (l >= l2) {
                return true;
            }
            if (l < l2 - 90000000L) {
                return false;
            }
        } else {
            throw new IllegalArgumentException("Unsupported operator: " + (Object)((Object)operator));
        }
        return date.getDate() == date2.getDate();
    }

    public String toString() {
        return AppGanttChart.NLS_BUNDLE.getString(this.labelKey);
    }

    static {
        criteriaByCode = new HashMap();
        STATUS = new CriteriaDef("STATUS", "filter_status", ValueType.STATUS, new Operator[]{Operator.IN}){

            public boolean accept(GanttTask ganttTask, Operator operator, Object[] objectArray) {
                if (objectArray == null) {
                    return false;
                }
                for (Object object : objectArray) {
                    Status status = (Status)object;
                    if (!TString.equals(ganttTask.getStatus(), status.getCode())) continue;
                    return true;
                }
                return false;
            }
        };
        TASK_NAME = new CriteriaDef("TASK_NAME", "filter_name", ValueType.STRING, Operator.stringOperators()){

            public boolean accept(GanttTask ganttTask, Operator operator, Object[] objectArray) {
                String string = ganttTask.getName();
                return this.accept(string, operator, objectArray);
            }
        };
        TASK_DESCRIPTION = new CriteriaDef("TASK_DESCRIPTION", "description", ValueType.STRING, Operator.stringOperators()){

            public boolean accept(GanttTask ganttTask, Operator operator, Object[] objectArray) {
                String string = ganttTask.getNodeDescription();
                return this.accept(string, operator, objectArray);
            }
        };
        PROGRESS = new CriteriaDef("PROGRESS", "Progress", ValueType.INT, Operator.intOperators()){

            public boolean accept(GanttTask ganttTask, Operator operator, Object[] objectArray) {
                int n = (int)(ganttTask.getProgress() * 100.0);
                return this.accept(n, operator, objectArray);
            }
        };
        PRIORITY = new CriteriaDef("PRIORITY", "Priority", ValueType.INT, Operator.intOperators()){

            public boolean accept(GanttTask ganttTask, Operator operator, Object[] objectArray) {
                int n = ganttTask.getPriority();
                return this.accept(n, operator, objectArray);
            }
        };
        START_DATE = new CriteriaDef("START_DATE", "StartDate", ValueType.DATE, Operator.dateOperators()){

            public boolean accept(GanttTask ganttTask, Operator operator, Object[] objectArray) {
                Date date = ganttTask.getStartDate();
                return this.accept(date, operator, objectArray);
            }
        };
        END_DATE = new CriteriaDef("END_DATE", "EndDate", ValueType.DATE, Operator.dateOperators()){

            public boolean accept(GanttTask ganttTask, Operator operator, Object[] objectArray) {
                Date date = ganttTask.getFinishDate();
                return this.accept(date, operator, objectArray);
            }
        };
        ACTUAL_START_DATE = new CriteriaDef("ACTUAL_START_DATE", "ActualStart", ValueType.DATE, Operator.dateOperators()){

            public boolean accept(GanttTask ganttTask, Operator operator, Object[] objectArray) {
                Date date = ganttTask.getActualStartDate();
                return this.accept(date, operator, objectArray);
            }
        };
        ACTUAL_END_DATE = new CriteriaDef("ACTUAL_END_DATE", "ActualFinish", ValueType.DATE, Operator.dateOperators()){

            public boolean accept(GanttTask ganttTask, Operator operator, Object[] objectArray) {
                Date date = ganttTask.getActualFinishDate();
                return this.accept(date, operator, objectArray);
            }
        };
        RESOURCE = new CriteriaDef("RESOURCE", "filter_resources", ValueType.NULLABLE_RESOURCE, new Operator[]{Operator.EQUAL, Operator.IN}){

            public boolean accept(GanttTask ganttTask, Operator operator, Object[] objectArray) {
                if (objectArray == null) {
                    return false;
                }
                TaskResource[] taskResourceArray = ganttTask.getResources();
                for (Object object : objectArray) {
                    if (object == null || object == ValueType.NO_RESOURCE) {
                        if (taskResourceArray.length != 0) continue;
                        return true;
                    }
                    for (TaskResource taskResource : taskResourceArray) {
                        if (!TString.equals(((Resource)object).getDn(), taskResource.getDn())) continue;
                        return true;
                    }
                }
                return false;
            }
        };
        PROGRESS_HEALTH = new CriteriaDef("PROGRESS_HEALTH", "progressHealth", ValueType.PROGRESS_HEALTH, new Operator[]{Operator.EQUAL, Operator.IN}){

            public boolean accept(GanttTask ganttTask, Operator operator, Object[] objectArray) {
                if (objectArray == null) {
                    return false;
                }
                int n = ganttTask.getHealthStatus();
                for (Object object : objectArray) {
                    int n2 = ((ProgressHealth)((Object)object)).getCode();
                    if (n != n2) continue;
                    return true;
                }
                return false;
            }
        };
        FINANCIAL_HEALTH = new CriteriaDef("FINANCIAL_HEALTH", "financialHealth", ValueType.FINANCIAL_HEALTH, new Operator[]{Operator.EQUAL, Operator.IN}){

            public boolean accept(GanttTask ganttTask, Operator operator, Object[] objectArray) {
                if (objectArray == null) {
                    return false;
                }
                int n = ganttTask.getFinancialHealthStatus();
                if (n == -1) {
                    return true;
                }
                for (Object object : objectArray) {
                    int n2 = ((FinancialHealth)((Object)object)).getCode();
                    if (n != n2) continue;
                    return true;
                }
                return false;
            }
        };
        TASK_PROJECTED_COST = new CriteriaDef("TASK_PROJECTED_COST", "filter_taskProjectedCost", ValueType.INT, Operator.intOperators()){

            public boolean accept(GanttTask ganttTask, Operator operator, Object[] objectArray) {
                double d = ganttTask.getProjectedResourceCost() + ganttTask.getProjectedAdditionalCost();
                return this.accept(d, operator, objectArray);
            }
        };
        TASK_ACTUAL_COST = new CriteriaDef("TASK_ACTUAL_COST", "filter_taskActualCost", ValueType.INT, Operator.intOperators()){

            public boolean accept(GanttTask ganttTask, Operator operator, Object[] objectArray) {
                double d = ganttTask.getActualResourceCost() + ganttTask.getActualAdditionalCost();
                return this.accept(d, operator, objectArray);
            }
        };
        HIERARCHICAL_ID = new CriteriaDef("HIERARCHICAL_ID", "filter_hierarchicalId", ValueType.STRING, new Operator[]{Operator.STARTS_WITH}){

            public boolean accept(GanttTask ganttTask, Operator operator, Object[] objectArray) {
                String string = ganttTask.getHierarchicalId();
                return this.accept(string, operator, objectArray);
            }
        };
        WBS_ASCENDANT = new CriteriaDef("WBS_ASCENDANT", "filter_WBSAscendant", ValueType.WBS, new Operator[]{Operator.IN}){

            public boolean accept(GanttTask ganttTask, Operator operator, Object[] objectArray) {
                if (objectArray == null) {
                    return false;
                }
                String string = ganttTask.getSiteId();
                String string2 = ganttTask.getProjectId();
                for (TGNode tGNode = ganttTask.getParent(); tGNode != null; tGNode = tGNode.getParent()) {
                    if (!(tGNode instanceof GanttNode)) continue;
                    String string3 = ((GanttNode)tGNode).getUid();
                    for (Object object : objectArray) {
                        NodeRef nodeRef = (NodeRef)object;
                        if (!TString.equals(string, nodeRef.siteId) || !TString.equals(string2, nodeRef.projectId) || !TString.equals(string3, nodeRef.id)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
        CriteriaDef.WBS_ASCENDANT.projectSpecific = true;
        WBS_ASCENDANT_NAME = new CriteriaDef("WBS_ASCENDANT_NAME", "filter_WBSAscendantName", ValueType.STRING, Operator.stringOperators()){

            public boolean accept(GanttTask ganttTask, Operator operator, Object[] objectArray) {
                for (TGNode tGNode = ganttTask.getParent(); tGNode != null; tGNode = tGNode.getParent()) {
                    if (!this.accept(tGNode.getName(), operator, objectArray)) continue;
                    return true;
                }
                return false;
            }
        };
        WBS_ASCENDANT_SUPERVISOR = new CriteriaDef("WBS_ASCENDANT_SUPERVISOR", "filter_WBSAscendantSupervisor", ValueType.RESOURCE, new Operator[]{Operator.EQUAL, Operator.IN}){

            public boolean accept(GanttTask ganttTask, Operator operator, Object[] objectArray) {
                if (objectArray == null) {
                    return false;
                }
                TGNode tGNode = ganttTask.getParent();
                while (tGNode instanceof GanttWBS) {
                    Resource[] resourceArray = ((GanttWBS)tGNode).getResources();
                    for (Object object : objectArray) {
                        if (object == null) continue;
                        for (Resource resource : resourceArray) {
                            if (!TString.equals(((Resource)object).getDn(), resource.getDn())) continue;
                            return true;
                        }
                    }
                    tGNode = tGNode.getParent();
                }
                return false;
            }
        };
        DURATION = new CriteriaDef("DURATION", "Duration", ValueType.DURATION, Operator.durationOperators()){

            public boolean accept(GanttTask ganttTask, Operator operator, Object[] objectArray) {
                if (objectArray == null || objectArray.length != 1) {
                    return false;
                }
                TGDuration tGDuration = (TGDuration)objectArray[0];
                if (tGDuration.getValue() == 0.0 || tGDuration.getUnit().getCode() == 5) {
                    return this.accept(ganttTask.getDurationInHours(), operator, new Double(tGDuration.getValue()));
                }
                if (ganttTask.getDurationFormat() == tGDuration.getUnit().getCode()) {
                    return this.accept(ganttTask.getDurationDisplay(), operator, new Double(tGDuration.getValue()));
                }
                try {
                    ProjectModel projectModel = ((GanttProjectContext)ganttTask.getProjectContext()).getModel();
                    double d = ((AppProjectModel)projectModel).getDurationInHours(tGDuration.getValue(), tGDuration.getUnit());
                    return this.accept(ganttTask.getDurationInHours(), operator, new Double(d));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return false;
                }
            }
        };
        WORK = new CriteriaDef("WORK", "Work", ValueType.DURATION, Operator.durationOperators()){

            public boolean accept(GanttTask ganttTask, Operator operator, Object[] objectArray) {
                if (objectArray == null || objectArray.length != 1) {
                    return false;
                }
                TGDuration tGDuration = (TGDuration)objectArray[0];
                if (tGDuration.getValue() == 0.0 || tGDuration.getUnit().getCode() == 5) {
                    return this.accept(ganttTask.getWorkInHours(), operator, new Double(tGDuration.getValue()));
                }
                if (ganttTask.getWorkFormat() == tGDuration.getUnit().getCode()) {
                    return this.accept(ganttTask.getWorkDisplay(), operator, new Double(tGDuration.getValue()));
                }
                try {
                    ProjectModel projectModel = ((GanttProjectContext)ganttTask.getProjectContext()).getModel();
                    double d = ((AppProjectModel)projectModel).getDurationInHours(tGDuration.getValue(), tGDuration.getUnit());
                    return this.accept(ganttTask.getWorkInHours(), operator, new Double(d));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return false;
                }
            }
        };
        TOTAL_SLACK = new CriteriaDef("TOTAL_SLACK", "TotalSlack", ValueType.DURATION, Operator.durationOperators()){

            public boolean accept(GanttTask ganttTask, Operator operator, Object[] objectArray) {
                if (objectArray == null || objectArray.length != 1) {
                    return false;
                }
                TGDuration tGDuration = (TGDuration)objectArray[0];
                double d = ganttTask.getTotalSlack();
                if (d == -99.0) {
                    return false;
                }
                if (d == 0.0) {
                    System.out.println("Invalid slack for task " + ganttTask.getHierarchicalId() + ": " + ganttTask.getName());
                    return false;
                }
                if (d == -1.0) {
                    d = 0.0;
                }
                if (tGDuration.getValue() == 0.0 || tGDuration.getUnit().getCode() == 5) {
                    return this.accept(d, operator, new Double(tGDuration.getValue()));
                }
                try {
                    ProjectModel projectModel = ((GanttProjectContext)ganttTask.getProjectContext()).getModel();
                    double d2 = ((AppProjectModel)projectModel).getDurationInHours(tGDuration.getValue(), tGDuration.getUnit());
                    return this.accept(d, operator, new Double(d2));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return false;
                }
            }
        };
        TIMESHEET_HOURS = new CriteriaDef("WORKED_HOURS", "WorkedHours", ValueType.DOUBLE, Operator.doubleOperators()){

            public boolean accept(GanttTask ganttTask, Operator operator, Object[] objectArray) {
                double d = ganttTask.getTimeSheetHours();
                return this.accept(d, operator, objectArray);
            }
        };
        BOOKMARK_COUNT = new CriteriaDef("BOOKMARK_COUNT", "filter_bookmarkCount", ValueType.INT, Operator.intOperators()){

            public boolean accept(GanttTask ganttTask, Operator operator, Object[] objectArray) {
                int n = ganttTask.getSocialData().getBookmarkCount();
                return this.accept(n, operator, objectArray);
            }
        };
        COMMENT_COUNT = new CriteriaDef("COMMENT_COUNT", "filter_commentCount", ValueType.INT, Operator.intOperators()){

            public boolean accept(GanttTask ganttTask, Operator operator, Object[] objectArray) {
                int n = ganttTask.getSocialData().getCommentCount();
                return this.accept(n, operator, objectArray);
            }
        };
        LAST_COMMENT = new CriteriaDef("LAST_COMMENT", "filter_lastComment", ValueType.DATE, Operator.dateOperators()){

            public boolean accept(GanttTask ganttTask, Operator operator, Object[] objectArray) {
                Date date = ganttTask.getSocialData().getLastCommentDate();
                return this.accept(date, operator, objectArray);
            }
        };
    }
}

