/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.dialog;

import com.triloggroup.gantt.app.ui.WDButton;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemPickerDialog<T>
extends WDDialog
implements ActionListener {
    protected WDButton okButton;
    protected Object[] selection;
    protected JList list;

    public ItemPickerDialog(Window window, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
        this.setDragHeader(true);
        this.setMaximizable(false);
    }

    public void initWaiting() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(WDUtil.PE_BLUE);
        ImageIcon imageIcon = WDUtil.getIcon("loading.gif");
        JLabel jLabel = new JLabel(imageIcon);
        jPanel.add((Component)jLabel, "Center");
        WDButton wDButton = WDUtil.createCancelButton();
        wDButton.addActionListener(this);
        jPanel.add((Component)wDButton, "South");
        this.getContentPane().add(jPanel);
    }

    public void init(T[] TArray, boolean bl) {
        this.getContentPane().removeAll();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.list = new JList<T>(TArray);
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                this.setComponentOrientation(jList.getComponentOrientation());
                if (bl) {
                    this.setBackground(jList.getSelectionBackground());
                    this.setForeground(jList.getSelectionForeground());
                } else {
                    this.setBackground(jList.getBackground());
                    this.setForeground(jList.getForeground());
                }
                if (object == null) {
                    this.setText("");
                } else {
                    Object object2 = object;
                    this.setText(ItemPickerDialog.this.getLabel(object2));
                }
                this.setEnabled(jList.isEnabled());
                this.setFont(jList.getFont());
                this.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
                return this;
            }
        });
        this.list.setSelectionMode(bl ? 2 : 0);
        jPanel.add(this.list);
        JPanel jPanel2 = this.createButtonsPanel();
        this.getContentPane().add((Component)jPanel2, "South");
        this.getContentPane().add((Component)new JScrollPane(jPanel, 20, 31), "Center");
        this.validate();
    }

    protected JPanel createButtonsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        this.okButton = WDUtil.createOkButton();
        jPanel.add(this.okButton);
        this.okButton.addActionListener(this);
        WDButton wDButton = WDUtil.createCancelButton();
        jPanel.add(wDButton);
        wDButton.addActionListener(this);
        return jPanel;
    }

    protected String getLabel(T t) {
        return t.toString();
    }

    public Object[] getSelection() {
        return this.selection;
    }

    public T getSingleSelection() {
        return (T)(this.selection == null || this.selection.length != 1 ? null : this.selection[0]);
    }

    public void selectItems(T[] TArray) {
        if (TArray == null) {
            this.list.clearSelection();
            return;
        }
        int[] nArray = new int[TArray.length];
        ListModel listModel = this.list.getModel();
        block0: for (int i = 0; i < TArray.length; ++i) {
            nArray[i] = -1;
            for (int j = 0; j < listModel.getSize(); ++j) {
                if (TArray[i] != listModel.getElementAt(j)) continue;
                nArray[i] = j;
                continue block0;
            }
        }
        this.list.setSelectedIndices(nArray);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            Object[] objectArray = this.list.getSelectedValues();
            this.selection = new Object[objectArray.length];
            System.arraycopy(objectArray, 0, this.selection, 0, objectArray.length);
        }
        this.dispose();
    }
}

