/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.dialog;

import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.change.ChangeException;
import com.triloggroup.gantt.app.search.SearchEngine;
import com.triloggroup.gantt.app.search.SearchOptions;
import com.triloggroup.gantt.app.ui.WDButton;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.gantt.treetable.TGTreeTable;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.util.UString;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FindAndReplaceDialog
extends WDDialog
implements ActionListener {
    private static FindAndReplaceDialog instance;
    private AppGanttChart ganttCtrl;
    private JTextField tfFind;
    private JTextField tfReplace;
    private JCheckBox cbCaseSensitive;
    private JCheckBox cbWholeWord;
    private JCheckBox cbSelectionOnly;
    private JCheckBox cbIncludeSubprojects;
    private WDButton btFind;
    private WDButton btFindAll;
    private WDButton btClose;
    private WDButton btReplace;
    private WDButton btReplaceAll;

    public static void find(AppGanttChart appGanttChart) {
        FindAndReplaceDialog.showDialog(appGanttChart);
    }

    public static void findNext(AppGanttChart appGanttChart) {
        if (SearchEngine.get().getOptions() == null) {
            FindAndReplaceDialog.showDialog(appGanttChart);
        } else {
            SearchEngine.get().runSearch(appGanttChart);
        }
    }

    public static void replace(AppGanttChart appGanttChart) {
        FindAndReplaceDialog.showDialog(appGanttChart);
    }

    private static void showDialog(AppGanttChart appGanttChart) {
        if (instance == null) {
            TGTreeTable tGTreeTable = appGanttChart.getTreeTable();
            Window window = SwingUtilities.getWindowAncestor(tGTreeTable);
            GraphicsConfiguration graphicsConfiguration = WDUtil.getGraphicsConfiguration(tGTreeTable);
            instance = new FindAndReplaceDialog(window, graphicsConfiguration, appGanttChart);
            instance.pack();
            instance.setLocationRelativeTo(tGTreeTable);
            instance.setVisible(true);
        } else {
            instance.toFront();
        }
        FindAndReplaceDialog.instance.tfFind.requestFocusInWindow();
    }

    protected FindAndReplaceDialog(Window window, GraphicsConfiguration graphicsConfiguration, AppGanttChart appGanttChart) {
        super(window, graphicsConfiguration);
        this.ganttCtrl = appGanttChart;
        this.init();
        this.updateForm();
    }

    private void init() {
        this.setModal(false);
        this.setResizable(true);
        this.setDragHeader(true);
        this.btFind = WDUtil.createOkButton();
        this.btFind.setText(Workbench.getNLSString("find", new Object[0]));
        this.btClose = WDUtil.createCancelButton();
        this.btClose.setText(Workbench.getNLSString("close_button", new Object[0]));
        this.btFindAll = new WDButton(Workbench.getNLSString("find_all", new Object[0]));
        JLabel jLabel = new JLabel(Workbench.getNLSString("find", new Object[0]));
        this.tfFind = new JTextField();
        this.tfFind.getDocument().addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent documentEvent) {
                this.textUpdated(documentEvent);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.textUpdated(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            private void textUpdated(DocumentEvent documentEvent) {
                boolean bl = documentEvent.getDocument().getLength() != 0;
                FindAndReplaceDialog.this.btFind.setEnabled(bl);
                FindAndReplaceDialog.this.btFindAll.setEnabled(bl);
                if (FindAndReplaceDialog.this.btReplace != null) {
                    FindAndReplaceDialog.this.btReplace.setEnabled(bl);
                    FindAndReplaceDialog.this.btReplaceAll.setEnabled(bl);
                }
            }
        });
        this.btFind.setEnabled(false);
        this.btFindAll.setEnabled(false);
        JPanel jPanel = WDDialog.createButtonPanel(this.btFind, this.btFindAll, this.btClose);
        JLabel jLabel2 = null;
        if (this.ganttCtrl.isEditable()) {
            this.btReplace = new WDButton(Workbench.getNLSString("replace", new Object[0]));
            this.btReplaceAll = new WDButton(Workbench.getNLSString("replace_all", new Object[0]));
            this.btReplace.setEnabled(false);
            this.btReplaceAll.setEnabled(false);
            this.btReplace.addActionListener(this);
            this.btReplaceAll.addActionListener(this);
            jLabel2 = new JLabel(Workbench.getNLSString("replace_with", new Object[0]));
            this.tfReplace = new JTextField();
        }
        JPanel jPanel2 = WDDialog.createButtonPanel(this.btReplace, this.btReplaceAll);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 18, 2, new Insets(15, 5, 5, 5), 0, 0);
        jPanel3.add((Component)jPanel, gridBagConstraints);
        jPanel3.add((Component)jPanel2, gridBagConstraints);
        jPanel3.add((Component)jLabel, gridBagConstraints2);
        jPanel3.add((Component)this.tfFind, gridBagConstraints3);
        if (this.tfReplace != null) {
            jPanel3.add((Component)jLabel2, gridBagConstraints2);
            jPanel3.add((Component)this.tfReplace, gridBagConstraints3);
        }
        JPanel jPanel4 = new JPanel(new GridLayout(0, 1));
        jPanel4.setBorder(BorderFactory.createTitledBorder((String)null));
        this.cbCaseSensitive = new JCheckBox(Workbench.getNLSString("case_sensitive", new Object[0]));
        this.cbWholeWord = new JCheckBox(Workbench.getNLSString("whole_word", new Object[0]));
        this.cbSelectionOnly = new JCheckBox(Workbench.getNLSString("selection_only", new Object[0]));
        this.cbIncludeSubprojects = new JCheckBox(Workbench.getNLSString("include_subprojects", new Object[0]));
        jPanel4.add(this.cbCaseSensitive);
        jPanel4.add(this.cbWholeWord);
        jPanel3.add((Component)jPanel4, gridBagConstraints4);
        this.getContentPane().add(jPanel3);
        this.btFind.addActionListener(this);
        this.btFindAll.addActionListener(this);
        this.btClose.addActionListener(this);
    }

    public void close() {
        super.close();
        instance = null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        try {
            if (object == this.btFind) {
                this.find();
            } else if (object == this.btFindAll) {
                this.findAll();
            } else if (this.btReplace != null && object == this.btReplace) {
                this.replace();
            } else if (this.btReplaceAll != null && object == this.btReplaceAll) {
                this.replaceAll();
            } else {
                this.close();
            }
        }
        catch (Exception exception) {
            WDDialog.showErrorMsgDialog(this, exception);
        }
    }

    private void find() {
        this.updateFindOptions();
        SearchEngine.get().runSearch(this.ganttCtrl);
    }

    private void findAll() {
        this.updateFindOptions();
        SearchEngine.get().runSearchAll(this.ganttCtrl);
    }

    private void replace() throws ChangeException {
        this.updateFindOptions();
        SearchEngine.get().runReplace(this.ganttCtrl);
    }

    private void replaceAll() throws ChangeException {
        this.updateFindOptions();
        SearchEngine.get().runReplaceAll(this.ganttCtrl);
    }

    private void updateForm() {
        SearchOptions searchOptions = SearchEngine.get().getOptions();
        if (searchOptions != null) {
            this.tfFind.setText(searchOptions.text);
            this.cbCaseSensitive.setSelected(searchOptions.caseSensitive);
            this.cbWholeWord.setSelected(searchOptions.wholeWord);
            this.cbSelectionOnly.setSelected(searchOptions.selectionOnly);
            this.cbIncludeSubprojects.setSelected(searchOptions.includeSubprojects);
            if (this.tfReplace != null && searchOptions.replace != null) {
                this.tfReplace.setText(searchOptions.replace);
            }
        }
    }

    private void updateFindOptions() {
        String string = this.tfFind.getText();
        if (UString.isEmpty(string)) {
            SearchEngine.get().setOptions(null);
            this.tfFind.requestFocus();
            return;
        }
        SearchOptions searchOptions = new SearchOptions(string);
        searchOptions.caseSensitive = this.cbCaseSensitive.isSelected();
        searchOptions.wholeWord = this.cbWholeWord.isSelected();
        searchOptions.selectionOnly = this.cbSelectionOnly.isSelected();
        searchOptions.includeSubprojects = this.cbIncludeSubprojects.isSelected();
        searchOptions.replace = this.tfReplace == null ? null : this.tfReplace.getText();
        SearchEngine.get().setOptions(searchOptions);
    }
}

