/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.dialog;

import com.triloggroup.gantt.CriticalPathRuntimeConf;
import com.triloggroup.gantt.TimeUnit;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.AppGlobalContext;
import com.triloggroup.gantt.app.ui.WDButton;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.ui.IntTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CriticalPathSettingsDialog
extends WDDialog
implements ActionListener {
    private AppGanttChart ganttCtrl;
    private WDButton okButton;
    private JCheckBox cbNearCritical;
    private JLabel lbMaxSlack;
    private IntTextField tfMaxSlack;
    private JComboBox cbMaxSlackUnit;
    private JCheckBox cbShowLateDates;
    private JComboBox cbSlackDisplayUnit;

    public static void showDialog(AppGanttChart appGanttChart, Component component) {
        Point point = component.getLocationOnScreen();
        point.y += component.getHeight() / 2;
        point.x += component.getWidth() / 2;
        GraphicsConfiguration graphicsConfiguration = WDUtil.getGraphicsConfiguration(point);
        Window window = SwingUtilities.getWindowAncestor(component);
        CriticalPathSettingsDialog criticalPathSettingsDialog = new CriticalPathSettingsDialog(window, appGanttChart, graphicsConfiguration);
        criticalPathSettingsDialog.setLocation(point);
        criticalPathSettingsDialog.setModal(true);
        criticalPathSettingsDialog.setVisible(true);
    }

    private CriticalPathSettingsDialog(Window window, AppGanttChart appGanttChart, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
        this.ganttCtrl = appGanttChart;
        this.initUI();
    }

    private void initUI() {
        TimeUnit timeUnit2;
        AppGlobalContext appGlobalContext = this.ganttCtrl.getModel().getGlobalContext();
        GridBagLayout gridBagLayout = new GridBagLayout();
        Insets insets = new Insets(2, 2, 2, 2);
        Insets insets2 = new Insets(12, 2, 2, 2);
        Insets insets3 = new Insets(2, 25, 2, 2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 4, 1, 1.0, 1.0, 17, 0, insets2, 0, 0);
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.cbNearCritical = new JCheckBox(AppGanttChart.NLS_BUNDLE.getString("criticalPath_nearCritical"));
        this.cbNearCritical.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CriticalPathSettingsDialog.this.setFieldsState();
            }
        });
        jPanel.add((Component)this.cbNearCritical, gridBagConstraints);
        JLabel jLabel = new JLabel(AppGanttChart.NLS_BUNDLE.getString("criticalPath_nearCritical_help"));
        ImageIcon imageIcon = WDUtil.getIcon("UserAssistance.gif");
        if (imageIcon != null) {
            jLabel.setIcon(imageIcon);
            jLabel.setVerticalTextPosition(1);
        }
        jPanel.add((Component)jLabel, new GridBagConstraints(0, -1, 4, 1, 1.0, 1.0, 17, 2, insets3, 0, 0));
        this.lbMaxSlack = new JLabel(AppGanttChart.NLS_BUNDLE.getString("criticalPath_nearCriticalSlack"));
        jPanel.add((Component)this.lbMaxSlack, new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 17, 2, insets3, 0, 0));
        this.tfMaxSlack = new IntTextField(this.ganttCtrl.getDateLocale());
        this.tfMaxSlack.setColumns(10);
        this.tfMaxSlack.setHorizontalAlignment(4);
        jPanel.add((Component)this.tfMaxSlack, new GridBagConstraints(1, -1, 1, 1, 0.0, 1.0, 17, 2, insets, 0, 0));
        this.cbMaxSlackUnit = new JComboBox();
        TimeUnit[] timeUnitArray = appGlobalContext.getTimeUnits().getAllTimeUnits();
        for (int i = 0; i < timeUnitArray.length; ++i) {
            this.cbMaxSlackUnit.addItem(timeUnitArray[i]);
        }
        jPanel.add((Component)this.cbMaxSlackUnit, new GridBagConstraints(2, -1, 1, 1, 0.0, 1.0, 17, 2, insets, 0, 0));
        this.cbShowLateDates = new JCheckBox(AppGanttChart.NLS_BUNDLE.getString("criticalPath_lateDates"));
        jPanel.add((Component)this.cbShowLateDates, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new BorderLayout(4, 4));
        jPanel2.add((Component)new JLabel(AppGanttChart.NLS_BUNDLE.getString("criticalPath_slackDisplayUnit")), "West");
        this.cbSlackDisplayUnit = new JComboBox();
        for (TimeUnit timeUnit2 : timeUnitArray) {
            this.cbSlackDisplayUnit.addItem(timeUnit2);
        }
        jPanel2.add((Component)this.cbSlackDisplayUnit, "Center");
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        this.okButton = WDUtil.createOkButton();
        jPanel3.add(this.okButton);
        WDButton wDButton = WDUtil.createCancelButton();
        jPanel3.add(wDButton);
        this.okButton.addActionListener(this);
        wDButton.addActionListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel3, "North");
        this.getContentPane().add((Component)jPanel, "Center");
        this.setDragHeader(true);
        this.setMaximizable(false);
        CriticalPathRuntimeConf criticalPathRuntimeConf = appGlobalContext.getCriticalPathConf();
        this.cbShowLateDates.setSelected(criticalPathRuntimeConf.getDisplayLateDates());
        this.cbNearCritical.setSelected(criticalPathRuntimeConf.getDisplayNearCritical());
        this.tfMaxSlack.setValue(criticalPathRuntimeConf.getNearCriticalSlackValue());
        timeUnit2 = appGlobalContext.getTimeUnits().fromCode(criticalPathRuntimeConf.getNearCriticalSlackUnitCode());
        if (timeUnit2 != null) {
            this.cbMaxSlackUnit.setSelectedItem(timeUnit2);
        }
        timeUnit2 = appGlobalContext.getTimeUnits().fromCode(criticalPathRuntimeConf.getSlackDisplayUnitCode());
        this.cbSlackDisplayUnit.setSelectedItem(timeUnit2);
        this.setFieldsState();
    }

    private void setFieldsState() {
        boolean bl = this.cbNearCritical.isSelected();
        this.lbMaxSlack.setEnabled(bl);
        this.tfMaxSlack.setEnabled(bl);
        this.cbMaxSlackUnit.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            Object object;
            AppGlobalContext appGlobalContext = this.ganttCtrl.getModel().getGlobalContext();
            CriticalPathRuntimeConf criticalPathRuntimeConf = appGlobalContext.getCriticalPathConf();
            criticalPathRuntimeConf.setDisplayLateDates(this.cbShowLateDates.isSelected());
            criticalPathRuntimeConf.setDisplayNearCritical(this.cbNearCritical.isSelected());
            if (this.cbNearCritical.isSelected()) {
                double d;
                object = this.tfMaxSlack.getValue();
                if (object == null || ((Number)object).intValue() <= 0) {
                    WDDialog.showMsgDialog(this, AppGanttChart.NLS_BUNDLE.getString("criticalPath_nearCriticalError"));
                    this.tfMaxSlack.requestFocusInWindow();
                    return;
                }
                TimeUnit timeUnit = (TimeUnit)this.cbMaxSlackUnit.getSelectedItem();
                try {
                    d = this.ganttCtrl.getModel().getMainProjectModel().getDurationInHours(((Number)object).intValue(), timeUnit);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    d = 0.0;
                }
                criticalPathRuntimeConf.setNearCriticalSlackHours(d);
                criticalPathRuntimeConf.setNearCriticalSlackValue(((Number)object).intValue());
                criticalPathRuntimeConf.setNearCriticalSlackUnitCode(timeUnit.getCode());
            } else {
                criticalPathRuntimeConf.setNearCriticalSlackHours(0.0);
            }
            object = (TimeUnit)this.cbSlackDisplayUnit.getSelectedItem();
            criticalPathRuntimeConf.setSlackDisplayUnitCode(((TimeUnit)object).getCode());
            this.ganttCtrl.getUserPreferences().setCriticalPathConf(criticalPathRuntimeConf);
        }
        this.dispose();
    }
}

