/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.change;

import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.change.FieldModification;
import com.triloggroup.project.components.IdentifiableObject;
import com.triloggroup.project.components.ObjectType;
import com.triloggroup.util.UString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Change
implements Cloneable {
    public static final int OPERATION_UPDATE = 0;
    public static final int OPERATION_CREATE = 1;
    public static final int OPERATION_DELETE = 2;
    public static final int OPERATION_CLONE = 3;
    public static final int OPERATION_REORDER_CHILDREN = 4;
    public static final int OPERATION_TRANSFORM_TASK_INTO_WBS = 6;
    public static final int OPERATION_TRANSFORM_WBS_INTO_TASK = 7;
    protected final IdentifiableObject target;
    protected final int operation;
    protected transient boolean isLinkedToPrevious = false;
    protected ArrayList<FieldModification> fieldModifications = null;
    protected List<Change> preSubChanges = null;
    protected List<Change> postSubChanges = null;
    protected String text;

    protected Change(int n, IdentifiableObject identifiableObject) {
        if (identifiableObject == null) {
            throw new NullPointerException();
        }
        this.operation = n;
        this.target = identifiableObject;
        this.fieldModifications = new ArrayList();
    }

    public int getOperation() {
        return this.operation;
    }

    public IdentifiableObject getTarget() {
        return this.target;
    }

    public ObjectType getTargetType() {
        return this.target.getType();
    }

    public boolean isLinkedToPreviousChange() {
        return this.isLinkedToPrevious;
    }

    public void setLinkedToPreviousChange(boolean bl) {
        this.isLinkedToPrevious = bl;
    }

    public void copyLinkedToPreviousAndTextFromOtherChange(Change change) {
        this.isLinkedToPrevious = change.isLinkedToPrevious;
        this.text = change.text;
    }

    public void addModification(String string, Object object, Object object2) {
        if (object instanceof Date) {
            object = ((Date)object).clone();
        }
        if (object2 instanceof Date) {
            object2 = ((Date)object2).clone();
        }
        this.addModification(new FieldModification(string, object, object2));
    }

    public void addBooleanModification(String string, boolean bl, boolean bl2) {
        this.addModification(new FieldModification(string, new Boolean(bl), new Boolean(bl2)));
    }

    public void addIntModification(String string, int n, int n2) {
        this.addModification(new FieldModification(string, new Integer(n), new Integer(n2)));
    }

    public void addDoubleModification(String string, double d, double d2) {
        this.addModification(new FieldModification(string, new Double(d), new Double(d2)));
    }

    private void addModification(FieldModification fieldModification) {
        for (int i = 0; i < this.fieldModifications.size(); ++i) {
            FieldModification fieldModification2 = this.fieldModifications.get(i);
            if (!fieldModification2.field.equals(fieldModification.field)) continue;
            this.fieldModifications.remove(i);
            FieldModification fieldModification3 = new FieldModification(fieldModification.field, fieldModification2.oldValue, fieldModification.newValue);
            this.fieldModifications.add(fieldModification3);
            return;
        }
        this.fieldModifications.add(fieldModification);
    }

    public List<FieldModification> getFieldModifications() {
        return this.fieldModifications;
    }

    public boolean hasFieldModification(String string) {
        if (this.fieldModifications != null) {
            for (int i = 0; i < this.fieldModifications.size(); ++i) {
                FieldModification fieldModification = this.fieldModifications.get(i);
                if (!UString.equals(fieldModification.field, string)) continue;
                return true;
            }
        }
        return false;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        String string = null;
        switch (this.operation) {
            case 1: {
                string = "create";
                break;
            }
            case 2: {
                string = "delete";
                break;
            }
            case 0: {
                string = "modify";
            }
        }
        if (string != null) {
            return AppGanttChart.NLS_BUNDLE.getString(string, this.target);
        }
        return ((Object)this.target).toString();
    }

    public String getUndoText() {
        return AppGanttChart.NLS_BUNDLE.getString("undo") + ' ' + this.getText();
    }

    public String getRedoText() {
        return AppGanttChart.NLS_BUNDLE.getString("redo") + ' ' + this.getText();
    }

    public Change deepClone() {
        try {
            Change change = (Change)super.clone();
            change.fieldModifications = (ArrayList)this.fieldModifications.clone();
            change.setLinkedToPreviousChange(false);
            return change;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public boolean hasSubChange() {
        return this.preSubChanges != null || this.postSubChanges != null;
    }

    public void addPreSubChange(Change change) {
        if (this.preSubChanges == null) {
            this.preSubChanges = new ArrayList<Change>();
        }
        this.preSubChanges.add(change);
    }

    public List<Change> getPreSubChanges() {
        if (this.preSubChanges != null) {
            return this.preSubChanges;
        }
        return Collections.emptyList();
    }

    public void addPostSubChange(Change change) {
        if (this.postSubChanges == null) {
            this.postSubChanges = new ArrayList<Change>();
        }
        this.postSubChanges.add(change);
    }

    public List<Change> getPostSubChanges() {
        if (this.postSubChanges != null) {
            return this.postSubChanges;
        }
        return Collections.emptyList();
    }

    public static Change newCreateChange(IdentifiableObject identifiableObject) {
        return new Change(1, identifiableObject);
    }

    public static Change newDeleteChange(IdentifiableObject identifiableObject) {
        return new Change(2, identifiableObject);
    }

    public static Change newUpdateChange(IdentifiableObject identifiableObject) {
        return new Change(0, identifiableObject);
    }

    public static boolean isNullOperation(Change change) {
        if (change == null) {
            return true;
        }
        return change.operation == 0 && change.fieldModifications.isEmpty();
    }
}

