/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.applet;

import com.triloggroup.gantt.Debug;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.AppGanttChartModel;
import com.triloggroup.gantt.app.GanttWorkbenchPage;
import com.triloggroup.gantt.app.applet.GanttAppletBase;
import com.triloggroup.gantt.app.ui.AsyncActionRunner;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.ui.ErrorDialog;
import com.triloggroup.util.NLSBundle;
import com.triloggroup.util.UString;
import java.awt.Color;
import java.awt.FlowLayout;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class GanttApplet
extends GanttAppletBase {
    protected boolean initFailed = false;
    protected boolean isStopped = false;
    private Thread startThread = null;

    protected void createGUI() {
        this.getContentPane().removeAll();
        GanttWorkbenchPage ganttWorkbenchPage = this.createGanttWorkbenchPage(GanttWorkbenchPage.Mode.APPLET);
        this.getContentPane().add(ganttWorkbenchPage.getComponent());
        this.getContentPane().validate();
    }

    protected void createErrorGUI() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GanttApplet.this.createErrorGUI();
                }
            });
            return;
        }
        NLSBundle nLSBundle = Workbench.get().getNLSBundle();
        String string = nLSBundle != null ? nLSBundle.getString("gantt_error") : "<html>An unexpected error occured.<br>Please try again later or contact ProjExec support.</html>";
        JLabel jLabel = new JLabel(string);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.setBackground(Color.WHITE);
        jPanel.add(jLabel);
        this.getContentPane().removeAll();
        this.getContentPane().add(jPanel);
        this.getContentPane().validate();
    }

    protected abstract AppGanttChart createAppGanttChart() throws Exception;

    protected abstract AppGanttChartModel createAppGanttChartModel(String var1, String var2) throws Exception;

    public void init() {
        this.debug("init");
        try {
            Debug.log("GanttChart applet - triloggroup");
            this.logBuildInfo();
            super.init();
            Debug.log(" intialized");
        }
        catch (Throwable throwable) {
            System.err.println("Init didn't successfully complete");
            throwable.printStackTrace();
            this.createErrorGUI();
            ErrorDialog.showError(this, throwable);
            this.initFailed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logBuildInfo() {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/META-INF/build");
            try {
                int n;
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
                StringBuilder stringBuilder = new StringBuilder();
                char[] cArray = new char[1024];
                while ((n = inputStreamReader.read(cArray)) != -1) {
                    stringBuilder.append(cArray, 0, n);
                }
                Debug.log(stringBuilder.toString());
            }
            finally {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            Debug.log("build info not available");
        }
    }

    protected void asyncStart1() {
        try {
            String string = this.getParameter("siteId");
            String string2 = this.getParameter("projectId");
            if (this.isStopped) {
                return;
            }
            AppGanttChart appGanttChart = this.createAppGanttChart();
            AppGanttChartModel appGanttChartModel = this.createAppGanttChartModel(string2, string);
            appGanttChartModel.getGlobalContext().setClientTimeZone(clientTZ);
            this.asyncStart2(appGanttChart, appGanttChartModel);
            Debug.log(" data loaded");
            this.startThread = null;
        }
        catch (ThreadDeath threadDeath) {
            System.err.println("Start thread stopped");
            this.createErrorGUI();
            throw threadDeath;
        }
        catch (Throwable throwable) {
            System.err.println("Start didn't successfully complete");
            throwable.printStackTrace();
            this.createErrorGUI();
        }
    }

    protected void asyncStart2(final AppGanttChart appGanttChart, final AppGanttChartModel appGanttChartModel) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (GanttApplet.this.isStopped) {
                    return;
                }
                try {
                    appGanttChart.setModel(appGanttChartModel);
                    GanttApplet.this.setGanttChart(appGanttChart);
                    GanttApplet.this.createGUI();
                    String string = GanttApplet.this.getParameter("touchSessionURL");
                    URL uRL = null;
                    int n = -1;
                    if (!UString.isEmpty(string)) {
                        try {
                            uRL = new URL(string);
                            String string2 = GanttApplet.this.getParameter("touchSessionInterval");
                            n = Integer.parseInt(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            numberFormatException.printStackTrace();
                            n = 10;
                        }
                        catch (MalformedURLException malformedURLException) {
                            malformedURLException.printStackTrace();
                        }
                    }
                    appGanttChart.initTouchSessionThread(n, uRL);
                    appGanttChart.chartMadeVisible();
                    Debug.log(" started");
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    GanttApplet.this.createErrorGUI();
                    ErrorDialog.showError(GanttApplet.this, throwable);
                }
            }
        });
    }

    public void start() {
        this.debug("start");
        if (this.initFailed) {
            return;
        }
        this.startThread = new Thread(){

            public void run() {
                GanttApplet.this.asyncStart1();
            }
        };
        this.startThread.start();
    }

    protected void internalBeforeUnload() {
        try {
            Runnable runnable = new Runnable(){

                public void run() {
                    boolean bl;
                    AppGanttChart appGanttChart = GanttApplet.this.getGanttChart();
                    if (appGanttChart.getModel().getChangeManager().canUndo() && (bl = WDDialog.showYesNoDialog(GanttApplet.this, AppGanttChart.NLS_BUNDLE.getString("saveBeforeQuitQuestion")))) {
                        AsyncActionRunner asyncActionRunner = appGanttChart.saveChanges();
                        asyncActionRunner.waitUntilDone();
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void stop() {
        this.debug("stop");
        this.isStopped = true;
        if (this.startThread != null) {
            try {
                this.startThread.interrupt();
            }
            catch (Exception exception) {}
        } else {
            AppGanttChart appGanttChart = this.getGanttChart();
            if (appGanttChart != null) {
                appGanttChart.unload();
            }
        }
    }

    private void debug(String string) {
        if (Debug.DEBUG) {
            Debug.log(string + " (" + System.identityHashCode(this) + ", thread: " + Thread.currentThread().getName() + ')');
        }
    }
}

