/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app;

import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.ResourcePickerDialog;
import com.triloggroup.gantt.app.TablePanel;
import javax.swing.table.AbstractTableModel;

public class WBSSupervisorsPanel
extends TablePanel {
    public WBSSupervisorsPanel(AppGanttChart appGanttChart, GanttWBS ganttWBS) {
        super(appGanttChart, ganttWBS);
    }

    protected void init() {
        super.init();
        this.addButton.setToolTipText(this.nlsBundle.getString("add_resource"));
        this.deleteButton.setToolTipText(this.nlsBundle.getString("remove_resource"));
    }

    protected void initTable() {
        super.initTable();
        ResourcesTableModel resourcesTableModel = new ResourcesTableModel();
        this.table.setModel(resourcesTableModel);
        this.table.validate();
    }

    protected void doAdd() {
        ResourcesTableModel resourcesTableModel = (ResourcesTableModel)this.table.getModel();
        ResourcePickerDialog resourcePickerDialog = ResourcePickerDialog.create(this.table);
        Resource[] resourceArray = ((GanttWBS)this.node).getResources();
        resourcePickerDialog.setExcludeDisabled(true);
        resourcePickerDialog.init(this.ganttChart.getModel().getProjectModel(this.node.getProjectId()), resourceArray, true);
        resourcePickerDialog.setVisible(-1, -1, -1, 600, this.table);
        Resource[] resourceArray2 = resourcePickerDialog.getSelection();
        if (resourceArray2 != null && resourceArray2.length > 0) {
            int n;
            for (n = 0; n < resourceArray2.length; ++n) {
                resourcesTableModel.addRow(resourceArray2[n]);
            }
            n = resourcesTableModel.getRowCount();
            this.selectRow(n - 1);
            this.deleteButton.setEnabled(true);
        }
    }

    protected void doDelete() {
        int n;
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        ResourcesTableModel resourcesTableModel = (ResourcesTableModel)this.table.getModel();
        for (n = nArray.length - 1; n > -1; --n) {
            resourcesTableModel.removeRow(nArray[n]);
        }
        n = resourcesTableModel.getRowCount();
        if (n == 0) {
            this.deleteButton.setEnabled(false);
        } else if (nArray.length == 1) {
            int n2 = nArray[0];
            if (n > n2) {
                this.selectRow(n2);
            } else {
                this.selectRow(n2 - 1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResourcesTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{AppGanttChart.NLS_BUNDLE.getString("Name")};

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return ((GanttWBS)WBSSupervisorsPanel.this.node).getResources().length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return ((GanttWBS)WBSSupervisorsPanel.this.node).getResources()[n];
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return object.getClass();
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Resource[] resourceArray = ((GanttWBS)WBSSupervisorsPanel.this.node).getResources();
            if (n2 == 0 && object instanceof Resource) {
                resourceArray[n] = (Resource)object;
            }
            this.fireTableCellUpdated(n, n2);
        }

        public void removeRow(int n) {
            if (((GanttWBS)WBSSupervisorsPanel.this.node).getResources().length > n) {
                if (((GanttWBS)WBSSupervisorsPanel.this.node).getResources().length == 1) {
                    ((GanttWBS)WBSSupervisorsPanel.this.node).setResources(new Resource[0]);
                } else {
                    Resource[] resourceArray = ((GanttWBS)WBSSupervisorsPanel.this.node).getResources();
                    Resource[] resourceArray2 = new Resource[resourceArray.length - 1];
                    if (n == 0) {
                        System.arraycopy(resourceArray, 1, resourceArray2, 0, resourceArray2.length);
                    } else if (n == resourceArray.length - 1) {
                        System.arraycopy(resourceArray, 0, resourceArray2, 0, resourceArray2.length);
                    } else {
                        System.arraycopy(resourceArray, 0, resourceArray2, 0, n);
                        System.arraycopy(resourceArray, n + 1, resourceArray2, n, resourceArray.length - (n + 1));
                    }
                    ((GanttWBS)WBSSupervisorsPanel.this.node).setResources(resourceArray2);
                }
                this.fireTableRowsDeleted(n, n);
            }
        }

        public void addRow(Resource resource) {
            Resource[] resourceArray = ((GanttWBS)WBSSupervisorsPanel.this.node).getResources();
            Resource[] resourceArray2 = new Resource[resourceArray.length + 1];
            System.arraycopy(resourceArray, 0, resourceArray2, 0, resourceArray.length);
            resourceArray2[resourceArray.length] = resource;
            ((GanttWBS)WBSSupervisorsPanel.this.node).setResources(resourceArray2);
            this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
        }
    }
}

