/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app;

import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.ITimeUnits;
import com.triloggroup.gantt.PredecessorUtil;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.TablePanel;
import com.triloggroup.gantt.app.dialog.TaskPickerDialog;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.gantt.table.TimeUnitCellEditor;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.project.components.ui.table.ITGTableModel;
import com.triloggroup.project.components.ui.table.IntegerCellEditor;
import com.triloggroup.project.components.ui.table.TGTableHeaderRenderer;
import com.triloggroup.project.schedule.Predecessor;
import com.triloggroup.ui.table.ComboCellEditor;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class TaskPredecessorsPanel
extends TablePanel {
    private ITimeUnits timeUnits;

    public TaskPredecessorsPanel(AppGanttChart appGanttChart, GanttTask ganttTask) {
        super(appGanttChart, ganttTask);
        this.timeUnits = ganttTask.getGlobalContext().getTimeUnits();
    }

    protected void init() {
        super.init();
        this.addButton.setToolTipText(this.nlsBundle.getString("add_predecessor"));
        this.deleteButton.setToolTipText(this.nlsBundle.getString("remove_predecessor"));
    }

    protected void initTable() {
        super.initTable();
        PredecessorsTableModel predecessorsTableModel = new PredecessorsTableModel();
        this.table.setModel(predecessorsTableModel);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        String[] stringArray = PredecessorUtil.getPredecessorTypesAsNlsString(this.nlsBundle);
        Object[] objectArray = Predecessor.getPredecessorTypesAsInteger();
        ComboCellEditor comboCellEditor = new ComboCellEditor(objectArray, stringArray);
        tableColumnModel.getColumn(1).setCellEditor(comboCellEditor);
        IntegerCellEditor integerCellEditor = new IntegerCellEditor(Workbench.get().getFormatLocale(), false);
        tableColumnModel.getColumn(2).setCellEditor(integerCellEditor);
        TimeUnitCellEditor timeUnitCellEditor = new TimeUnitCellEditor(this.node.getGlobalContext().getTimeUnits(), true);
        tableColumnModel.getColumn(3).setCellEditor(timeUnitCellEditor);
        tableColumnModel.getColumn(0).setMinWidth(100);
        tableColumnModel.getColumn(1).setMinWidth(100);
        tableColumnModel.getColumn(2).setMinWidth(50);
        tableColumnModel.getColumn(3).setMinWidth(125);
        ImageIcon imageIcon = WDUtil.getIcon("help.gif");
        if (imageIcon != null) {
            JTableHeader jTableHeader = this.table.getTableHeader();
            jTableHeader.setDefaultRenderer(new HeaderRenderer(imageIcon));
            jTableHeader.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    int n = TaskPredecessorsPanel.this.table.getTableHeader().columnAtPoint(mouseEvent.getPoint());
                    if (n == 2) {
                        WDDialog.showHelpMsgDialog(TaskPredecessorsPanel.this.table, TaskPredecessorsPanel.this.nlsBundle.getString("help_lag"));
                    } else if (n == 3) {
                        WDDialog.showHelpMsgDialog(TaskPredecessorsPanel.this.table, TaskPredecessorsPanel.this.nlsBundle.getString("help_lagUnit"));
                    }
                }
            });
        }
        this.table.validate();
    }

    protected void doAdd() {
        PredecessorsTableModel predecessorsTableModel = (PredecessorsTableModel)this.table.getModel();
        TaskPickerDialog taskPickerDialog = TaskPickerDialog.createTaskPicker(this.table);
        taskPickerDialog.init(this.ganttChart.getModel().getAvailablePredecessors((GanttTask)this.node), true);
        taskPickerDialog.setVisible(-1, -1, -1, 600, this.table);
        GanttNode[] ganttNodeArray = taskPickerDialog.getSelection();
        if (ganttNodeArray != null && ganttNodeArray.length > 0) {
            int n;
            for (n = 0; n < ganttNodeArray.length; ++n) {
                Predecessor predecessor = new Predecessor(ganttNodeArray[n].getUid(), 1);
                predecessorsTableModel.addRow(predecessor);
            }
            n = predecessorsTableModel.getRowCount();
            this.selectRow(n - 1);
            this.deleteButton.setEnabled(true);
        }
    }

    protected void doDelete() {
        int n;
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        PredecessorsTableModel predecessorsTableModel = (PredecessorsTableModel)this.table.getModel();
        for (n = nArray.length - 1; n > -1; --n) {
            predecessorsTableModel.removeRow(nArray[n]);
        }
        n = predecessorsTableModel.getRowCount();
        if (n == 0) {
            this.deleteButton.setEnabled(false);
        } else if (nArray.length == 1) {
            int n2 = nArray[0];
            if (n > n2) {
                this.selectRow(n2);
            } else {
                this.selectRow(n2 - 1);
            }
        }
    }

    public void update() {
        PredecessorsTableModel predecessorsTableModel = (PredecessorsTableModel)this.table.getModel();
        predecessorsTableModel.fireTableDataChanged();
        this.deleteButton.setEnabled(this.isEnabled() && predecessorsTableModel.getRowCount() > 0);
    }

    private static class HeaderRenderer
    extends TGTableHeaderRenderer {
        Icon helpIcon;

        public HeaderRenderer(Icon icon) {
            super(true);
            this.helpIcon = icon;
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(10);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n2 == 2 || n2 == 3) {
                this.setIcon(this.helpIcon);
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PredecessorsTableModel
    extends AbstractTableModel
    implements ITGTableModel {
        private String[] columnNames = new String[]{AppGanttChart.NLS_BUNDLE.getString("task"), AppGanttChart.NLS_BUNDLE.getString("linkType"), AppGanttChart.NLS_BUNDLE.getString("lag"), AppGanttChart.NLS_BUNDLE.getString("lagFormat")};

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return ((GanttTask)TaskPredecessorsPanel.this.node).getPredecessorsCount();
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Predecessor predecessor = ((GanttTask)TaskPredecessorsPanel.this.node).getPredecessor(n);
            switch (n2) {
                case 0: {
                    GanttNode ganttNode = TaskPredecessorsPanel.this.ganttChart.getModel().getProjectModel(((GanttTask)TaskPredecessorsPanel.this.node).getProjectId()).getNodeByUid(predecessor.getId());
                    return ganttNode.getName();
                }
                case 1: {
                    return PredecessorUtil.predecessorTypeAsNlsString(predecessor.getType(), TaskPredecessorsPanel.this.nlsBundle);
                }
                case 2: {
                    return new Integer(predecessor.getLag());
                }
                case 3: {
                    return TaskPredecessorsPanel.this.timeUnits.fromCode(predecessor.getLagFormat()).getLabel();
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return object.getClass();
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (TaskPredecessorsPanel.this.isEnabled()) {
                return n2 != 0;
            }
            return false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (!(object instanceof Integer)) {
                return;
            }
            Predecessor predecessor = ((GanttTask)TaskPredecessorsPanel.this.node).getPredecessor(n);
            Predecessor predecessor2 = null;
            switch (n2) {
                case 0: {
                    break;
                }
                case 1: {
                    predecessor2 = new Predecessor(predecessor.getId(), (Integer)object, predecessor.getLag(), predecessor.getLagFormat());
                    break;
                }
                case 2: {
                    predecessor2 = new Predecessor(predecessor.getId(), predecessor.getType(), (Integer)object, predecessor.getLagFormat());
                    break;
                }
                case 3: {
                    predecessor2 = new Predecessor(predecessor.getId(), predecessor.getType(), predecessor.getLag(), (Integer)object);
                }
            }
            if (predecessor2 != null) {
                ((GanttTask)TaskPredecessorsPanel.this.node).removePredecessor(n);
                ((GanttTask)TaskPredecessorsPanel.this.node).addPredecessorAt(n, predecessor2);
            }
            this.fireTableCellUpdated(n, n2);
        }

        public void removeRow(int n) {
            if (((GanttTask)TaskPredecessorsPanel.this.node).getPredecessorsCount() > n) {
                ((GanttTask)TaskPredecessorsPanel.this.node).removePredecessor(n);
                this.fireTableRowsDeleted(n, n);
            }
        }

        public void addRow(Predecessor predecessor) {
            ((GanttTask)TaskPredecessorsPanel.this.node).addPredecessor(predecessor);
            this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
        }

        @Override
        public boolean isEditable() {
            return TaskPredecessorsPanel.this.ganttChart.isEditable();
        }

        @Override
        public boolean isLeaf(int n) {
            return true;
        }

        @Override
        public boolean isValidElement(int n) {
            return true;
        }
    }
}

