/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app;

import com.triloggroup.gantt.renderer.TGEntity;
import com.triloggroup.util.UString;

class OverlayData {
    String text;
    int x;
    int y;
    TGEntity[] highlight;
    TGEntity zoneHighlight;
    int zone;

    OverlayData() {
    }

    void addHighlight(TGEntity tGEntity) {
        if (tGEntity == null) {
            return;
        }
        if (this.highlight == null) {
            this.highlight = new TGEntity[]{tGEntity};
        } else {
            TGEntity[] tGEntityArray = this.highlight;
            this.highlight = new TGEntity[tGEntityArray.length + 1];
            this.highlight[0] = tGEntity;
            System.arraycopy(tGEntityArray, 0, this.highlight, 1, tGEntityArray.length);
        }
    }

    public boolean isEmpty() {
        return UString.isEmpty(this.text) && this.highlight == null && this.zoneHighlight == null;
    }

    public static boolean isEquivalent(OverlayData overlayData, OverlayData overlayData2) {
        int n;
        if (overlayData == overlayData2) {
            return true;
        }
        if (overlayData == null) {
            return overlayData2.isEmpty();
        }
        if (overlayData2 == null) {
            return overlayData.isEmpty();
        }
        if (!UString.isEmpty(overlayData.text)) {
            if (overlayData.x != overlayData2.x || overlayData.y != overlayData2.y) {
                return false;
            }
            if (!UString.equals(overlayData.text, overlayData2.text)) {
                return false;
            }
        } else if (!UString.isEmpty(overlayData2.text)) {
            return false;
        }
        int n2 = overlayData.highlight == null ? 0 : overlayData.highlight.length;
        int n3 = n = overlayData2.highlight == null ? 0 : overlayData2.highlight.length;
        if (n2 != n) {
            return false;
        }
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                if (overlayData.highlight[i] == overlayData2.highlight[i]) continue;
                return false;
            }
        }
        if (overlayData.zoneHighlight != overlayData2.zoneHighlight) {
            return false;
        }
        return overlayData.zone == overlayData2.zone;
    }
}

