/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app;

import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.app.AppGanttChart;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class ExpandCollapseAction
extends AbstractAction {
    private int toLevel;
    private TGNode node;
    private AppGanttChart ganttCtrl;

    public ExpandCollapseAction(int n, AppGanttChart appGanttChart) {
        this(null, n, appGanttChart);
    }

    public ExpandCollapseAction(TGNode tGNode, int n, AppGanttChart appGanttChart) {
        this.node = tGNode;
        this.toLevel = n;
        this.ganttCtrl = appGanttChart;
        String string = n == 0 ? AppGanttChart.NLS_BUNDLE.getString("collapse_node") : (n < 0 ? AppGanttChart.NLS_BUNDLE.getString("expand_all") : AppGanttChart.NLS_BUNDLE.getString("expand_to_level", new Integer(n + 1)));
        this.putValue("Name", string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.toLevel != 0 && GanttNode.isSubprojectLinkNotLoaded(this.node)) {
            this.ganttCtrl.loadSubproject((GanttWBS)this.node, this.toLevel);
            return;
        }
        this.ganttCtrl.expandNodeToLevel(this.node, this.toLevel, true);
        if (this.node == null || this.node == this.ganttCtrl.getModel().getRootNode()) {
            this.ganttCtrl.getUserPreferences().setWbsLevel(this.toLevel);
        }
    }
}

