/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app;

import com.triloggroup.gantt.EmptyNode;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.TGChart;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.ChartLocation;
import com.triloggroup.gantt.app.DropAction;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.data.gantt.TaskSeries;

class DragInfo {
    private ChartRenderingInfo chartInfo;
    private AppGanttChart controller;
    boolean initialized = false;
    ChartLocation source = null;
    ChartLocation lastTarget = null;
    boolean hourPrecision;

    DragInfo(AppGanttChart appGanttChart, ChartRenderingInfo chartRenderingInfo, int n, int n2, boolean bl) {
        this.controller = appGanttChart;
        this.chartInfo = chartRenderingInfo;
        this.source = new ChartLocation(n, n2);
        this.hourPrecision = bl;
    }

    void initialize() {
        this.initialized = true;
        this.source.initialize(this.chartInfo);
    }

    double getCompletion(int n) {
        return this.source.getCompletion(n);
    }

    DropAction getDropActionAvailableAt(int n, int n2) {
        DropAction dropAction = new DropAction();
        if (!this.initialized) {
            return dropAction;
        }
        if (this.source.entityType != 1 && this.source.entityType != 2) {
            return dropAction;
        }
        this.lastTarget = null;
        Rectangle rectangle = this.source.entity.getArea().getBounds();
        int n3 = rectangle.y - 2;
        int n4 = rectangle.y + rectangle.height + 2;
        if (n2 > n3 && n2 < n4) {
            if (this.source.entityType != 1) {
                return dropAction;
            }
            if (this.source.zone == 16) {
                dropAction.setAction(16);
                return dropAction;
            }
            GanttTask ganttTask = (GanttTask)this.source.entity.getNode();
            if (ganttTask.isMilestone()) {
                dropAction.setAction(96);
            } else {
                switch (this.source.zone) {
                    case 32: 
                    case 33: {
                        switch (ganttTask.getSchedulingMode()) {
                            case 3: {
                                dropAction.setAction(48);
                                break;
                            }
                            case 2: {
                                dropAction.setAction(112);
                                break;
                            }
                            case 0: 
                            case 1: {
                                dropAction.setAction(96);
                            }
                        }
                        break;
                    }
                    case 48: 
                    case 49: {
                        switch (ganttTask.getSchedulingMode()) {
                            case 3: {
                                dropAction.setAction(96);
                                break;
                            }
                            case 2: {
                                dropAction.setAction(128);
                                break;
                            }
                            case 0: {
                                dropAction.setAction(48);
                                break;
                            }
                            case 1: {
                                dropAction.setAction(64);
                            }
                        }
                        break;
                    }
                    case 0: {
                        dropAction.setAction(96);
                    }
                }
            }
            if ("Done".equals(ganttTask.getStatus())) {
                dropAction.setNotAvailable("operation_not_available_status_done");
            }
            return dropAction;
        }
        if (this.source.zone == 16) {
            return dropAction;
        }
        this.lastTarget = new ChartLocation(n, n2);
        this.lastTarget.initialize(this.chartInfo);
        if (this.lastTarget.entity == null) {
            int n5;
            TGNode tGNode;
            GanttNode ganttNode = (GanttNode)this.source.entity.getNode();
            if (ganttNode.isProjectRoot()) {
                return dropAction;
            }
            int n6 = TGChart.getRowHeight();
            Rectangle2D rectangle2D = this.chartInfo.getPlotInfo().getDataArea();
            int n7 = 3;
            int n8 = n2 - (int)rectangle2D.getY();
            if ((n8 += n7) % n6 > n7 * 2) {
                return dropAction;
            }
            int n9 = n8 / n6;
            TaskSeries taskSeries = this.controller.getTaskSeries();
            if (n9 < 1 || n9 > taskSeries.getItemCount()) {
                return dropAction;
            }
            TGNode tGNode2 = tGNode = n9 == taskSeries.getItemCount() ? null : (TGNode)taskSeries.get(n9);
            if (tGNode == ganttNode) {
                return dropAction;
            }
            TGNode tGNode3 = ganttNode.getParent();
            if (tGNode != null && tGNode.getParent() == tGNode3 && !(tGNode instanceof EmptyNode)) {
                int n10 = ganttNode.getSubId();
                int n11 = tGNode.getSubId();
                if (n11 == n10 + 1) {
                    return dropAction;
                }
                n5 = n11 > n10 ? n11 - 1 : n11;
            } else {
                if (n2 < this.source.y) {
                    return dropAction;
                }
                if (tGNode3.getLastVisibleSubtask() == ganttNode) {
                    return dropAction;
                }
                TGNode tGNode4 = (TGNode)taskSeries.get(n9 - 1);
                if (tGNode4.hasVisibleSubtask()) {
                    return dropAction;
                }
                if (tGNode4 == ganttNode) {
                    return dropAction;
                }
                while (true) {
                    TGNode tGNode5;
                    if ((tGNode5 = tGNode4.getParent()) == null) {
                        return dropAction;
                    }
                    TGNode tGNode6 = tGNode5.getLastVisibleSubtask();
                    if (tGNode6 != tGNode4) {
                        return dropAction;
                    }
                    if (tGNode5 == tGNode3) break;
                    tGNode4 = tGNode5;
                }
                n5 = ((GanttWBS)tGNode3).getAllNonEmptySubTaskCount();
            }
            dropAction.setAction(144);
            dropAction.data = tGNode3.getHierarchicalId() + '.' + n5;
            return dropAction;
        }
        if (this.lastTarget.entityType == 2) {
            GanttWBS ganttWBS = (GanttWBS)this.lastTarget.entity.getNode();
            GanttNode ganttNode = (GanttNode)this.source.entity.getNode();
            dropAction.setAction(32);
            if (ganttNode.isProjectRoot()) {
                dropAction.setNotAvailable("operation_not_available_child_node");
                return dropAction;
            }
            if (!ganttNode.isSameProject(ganttWBS) || ganttWBS.isSubProject()) {
                dropAction.setNotAvailable(null);
                return dropAction;
            }
            if (ganttWBS == ganttNode.getParent()) {
                dropAction.setNotAvailable("operation_not_available_same_parent");
            } else if (this.source.entityType != 1) {
                for (TGNode tGNode = ganttWBS; tGNode != null; tGNode = tGNode.getParent()) {
                    if (tGNode != ganttNode) continue;
                    dropAction.setNotAvailable("operation_not_available_child_node");
                    break;
                }
            }
            return dropAction;
        }
        if (this.source.entityType != 1) {
            return dropAction;
        }
        if (this.lastTarget.entityType != 1) {
            return dropAction;
        }
        GanttTask ganttTask = (GanttTask)this.lastTarget.entity.getNode();
        int n12 = this.source.zone & 0xFFFFFFFE;
        int n13 = this.lastTarget.zone & 0xFFFFFFFE;
        int n14 = n12 == 32 ? (n13 == 48 ? 2 : 3) : (n13 == 48 ? 0 : 1);
        dropAction.setAction(80 + n14);
        String string = this.controller.getModel().getCreatePredecessorNotPossibleMsgKey(ganttTask, (GanttTask)this.source.entity.getNode());
        if (string != null) {
            dropAction.setNotAvailable(string);
        }
        return dropAction;
    }
}

