/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app;

import com.triloggroup.gantt.renderer.TGEntity;
import java.awt.Rectangle;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;

class ChartLocation {
    int x;
    int y;
    int entityType = 0;
    int zone = 0;
    TGEntity entity;

    ChartLocation(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    void initialize(ChartRenderingInfo chartRenderingInfo) {
        this.entity = this.getEntity(this.x, this.y, chartRenderingInfo);
        if (this.entity == null) {
            return;
        }
        this.entityType = this.entity.getEntityType();
        this.zone = this.entity.getZone(this.x, this.y);
    }

    private TGEntity getEntity(int n, int n2, ChartRenderingInfo chartRenderingInfo) {
        ChartEntity chartEntity = null;
        EntityCollection entityCollection = chartRenderingInfo.getEntityCollection();
        if (entityCollection != null) {
            chartEntity = entityCollection.getEntity((double)n, (double)n2);
        }
        return (TGEntity)chartEntity;
    }

    double getCompletion(int n) {
        Rectangle rectangle = this.entity.getArea().getBounds();
        double d = n - rectangle.x - 8;
        double d2 = d / (double)(rectangle.width - 16);
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d2 > 1.0) {
            return 1.0;
        }
        d2 = Math.floor(d2 * 20.0 + 0.5) / 20.0;
        return d2;
    }

    double getCoeff(int n) {
        double d = n - this.x;
        Rectangle rectangle = this.entity.getArea().getBounds();
        int n2 = rectangle.width - 16;
        if (n2 <= 0) {
            n2 = 1;
        }
        double d2 = d / (double)n2;
        if ((this.zone & 0xFFFFFFFE) == 32) {
            return -d2;
        }
        return d2;
    }
}

