/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.allocation.renderer;

import com.triloggroup.gantt.GanttChart;
import com.triloggroup.gantt.GanttDataset;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.TGCategoryPlot;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.allocation.AllocationProjectContext;
import com.triloggroup.gantt.allocation.AllocationsNode;
import com.triloggroup.gantt.allocation.IAllocationGlobalContext;
import com.triloggroup.gantt.allocation.ProjectAllocationsNode;
import com.triloggroup.gantt.allocation.ResourceAllocationsNode;
import com.triloggroup.gantt.renderer.GanttNodeRenderer;
import com.triloggroup.gantt.renderer.TGEntity;
import com.triloggroup.gantt.util.ValueInterval;
import com.triloggroup.gantt.util.ValueIntervals;
import com.triloggroup.project.components.IContext;
import com.triloggroup.project.schedule.ScheduleCalendar;
import com.triloggroup.ui.UGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.time.TimePeriod;
import org.jfree.ui.RectangleEdge;

public class AllocationNodeRenderer
extends GanttNodeRenderer {
    private static final Color UNDER_100_ALLOC_COLOR = new Color(193, 250, 190);
    private boolean waveui = false;

    public AllocationNodeRenderer(boolean bl) {
        this.setDrawBarOutline(bl);
        this.startPercent = 0.45;
        this.endPercent = 0.55;
    }

    public boolean isWaveui() {
        return this.waveui;
    }

    public void setWaveui(boolean bl) {
        this.waveui = bl;
    }

    protected void drawNode(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, TGCategoryPlot tGCategoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, GanttDataset ganttDataset, int n, int n2) {
        this.checkHorizontalOrientation(tGCategoryPlot);
        TGNode tGNode = ganttDataset.getNode(n, n2);
        double d = this.calculateBarW0(tGCategoryPlot, tGCategoryPlot.getOrientation(), rectangle2D, categoryAxis, categoryItemRendererState, n, n2);
        this.drawBackgroundColor(tGNode, graphics2D, d, rectangle2D, tGCategoryPlot);
        this.drawCalendarDayOff(graphics2D, categoryItemRendererState, rectangle2D, tGCategoryPlot, categoryAxis, valueAxis, ganttDataset, n, n2, tGNode, d);
        if (tGNode instanceof AllocationsNode) {
            if (tGCategoryPlot.isSelectedNode(tGNode)) {
                this.drawBackgroundSelection(tGNode, graphics2D, d, rectangle2D, tGCategoryPlot);
            }
            this.drawAllocNode(graphics2D, categoryItemRendererState, rectangle2D, tGCategoryPlot, categoryAxis, valueAxis, ganttDataset, n, n2, (AllocationsNode)tGNode, d);
        } else {
            super.drawNode(graphics2D, categoryItemRendererState, rectangle2D, tGCategoryPlot, categoryAxis, valueAxis, ganttDataset, n, n2);
        }
    }

    protected void drawBackgroundColor(TGNode tGNode, Graphics2D graphics2D, double d, Rectangle2D rectangle2D, CategoryPlot categoryPlot) {
        Color color = null;
        if (tGNode instanceof AllocationsNode) {
            color = ((AllocationsNode)tGNode).getTranslucentBackgroundColor();
        } else if (tGNode instanceof GanttTask) {
            color = ((AllocationsNode)tGNode.getParent()).getTranslucentBackgroundColor();
        }
        this.drawRowBackground(color, graphics2D, d, rectangle2D, categoryPlot);
    }

    protected void drawAllocNode(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, GanttDataset ganttDataset, int n, int n2, AllocationsNode allocationsNode, double d) {
        Object object;
        ValueIntervals valueIntervals;
        if (this.getGlobalContext(allocationsNode).isGanttResource()) {
            return;
        }
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        boolean bl = false;
        if (allocationsNode instanceof ResourceAllocationsNode) {
            if (this.getGlobalContext(allocationsNode).getDisplayMode() == 0) {
                return;
            }
            bl = true;
        }
        if ((valueIntervals = allocationsNode.getIntervals()) != null) {
            for (int i = 0; i < valueIntervals.size(); ++i) {
                int n3;
                ValueInterval valueInterval = (ValueInterval)valueIntervals.get(i);
                object = this.getAllocColor(valueInterval.value);
                i = n3 = this.getIndexNextSiblingIntervalSameColor(valueIntervals, i, (Color)object);
                this.drawValueInterval(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, valueAxis, d, valueInterval.start, ((ValueInterval)valueIntervals.get((int)n3)).end, (Color)object, valueInterval.value);
            }
        }
        double d2 = categoryItemRendererState.getBarWidth();
        if (bl) {
            object = new Rectangle2D.Double(categoryPlot.getInsets().getLeft(), d, rectangle2D.getWidth(), d2);
            BasicStroke basicStroke = new BasicStroke();
            graphics2D.setStroke(basicStroke);
            graphics2D.setPaint(UGraphic.getColorWithAlphaForWhiteBackground(Color.BLACK, 128));
            graphics2D.draw((Shape)object);
        } else {
            object = allocationsNode.getDuration();
            if (object != null) {
                double d3;
                double d4 = object.getEnd().getTime();
                double d5 = object.getStart().getTime();
                double d6 = valueAxis.valueToJava2D(d4, rectangle2D, rectangleEdge);
                double d7 = valueAxis.valueToJava2D(d5, rectangle2D, rectangleEdge);
                if (d7 < d6) {
                    d3 = d7;
                    d7 = d6;
                    d6 = d3;
                }
                d3 = d7 - d6;
                Rectangle2D.Double double_ = new Rectangle2D.Double(d6, d, d3, d2);
                this.setDrawBarOutline(true);
                this.drawShapeOutline(graphics2D, double_, categoryItemRendererState, n, n2);
                this.setDrawBarOutline(false);
            }
        }
    }

    protected void drawCalendarDayOff(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, GanttDataset ganttDataset, int n, int n2, TGNode tGNode, double d) {
        IContext iContext = tGNode.getNodeContext();
        if (iContext instanceof AllocationProjectContext) {
            AllocationProjectContext allocationProjectContext = (AllocationProjectContext)iContext;
            ScheduleCalendar scheduleCalendar = null;
            while (tGNode != null) {
                if (tGNode instanceof ResourceAllocationsNode) {
                    scheduleCalendar = allocationProjectContext.getResourceCalendarByDn(((ResourceAllocationsNode)tGNode).getResource().getDn());
                    break;
                }
                tGNode = tGNode.getParent();
            }
            if (scheduleCalendar == null) {
                scheduleCalendar = allocationProjectContext.getProjectCalendar();
            }
            this.drawCalendarOffDays(graphics2D, scheduleCalendar, rectangle2D, categoryPlot, valueAxis, d);
        }
    }

    protected void drawValueInterval(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ValueAxis valueAxis, double d, long l, long l2, Color color, int n) {
        double d2;
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        double d3 = valueAxis.valueToJava2D((double)l2, rectangle2D, rectangleEdge);
        double d4 = valueAxis.valueToJava2D((double)l, rectangle2D, rectangleEdge);
        if (d4 < d3) {
            d2 = d4;
            d4 = d3;
            d3 = d2;
        }
        d2 = categoryItemRendererState.getBarWidth();
        if (this.isWaveui() && n < 100) {
            d2 = Math.round(d2 * (double)n / 100.0);
            d = d + categoryItemRendererState.getBarWidth() - d2;
            graphics2D.setColor(HEALTH_DEFAULT_COLOR);
            graphics2D.setStroke(DEFAULT_STROKE);
            graphics2D.drawLine((int)d3, (int)d, (int)d4, (int)d);
            d2 -= 1.0;
            d += 1.0;
        }
        double d5 = d4 - d3;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d, d5, d2);
        graphics2D.setPaint(color);
        graphics2D.fill(double_);
    }

    protected Color getAllocColor(int n) {
        if (n < 100) {
            return UNDER_100_ALLOC_COLOR;
        }
        if (n == 100) {
            return HEALTH_DEFAULT_COLOR;
        }
        if (n <= 110) {
            return HEALTH_WARNING_COLOR;
        }
        return HEALTH_CRITICAL_COLOR;
    }

    protected int getIndexNextSiblingIntervalSameColor(ValueIntervals valueIntervals, int n, Color color) {
        if (this.isWaveui()) {
            return n;
        }
        int n2 = n;
        ValueInterval valueInterval = (ValueInterval)valueIntervals.get(n);
        for (int i = n + 1; i < valueIntervals.size(); ++i) {
            ValueInterval valueInterval2 = (ValueInterval)valueIntervals.get(i);
            Color color2 = this.getAllocColor(valueInterval2.value);
            if (color2 != color || valueInterval2.start != valueInterval.end) break;
            ++n2;
        }
        return n2;
    }

    protected void drawTaskNode(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, TGCategoryPlot tGCategoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, GanttDataset ganttDataset, int n, int n2, GanttTask ganttTask, double d) {
        if (this.getGlobalContext(ganttTask).isGanttResource()) {
            super.drawTaskNode(graphics2D, categoryItemRendererState, rectangle2D, tGCategoryPlot, categoryAxis, valueAxis, ganttDataset, n, n2, ganttTask, d);
            return;
        }
        if (ganttTask.isMilestone()) {
            this.drawMilestoneNode(graphics2D, categoryItemRendererState, rectangle2D, tGCategoryPlot, categoryAxis, valueAxis, ganttDataset, n, n2, ganttTask, d);
        } else {
            EntityCollection entityCollection;
            double d2;
            RectangleEdge rectangleEdge = tGCategoryPlot.getRangeAxisEdge();
            TimePeriod timePeriod = ganttTask.getDuration();
            double d3 = timePeriod.getEnd().getTime();
            double d4 = timePeriod.getStart().getTime();
            if (d4 == d3) {
                d3 += ganttTask.getDurationInHours() * 3600000.0;
            }
            double d5 = valueAxis.valueToJava2D(d3, rectangle2D, rectangleEdge);
            double d6 = valueAxis.valueToJava2D(d4, rectangle2D, rectangleEdge);
            if (d6 < d5) {
                d2 = d6;
                d6 = d5;
                d5 = d2;
            }
            d2 = categoryItemRendererState.getBarWidth();
            double d7 = d6 - d5;
            Rectangle2D.Double double_ = new Rectangle2D.Double(d5, d + d2 / 2.0, d7, d2 / 2.0);
            int n3 = 4;
            int n4 = 4;
            BufferedImage bufferedImage = new BufferedImage(n3, n4, 1);
            Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
            graphics2D2.setColor(Color.WHITE);
            graphics2D2.fillRect(0, 0, n3, n4);
            Color color = this.getGanttTaskColor(ganttTask);
            graphics2D2.setColor(color);
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D2.draw(new Line2D.Double(0.0, 0.0, n3 - 1, n4 - 1));
            TexturePaint texturePaint = new TexturePaint(bufferedImage, new Rectangle2D.Double(0.0, 0.0, n3, n4));
            graphics2D.setPaint(texturePaint);
            graphics2D.fill(double_);
            graphics2D.setPaint(color);
            graphics2D.draw(double_);
            boolean bl = ganttTask.getProjectContext().showPercentComplete();
            if (bl) {
                this.drawPercentComplete(graphics2D, ganttTask, double_);
            }
            this.drawShapeOutline(graphics2D, double_, categoryItemRendererState, n, n2);
            this.drawTaskLabel(graphics2D, rectangle2D, categoryAxis, n, n2, ganttTask, d5, d, d7, bl);
            if (!GanttChart.isServerMode && (entityCollection = categoryItemRendererState.getEntityCollection()) != null) {
                entityCollection.add((ChartEntity)TGEntity.create((CategoryDataset)ganttDataset, n, n2, ganttTask, double_));
            }
        }
    }

    protected Color getGanttTaskColor(GanttTask ganttTask) {
        if (this.getGlobalContext(ganttTask).isGanttResource()) {
            return super.getGanttTaskColor(ganttTask);
        }
        ProjectAllocationsNode projectAllocationsNode = (ProjectAllocationsNode)ganttTask.getParent();
        TimePeriod timePeriod = ganttTask.getDuration();
        int n = projectAllocationsNode.getIntervals().getMaxValue(timePeriod.getStart().getTime(), timePeriod.getEnd().getTime());
        return this.getAllocColor(n);
    }

    private IAllocationGlobalContext getGlobalContext(TGNode tGNode) {
        return (IAllocationGlobalContext)tGNode.getGlobalContext();
    }
}

