/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt;

import com.triloggroup.gantt.INodeFilter;
import com.triloggroup.gantt.ITimeUnits;
import com.triloggroup.project.components.IGlobalContext;
import com.triloggroup.util.NLSBundle;
import java.util.Date;

public class GlobalContext
implements IGlobalContext {
    private String siteId;
    private Date currentDate;
    private NLSBundle nlsBundle;
    private ITimeUnits timeUnits;
    private boolean isEditable;
    private INodeFilter currentFilter;
    private boolean timePrecision;

    public GlobalContext(String string) {
        this.siteId = string;
    }

    public void init(Date date, NLSBundle nLSBundle, ITimeUnits iTimeUnits) {
        this.currentDate = date;
        if (this.currentDate == null) {
            this.currentDate = new Date();
        }
        this.nlsBundle = nLSBundle;
        this.timeUnits = iTimeUnits;
    }

    public GlobalContext getGlobalContext() {
        return this;
    }

    public Date getCurrentDate() {
        return this.currentDate;
    }

    public NLSBundle getNLSBundle() {
        return this.nlsBundle;
    }

    public ITimeUnits getTimeUnits() {
        return this.timeUnits;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean bl) {
        this.isEditable = bl;
    }

    public void setFilter(INodeFilter iNodeFilter) {
        this.currentFilter = iNodeFilter;
    }

    public INodeFilter getFilter() {
        return this.currentFilter;
    }

    public void setTimePrecision(boolean bl) {
        this.timePrecision = bl;
    }

    public boolean isTimePrecision() {
        return this.timePrecision;
    }

    public Date convertToServerTimeZone(Date date) {
        return date;
    }

    public Date getServerTime() {
        return new Date();
    }
}

