/*
 * Decompiled with CFR 0.152.
 */
package com.flowbuilder.util;

import com.flowbuilder.util.TString;
import java.text.DateFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public final class TFormatter {
    public static long getInteger(String string) {
        if (TString.isEmpty(string)) {
            return 0L;
        }
        return Long.parseLong(string);
    }

    public static long parseInt(String string, Locale locale) throws ParseException {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        numberFormat.setParseIntegerOnly(true);
        return numberFormat.parse(string).longValue();
    }

    public static double getDecimal(String string) {
        if (TString.isEmpty(string)) {
            return 0.0;
        }
        return Double.parseDouble(string);
    }

    public static double parseFloatWithDecimalSeparatorTolerance(String string, Locale locale) {
        string = TFormatter.removeThousandSeparator(string, locale);
        string = TFormatter.replaceCommaByPoint(string, locale);
        return TFormatter.getDecimal(string);
    }

    public static String replaceCommaByPoint(String string, Locale locale) {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
        if (decimalFormatSymbols.getDecimalSeparator() == ',' && string.indexOf(44) >= 0 && string.indexOf(44) == string.lastIndexOf(44) && string.indexOf(46) == -1) {
            return string.replace(',', '.');
        }
        return string;
    }

    public static String removeThousandSeparator(String string, Locale locale) {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
        char c = decimalFormatSymbols.getGroupingSeparator();
        if (c == '.') {
            return string;
        }
        if (c == '\u00a0') {
            c = ' ';
        }
        return TString.replace(string, String.valueOf(c), null);
    }

    public static double parseFloat(String string, Locale locale) throws ParseException {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return NumberFormat.getInstance(locale).parse(string).floatValue();
    }

    public static final DateFormat getDefaultDateFormatter() {
        return TFormatter.getShortDateFormatter();
    }

    public static final DateFormat getShortDateFormatter() {
        return DateFormat.getDateInstance(3);
    }

    public static final DateFormat getDefaultTimeFormatter() {
        return TFormatter.getShortTimeFormatter();
    }

    public static final DateFormat getShortTimeFormatter() {
        return DateFormat.getTimeInstance(3);
    }

    public static final DateFormat getDefaultDatetimeFormatter() {
        return TFormatter.getShortDatetimeFormatter();
    }

    public static final DateFormat getShortDatetimeFormatter() {
        return DateFormat.getDateTimeInstance(3, 3);
    }
}

