/*
 * Decompiled with CFR 0.152.
 */
package com.flowbuilder.util;

import com.flowbuilder.util.TString;
import com.flowbuilder.util.xml.JDOMUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;

public class JSONUtil {
    private ArrayList<Boolean> stackOfValuesInObjOrArray = new ArrayList();
    private Appendable out;
    private boolean compact = true;
    private boolean htmlEmbedded = false;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public JSONUtil(Appendable appendable) {
        this(appendable, true);
    }

    public JSONUtil(Appendable appendable, boolean bl) {
        this.out = appendable;
        this.compact = bl;
    }

    public void setCompact(boolean bl) {
        this.compact = bl;
    }

    public boolean isCompact() {
        return this.compact;
    }

    public void setHtmlEmbedded(boolean bl) {
        this.htmlEmbedded = bl;
    }

    public boolean isHtmlEmbedded() {
        return this.htmlEmbedded;
    }

    public void appendObjDeclaration(String string) throws IOException {
        if (!this.stackOfValuesInObjOrArray.isEmpty() && this.stackOfValuesInObjOrArray.get(this.stackOfValuesInObjOrArray.size() - 1).booleanValue()) {
            this.write(", ");
        }
        this.stackOfValuesInObjOrArray.add(Boolean.FALSE);
        if (TString.isEmpty(string)) {
            this.write(" {");
        } else {
            this.write("\"");
            this.write(string);
            this.write("\" : {");
        }
        if (!this.compact) {
            this.write(LINE_SEPARATOR);
        }
        if (this.stackOfValuesInObjOrArray.size() > 1) {
            this.stackOfValuesInObjOrArray.set(this.stackOfValuesInObjOrArray.size() - 2, Boolean.TRUE);
        }
    }

    public void closeObjDeclaration() throws IOException {
        this.stackOfValuesInObjOrArray.remove(this.stackOfValuesInObjOrArray.size() - 1);
        this.write(" } ");
        if (!this.compact) {
            this.write(LINE_SEPARATOR);
        }
    }

    public void appendValue(String string, String string2) throws IOException {
        this.appendValueHeader(string);
        if (string2 == null) {
            this.write("null");
        } else {
            this.write("\"");
            this.writeEscaped(string2);
            this.write("\"");
        }
        if (!this.compact) {
            this.write(LINE_SEPARATOR);
        }
    }

    public void appendValue(String string, long l) throws IOException {
        this.appendValueHeader(string);
        this.write(String.valueOf(l));
        if (!this.compact) {
            this.write(LINE_SEPARATOR);
        }
    }

    public void appendValue(String string, double d) throws IOException {
        this.appendValueHeader(string);
        this.write(String.valueOf(d));
        if (!this.compact) {
            this.write(LINE_SEPARATOR);
        }
    }

    public void appendValue(String string, BigDecimal bigDecimal) throws IOException {
        this.appendValueHeader(string);
        this.write(bigDecimal.toString());
        if (!this.compact) {
            this.write(LINE_SEPARATOR);
        }
    }

    public void appendValue(String string, boolean bl) throws IOException {
        this.appendValueHeader(string);
        this.write(String.valueOf(bl));
        if (!this.compact) {
            this.write(LINE_SEPARATOR);
        }
    }

    public void appendValue(String string, Date date) throws IOException {
        this.appendValueHeader(string);
        this.write("\"");
        this.write(JDOMUtil.toString(date));
        this.write("\"");
        if (!this.compact) {
            this.write(LINE_SEPARATOR);
        }
    }

    public void appendValue(String string, Time time) throws IOException {
        this.appendValueHeader(string);
        this.write("\"");
        this.write(JDOMUtil.toString(time));
        this.write("\"");
        if (!this.compact) {
            this.write(LINE_SEPARATOR);
        }
    }

    public void appendValue(String string, Timestamp timestamp) throws IOException {
        this.appendValueHeader(string);
        this.write("\"");
        this.write(JDOMUtil.toString(timestamp));
        this.write("\"");
        if (!this.compact) {
            this.write(LINE_SEPARATOR);
        }
    }

    public void openArray(String string) throws IOException {
        this.appendValueHeader(string);
        this.stackOfValuesInObjOrArray.add(Boolean.FALSE);
        this.write(" [ ");
        if (!this.compact) {
            this.write(LINE_SEPARATOR);
        }
    }

    public void closeArray() throws IOException {
        this.stackOfValuesInObjOrArray.remove(this.stackOfValuesInObjOrArray.size() - 1);
        this.write(" ] ");
        if (!this.compact) {
            this.write(LINE_SEPARATOR);
        }
    }

    private void appendValueHeader(String string) throws IOException {
        if (!this.stackOfValuesInObjOrArray.isEmpty() && this.stackOfValuesInObjOrArray.get(this.stackOfValuesInObjOrArray.size() - 1).booleanValue()) {
            this.write(", ");
        }
        if (!TString.isEmpty(string)) {
            this.write("\"");
            this.write(string);
            this.write("\" : ");
        }
        if (!this.stackOfValuesInObjOrArray.isEmpty()) {
            this.stackOfValuesInObjOrArray.set(this.stackOfValuesInObjOrArray.size() - 1, Boolean.TRUE);
        }
    }

    private void write(String string) throws IOException {
        this.out.append(string);
    }

    private void writeEscaped(String string) throws IOException {
        int n = string.length();
        block10: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\b': {
                    this.out.append("\\b");
                    continue block10;
                }
                case '\t': {
                    this.out.append("\\t");
                    continue block10;
                }
                case '\n': {
                    this.out.append("\\n");
                    continue block10;
                }
                case '\f': {
                    this.out.append("\\f");
                    continue block10;
                }
                case '\r': {
                    this.out.append("\\r");
                    continue block10;
                }
                case '\"': {
                    this.out.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    this.out.append("\\\\");
                    continue block10;
                }
                case '/': {
                    if (this.htmlEmbedded) {
                        this.out.append("\\u002f");
                        continue block10;
                    }
                }
                default: {
                    if (c < ' ' || c > '\u00ff') {
                        this.out.append("\\u");
                        this.out.append(TString.toUnsignedHex(c, 4));
                        continue block10;
                    }
                    this.out.append(c);
                }
            }
        }
    }
}

