/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.util.date;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGTime
implements Cloneable,
Comparable<TGTime> {
    public final int hours;
    public final int minutes;
    public final int seconds;

    public TGTime(int n, int n2) {
        this(n, n2, 0);
    }

    public TGTime(int n, int n2, int n3) {
        this.hours = n;
        this.minutes = n2;
        this.seconds = n3;
    }

    public TGTime(Date date) {
        this(date, TimeZone.getDefault());
    }

    public TGTime(Date date, TimeZone timeZone) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.setTime(date);
        this.hours = gregorianCalendar.get(11);
        this.minutes = gregorianCalendar.get(12);
        this.seconds = gregorianCalendar.get(13);
    }

    public long toMinutes() {
        return this.hours * 60 + this.minutes;
    }

    public long toSeconds() {
        return this.hours * 3600 + this.minutes * 60 + this.seconds;
    }

    public void setTimeToDate(Date date) {
        date.setHours(this.hours);
        date.setMinutes(this.minutes);
        date.setSeconds(this.seconds);
    }

    public Date applyTime(Date date) {
        return this.applyTime(date, TimeZone.getDefault());
    }

    public Date applyTime(Date date, TimeZone timeZone) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(11, this.hours);
        gregorianCalendar.set(12, this.minutes);
        gregorianCalendar.set(13, this.seconds);
        gregorianCalendar.set(14, 0);
        return gregorianCalendar.getTime();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TGTime) {
            TGTime tGTime = (TGTime)object;
            return this.hours == tGTime.hours && this.minutes == tGTime.minutes && this.seconds == tGTime.seconds;
        }
        return false;
    }

    @Override
    public int compareTo(TGTime tGTime) {
        if (tGTime == null) {
            return 1;
        }
        return (this.hours - tGTime.hours) * 3600 + (this.minutes - tGTime.minutes) * 60 + this.seconds - tGTime.seconds;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.hours < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.hours).append(':');
        if (this.minutes < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.minutes).append(':');
        if (this.seconds < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append('0');
        return stringBuilder.toString();
    }
}

