/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.ui;

import com.triloggroup.ui.NumberTextField;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public class IntTextField
extends NumberTextField {
    public IntTextField() {
        this((Locale)null);
    }

    public IntTextField(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.init(NumberFormat.getIntegerInstance(locale));
    }

    public void setValue(Integer n) {
        this.setNumberValue(n);
    }

    public void setValue(int n) {
        this.setValue(new Integer(n));
    }

    public Integer getValue() {
        return (Integer)this.getNumberValue();
    }

    public int getIntValue() {
        return this.getIntValue(0);
    }

    public int getIntValue(int n) {
        Integer n2 = this.getValue();
        return n2 == null ? n : n2;
    }

    protected String format(Number number) {
        if (number == null) {
            return "";
        }
        return this.format.format(number.intValue());
    }

    protected NumberTextField.ParseResult parse(String string) {
        NumberTextField.ParseResult parseResult = new NumberTextField.ParseResult(this);
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = this.format.parse(string, parsePosition);
        if (parsePosition.getIndex() == string.length()) {
            parseResult.valid = true;
            parseResult.value = number == null || number instanceof Integer ? (Number)number : (Number)new Integer(number.intValue());
        }
        return parseResult;
    }
}

