/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.schedule;

import com.triloggroup.project.schedule.IPredecessor;

public class Predecessor
implements IPredecessor,
Cloneable {
    public static final int CONSTRAINT_FF = 0;
    public static final int CONSTRAINT_FS = 1;
    public static final int CONSTRAINT_SF = 2;
    public static final int CONSTRAINT_SS = 3;
    final String predecessorId;
    final int type;
    final int lag;
    final int lagFormat;
    private int hash;

    public Predecessor(String string, int n) {
        this(string, n, 0, 5);
    }

    public Predecessor(String string, int n, int n2, int n3) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.predecessorId = string;
        this.type = n;
        this.lag = n2;
        this.lagFormat = n3;
    }

    public String getId() {
        return this.predecessorId;
    }

    public int getType() {
        return this.type;
    }

    public int getLag() {
        return this.lag;
    }

    public int getLagFormat() {
        return this.lagFormat;
    }

    public String toString() {
        return this.predecessorId + " (" + Predecessor.predecessorTypeAsString(this.type) + ')';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Predecessor)) {
            return false;
        }
        Predecessor predecessor = (Predecessor)object;
        return predecessor.predecessorId.equals(this.predecessorId) && predecessor.type == this.type && predecessor.lag == this.lag && predecessor.lagFormat == this.lagFormat;
    }

    public Predecessor clone() {
        try {
            return (Predecessor)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int hashCode() {
        if (this.hash == 0) {
            String string = this.predecessorId + this.type + this.lag + this.lagFormat;
            this.hash = string.hashCode();
        }
        return this.hash;
    }

    public static int predecessorTypeAsInt(String string) {
        if ("SS".equals(string)) {
            return 3;
        }
        if ("FS".equals(string)) {
            return 1;
        }
        if ("SF".equals(string)) {
            return 2;
        }
        if ("FF".equals(string)) {
            return 0;
        }
        return 1;
    }

    public static String predecessorTypeAsString(int n) {
        switch (n) {
            case 3: {
                return "SS";
            }
            case 1: {
                return "FS";
            }
            case 2: {
                return "SF";
            }
            case 0: {
                return "FF";
            }
        }
        throw new IllegalArgumentException("Invalid predecessor type: " + n);
    }

    public static String[] getPredecessorTypesAsString() {
        return new String[]{"SS", "FS", "SF", "FF"};
    }

    public static Integer[] getPredecessorTypesAsInteger() {
        return new Integer[]{new Integer(3), new Integer(1), new Integer(2), new Integer(0)};
    }
}

