/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.financial;

import com.triloggroup.project.financial.FinancialSettings;
import java.text.NumberFormat;
import java.util.Locale;

public abstract class AbstractFinancialHealth {
    public static final int STATUS_INBUDGET = 1;
    public static final int STATUS_WARNING = 2;
    public static final int STATUS_CRITICAL = 3;
    protected double actualCost = 0.0;
    protected double projectedCost = 0.0;
    private int status = 0;

    public abstract double getBudget();

    public abstract boolean isBudgetComputed();

    protected abstract String getCostLabel(double var1, Locale var3);

    public abstract String getCurrencySymbol();

    public String getHealthColor() {
        if (this.status == 1) {
            return "#66CC99";
        }
        if (this.status == 2) {
            return "#FFCC66";
        }
        if (this.status == 3) {
            return "#FF3333";
        }
        return "#66CC99";
    }

    public int getStatus() {
        return this.status;
    }

    public double getActualCost() {
        return this.actualCost;
    }

    public double getProjectedCost() {
        return this.projectedCost;
    }

    public String getActualCostLabel(Locale locale) {
        return this.getCostLabel(this.actualCost, locale);
    }

    public String getProjectedCostLabel(Locale locale) {
        return this.getCostLabel(this.projectedCost, locale);
    }

    public String getBudgetLabel(Locale locale) {
        return this.getCostLabel(this.getBudget(), locale);
    }

    protected String getCostLabelForFinancialSettings(double d, FinancialSettings financialSettings, Locale locale) {
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        int n = 0;
        numberFormat.setMaximumFractionDigits(n);
        numberFormat.setMinimumFractionDigits(n);
        String string = numberFormat.format(d);
        return string;
    }

    protected void initStatus(double d, double d2, FinancialSettings financialSettings) {
        this.status = AbstractFinancialHealth.computeStatus(d, d2, financialSettings);
    }

    public static int computeStatus(double d, double d2, FinancialSettings financialSettings) {
        double d3;
        if (d == 0.0) {
            return d2 > 0.0 ? 3 : 1;
        }
        if (d < 0.0) {
            if (d2 >= 0.0) {
                return 3;
            }
            d3 = d / d2 - 1.0;
        } else {
            d3 = d2 / d - 1.0;
        }
        if (d3 > financialSettings.getCriticalThreshold()) {
            return 3;
        }
        if (d3 > financialSettings.getWarningThreshold()) {
            return 2;
        }
        return 1;
    }
}

