/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.ui.table;

import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.project.components.ui.UIConstants;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.project.components.ui.table.ITGTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class TextCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private JTextField tf;
    protected boolean selectAll;
    private boolean forceSelectAll = false;
    private int clickCountToStart = 1;
    protected boolean checkInvalidCharacters = false;
    protected static Border DEFAULT_BORDER = LineBorder.createBlackLineBorder();
    protected static Border ERROR_BORDER = new LineBorder(Color.RED);

    public TextCellEditor() {
        this(new JTextField());
    }

    public TextCellEditor(JTextField jTextField) {
        this.tf = jTextField;
        this.tf.addActionListener(this);
    }

    public void setClickCountToStart(int n) {
        this.clickCountToStart = n;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public void setForceSelectAll(boolean bl) {
        this.forceSelectAll = bl;
    }

    public boolean isForceSelectAll() {
        return this.forceSelectAll;
    }

    protected JTextField getTextComponent() {
        return this.tf;
    }

    public Object getCellEditorValue() {
        return this.tf.getText();
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject == null) {
            this.selectAll = true;
            return true;
        }
        if (eventObject instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            if (mouseEvent.isControlDown() || mouseEvent.isShiftDown()) {
                return false;
            }
            this.selectAll = false;
            return mouseEvent.getClickCount() == this.clickCountToStart;
        }
        if (eventObject instanceof KeyEvent) {
            if (!TextCellEditor.isKeyEventTriggerEdit((KeyEvent)eventObject)) {
                return false;
            }
            this.selectAll = true;
        } else {
            this.selectAll = false;
        }
        return true;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        TableModel tableModel = jTable.getModel();
        if (tableModel instanceof ITGTableModel) {
            boolean bl2 = ((ITGTableModel)tableModel).isLeaf(n);
            this.tf.setFont(bl2 ? UIConstants.DEFAULT_FONT : UIConstants.BOLD_FONT);
        }
        this.tf.setBorder(DEFAULT_BORDER);
        this.tf.setText(this.getTextValue(jTable, object, bl, n, n2));
        if (this.forceSelectAll || this.selectAll) {
            this.tf.selectAll();
        }
        return this.tf;
    }

    protected String getTextValue(JTable jTable, Object object, boolean bl, int n, int n2) {
        return object == null ? "" : object.toString();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.stopCellEditing();
    }

    public boolean stopCellEditing() {
        return this.checkValid() && super.stopCellEditing();
    }

    protected boolean checkValid() {
        if (!this.checkInvalidCharacters) {
            return true;
        }
        String string = Workbench.checkInvalidCharacters(this.tf.getText());
        if (string != null) {
            WDDialog.showMsgDialog(this.tf, string);
            return false;
        }
        return true;
    }

    public boolean isCheckInvalidCharacters() {
        return this.checkInvalidCharacters;
    }

    public void setCheckInvlaidCharacters(boolean bl) {
        this.checkInvalidCharacters = bl;
    }

    public static boolean isKeyEventTriggerEdit(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 113 && keyEvent.getModifiers() == 0) {
            return true;
        }
        char c = keyEvent.getKeyChar();
        return Character.isLetterOrDigit(c) || Character.isWhitespace(c) || c == '.' || c == ',' || c == '-';
    }
}

