/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.ui.table;

import com.triloggroup.project.components.ui.IView;
import com.triloggroup.project.components.ui.UIConstants;
import com.triloggroup.project.components.ui.table.ITGTableModel;
import com.triloggroup.project.components.ui.table.TGTable;
import java.awt.Color;
import java.lang.reflect.Array;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class TGTableCellRenderer
extends DefaultTableCellRenderer {
    protected static final Border EMPTY_BORDER = new EmptyBorder(1, 1, 1, 1);

    public TGTableCellRenderer() {
        this(10);
    }

    public TGTableCellRenderer(int n) {
        this.setHorizontalAlignment(n);
    }

    public JComponent getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        bl = jTable.isRowSelected(n);
        TableModel tableModel = jTable.getModel();
        if (tableModel instanceof ITGTableModel) {
            ITGTableModel iTGTableModel = (ITGTableModel)tableModel;
            bl6 = iTGTableModel.isEditable();
            bl5 = iTGTableModel.isLeaf(n);
            bl4 = iTGTableModel.isValidElement(n);
        } else {
            bl6 = true;
            bl5 = true;
            bl4 = true;
        }
        boolean bl7 = bl3 = bl6 && tableModel.isCellEditable(n, jTable.convertColumnIndexToModel(n2));
        if (bl) {
            boolean bl8 = false;
            if (jTable instanceof TGTable) {
                IView iView = ((TGTable)jTable).getView();
                bl8 = iView != null && !iView.hasFocus();
            }
            this.setForeground(bl4 ? jTable.getSelectionForeground() : UIConstants.INVALID_ROW_FOREGROUND);
            if (bl8) {
                this.setBackground(jTable.getBackground());
            } else if (!bl3) {
                this.setBackground(UIConstants.READONLY_SELECTED_CELL_BACKGROUND_COLOR);
            } else {
                this.setBackground(jTable.getSelectionBackground());
            }
        } else {
            this.setForeground(bl4 ? jTable.getForeground() : UIConstants.INVALID_ROW_FOREGROUND);
            this.setBackground(jTable.getBackground());
        }
        if (bl5) {
            this.setFont(UIConstants.DEFAULT_FONT);
        } else {
            this.setFont(UIConstants.BOLD_FONT);
        }
        if (bl2 && bl6) {
            Color color = bl3 ? UIConstants.EDITABLE_CELL_BORDER_COLOR : UIConstants.READONLY_CELL_BORDER_COLOR;
            this.setBorder(BorderFactory.createLineBorder(color));
        } else {
            this.setBorder(EMPTY_BORDER);
        }
        this.setValue(object);
        return this;
    }

    protected void setValue(Object object) {
        String string = null;
        if (object == null) {
            this.setText("");
        } else if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            if (n == 0) {
                this.setText("");
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < n; ++i) {
                    Object object2;
                    if (i > 0) {
                        stringBuilder.append(", ");
                    }
                    if ((object2 = Array.get(object, i)) == null) continue;
                    stringBuilder.append(object2);
                }
                this.setText(stringBuilder.toString());
            }
        } else {
            String string2 = object.toString();
            int n = string2.indexOf(10);
            if (n > -1) {
                string = string2;
                string2 = string2.substring(0, n) + " (...)";
            }
            this.setText(string2);
        }
        this.setToolTipText(string);
    }
}

