/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.ui.table;

import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.project.components.ui.table.TextCellEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public abstract class AutoCompleteEditor
extends DefaultCellEditor {
    private static int DEFAULT_SEARCH_DELAY = 500;
    private static final int MAX_DIRECTORY_SEARCH_RESULT_ON_SERVER = 100;
    private Object initialValue;
    private volatile boolean active;
    protected Object newValue;
    protected boolean selectAll;
    protected boolean trimText = false;
    protected volatile AutoCompleteThread currentSearch;
    protected volatile Thread delayedAutoCompleteThread;
    protected Map<String, Object[]> searchResults = null;
    private boolean inStopCellEditing = false;

    protected abstract Object[] search(String var1) throws Exception;

    protected boolean equivalent(Object object, String string) {
        return false;
    }

    protected String getText() {
        String string = this.getTextField().getText();
        return this.trimText ? string.trim() : string;
    }

    protected Object[] filter(Object[] objectArray, String string, String string2) {
        return null;
    }

    protected ListCellRenderer createRenderer() {
        return null;
    }

    public AutoCompleteEditor() {
        super(AutoCompleteComboBox.createComboBox());
        ((AutoCompleteComboBox)this.getCombo()).setAutoCompleteEditor(this);
        this.getCombo().removeActionListener(this.delegate);
        ListCellRenderer listCellRenderer = this.createRenderer();
        if (listCellRenderer != null) {
            this.getCombo().setRenderer(listCellRenderer);
        }
        TextField textField = this.getTextField();
        textField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 32: {
                        if (!keyEvent.isControlDown() || AutoCompleteEditor.this.currentSearch != null && AutoCompleteEditor.this.currentSearch.text.equals(AutoCompleteEditor.this.getText())) break;
                        AutoCompleteEditor.this.runAutoComplete(false);
                        keyEvent.consume();
                        break;
                    }
                    case 9: 
                    case 10: {
                        Object object = AutoCompleteEditor.this.getCombo().getSelectedItem();
                        String string = AutoCompleteEditor.this.getText();
                        if (string.equals(AutoCompleteEditor.this.initialValue)) {
                            keyEvent.consume();
                            AutoCompleteEditor.this.cancelCellEditing();
                            break;
                        }
                        if (object != null && AutoCompleteEditor.this.equivalent(object, string)) {
                            AutoCompleteEditor.this.selectValue(object);
                            keyEvent.consume();
                            break;
                        }
                        if (AutoCompleteEditor.this.currentSearch != null && AutoCompleteEditor.this.currentSearch.text.equals(string)) {
                            Object[] objectArray = AutoCompleteEditor.this.currentSearch.result;
                            if (objectArray == null) {
                                AutoCompleteEditor.this.currentSearch.stopCellEditingRequested = true;
                                keyEvent.consume();
                                break;
                            }
                            for (int i = 0; i < objectArray.length; ++i) {
                                if (!AutoCompleteEditor.this.equivalent(objectArray[i], string)) continue;
                                AutoCompleteEditor.this.selectValue(objectArray[i]);
                                keyEvent.consume();
                                return;
                            }
                            AutoCompleteEditor.this.selectValueForText(string);
                            keyEvent.consume();
                            break;
                        }
                        AutoCompleteEditor.this.runAutoComplete(true);
                        keyEvent.consume();
                    }
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        textField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                String string;
                if (!(AutoCompleteEditor.this.getCombo().getSelectedItem() != null && AutoCompleteEditor.this.equivalent(AutoCompleteEditor.this.getCombo().getSelectedItem(), AutoCompleteEditor.this.getText()) || (string = AutoCompleteEditor.this.getText()).length() < 2 || AutoCompleteEditor.this.equivalent(AutoCompleteEditor.this.getCombo().getSelectedItem(), AutoCompleteEditor.this.getText()))) {
                    AutoCompleteEditor.this.searchOnClientfirstThenAutoCompleteDelayed();
                }
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                if (AutoCompleteEditor.this.getCombo().getSelectedItem() == null || !"".equals(AutoCompleteEditor.this.getText())) {
                    String string = AutoCompleteEditor.this.getText();
                    if (string.length() >= 2) {
                        AutoCompleteEditor.this.searchOnClientfirstThenAutoCompleteDelayed();
                    } else {
                        AutoCompleteEditor.this.interruptAndResetAllThreads();
                    }
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
    }

    public boolean isClientSearchEnabled() {
        return this.searchResults != null;
    }

    public void setClientSearchEnabled(boolean bl) {
        this.searchResults = bl ? Collections.synchronizedMap(new HashMap()) : null;
    }

    private Object[] doSearch(String string, boolean bl) throws Exception {
        if (this.isClientSearchEnabled()) {
            Object[] objectArray = this.searchResults.get(string);
            if (objectArray != null) {
                return objectArray;
            }
            String string2 = string;
            while (string2.length() > 1) {
                objectArray = this.searchResults.get(string2 = string2.substring(0, string2.length() - 1));
                if (objectArray == null) continue;
                objectArray = this.filter(objectArray, string2, string);
                break;
            }
            if (bl) {
                return objectArray;
            }
            if (objectArray == null) {
                objectArray = this.search(string);
            }
            if (objectArray == null || objectArray.length < 100) {
                this.searchResults.put(string, objectArray);
            }
            return objectArray;
        }
        if (!bl) {
            return this.search(string);
        }
        return null;
    }

    protected TextField getTextField() {
        return (TextField)this.getCombo().getEditor().getEditorComponent();
    }

    protected JComboBox getCombo() {
        return (JComboBox)this.getComponent();
    }

    public Object getCellEditorValue() {
        return this.newValue;
    }

    public boolean isCellEditable(EventObject eventObject) {
        boolean bl = this.selectAll = eventObject == null || eventObject instanceof KeyEvent;
        if (eventObject == null) {
            return true;
        }
        if (eventObject instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            if (mouseEvent.isControlDown() || mouseEvent.isShiftDown()) {
                return false;
            }
            return mouseEvent.getClickCount() == this.clickCountToStart;
        }
        if (eventObject instanceof KeyEvent) {
            return TextCellEditor.isKeyEventTriggerEdit((KeyEvent)eventObject);
        }
        return true;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.active = true;
        this.initialValue = object;
        Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        if (this.selectAll) {
            this.getTextField().selectAll();
        }
        return component;
    }

    protected void searchOnClientfirstThenAutoCompleteDelayed() {
        if (this.delayedAutoCompleteThread != null) {
            this.delayedAutoCompleteThread.interrupt();
        }
        String string = this.getText();
        try {
            Object[] objectArray = this.doSearch(string, true);
            if (objectArray != null && objectArray.length > 0) {
                this.setPopupVisible(false);
                AutoCompleteComboBoxModel autoCompleteComboBoxModel = (AutoCompleteComboBoxModel)this.getCombo().getModel();
                autoCompleteComboBoxModel.removeAllElements();
                autoCompleteComboBoxModel.setSearchText(string);
                for (int i = 0; i < objectArray.length; ++i) {
                    autoCompleteComboBoxModel.addElement(objectArray[i]);
                }
                this.setPopupVisible(true);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.doRunAutoCompleteDelayed();
    }

    protected void doRunAutoCompleteDelayed() {
        if (this.delayedAutoCompleteThread != null) {
            this.delayedAutoCompleteThread.interrupt();
        }
        this.delayedAutoCompleteThread = new Thread("runAutoComplete delay"){

            public void run() {
                try {
                    3.sleep(DEFAULT_SEARCH_DELAY);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                if (AutoCompleteEditor.this.active && AutoCompleteEditor.this.delayedAutoCompleteThread == this) {
                    AutoCompleteEditor.this.runAutoComplete(false);
                }
                AutoCompleteEditor.this.delayedAutoCompleteThread = null;
            }
        };
        this.delayedAutoCompleteThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runAutoComplete(boolean bl) {
        AutoCompleteThread autoCompleteThread;
        String string = this.getText();
        Serializable serializable = this;
        synchronized (serializable) {
            if (!this.active) {
                return;
            }
            if (this.currentSearch != null) {
                if (this.currentSearch.text.equals(string)) {
                    return;
                }
                this.currentSearch.interrupt();
                this.currentSearch = null;
            }
            if (string.length() == 0) {
                this.setPopupVisible(false);
                return;
            }
            this.currentSearch = autoCompleteThread = new AutoCompleteThread(string, bl);
        }
        serializable = (AutoCompleteComboBoxModel)this.getCombo().getModel();
        ((AutoCompleteComboBoxModel)serializable).removeAllElements();
        ((AutoCompleteComboBoxModel)serializable).addElement(new DisplayItem(Workbench.getNLSString("loading", new Object[0])));
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (AutoCompleteEditor.this.active && AutoCompleteEditor.this.currentSearch == autoCompleteThread) {
                        AutoCompleteEditor.this.setPopupVisible(true);
                    }
                }
            });
        } else {
            this.setPopupVisible(true);
        }
        if (this.active && this.currentSearch == autoCompleteThread) {
            autoCompleteThread.start();
        }
    }

    public boolean stopCellEditing() {
        if (this.newValue == null && !this.inStopCellEditing) {
            Object[] objectArray;
            Object object = this.getCombo().getSelectedItem();
            final String string = this.getText();
            if (string.equals(this.initialValue)) {
                this.cancelCellEditing();
                return true;
            }
            if (object != null && this.equivalent(object, string)) {
                this.newValue = object;
            } else if (this.currentSearch != null && this.currentSearch.text.equals(string) && (objectArray = this.currentSearch.result) != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!this.equivalent(objectArray[i], string)) continue;
                    this.newValue = objectArray[i];
                    break;
                }
                if (this.newValue == null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            AutoCompleteEditor.this.inStopCellEditing = true;
                            try {
                                AutoCompleteEditor.this.selectValueForText(string);
                            }
                            finally {
                                AutoCompleteEditor.this.inStopCellEditing = false;
                            }
                        }
                    });
                }
                return false;
            }
        }
        if (this.newValue != null) {
            return super.stopCellEditing();
        }
        this.cancelCellEditing();
        return true;
    }

    protected void selectValue(Object object) {
        this.newValue = object;
        if (object != null) {
            super.stopCellEditing();
        }
    }

    protected void selectValueForText(String string) {
    }

    protected String getStringValue(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    protected boolean acceptUniqueValue(Object object, String string) {
        return false;
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.active = false;
        this.interruptAndResetAllThreads();
        super.removeCellEditorListener(cellEditorListener);
    }

    protected void interruptAndResetAllThreads() {
        if (this.delayedAutoCompleteThread != null) {
            this.delayedAutoCompleteThread.interrupt();
            this.delayedAutoCompleteThread = null;
        }
        if (this.currentSearch != null) {
            this.currentSearch.interrupt();
            this.currentSearch = null;
        }
        this.setPopupVisible(false);
    }

    protected void setPopupVisible(boolean bl) {
        if (bl && !this.getCombo().isShowing()) {
            return;
        }
        this.getCombo().setPopupVisible(bl);
    }

    protected static class AutoCompleteComboBox
    extends JComboBox {
        private AutoCompleteEditor autoCompEditor;

        public static AutoCompleteComboBox createComboBox() {
            AutoCompleteComboBox autoCompleteComboBox = new AutoCompleteComboBox();
            autoCompleteComboBox.updateUI();
            autoCompleteComboBox.setEditable(true);
            return autoCompleteComboBox;
        }

        protected AutoCompleteComboBox() {
            this.setModel(new AutoCompleteComboBoxModel());
        }

        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            if (this.autoCompEditor.getText().length() == 0 || this.getSelectedItem() != null && this.getSelectedItem().equals(this.autoCompEditor.getText()) && this.getItemCount() <= 1) {
                return this.autoCompEditor.getTextField().processKeyBinding(keyStroke, keyEvent, n, bl);
            }
            return super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }

        protected void setAutoCompleteEditor(AutoCompleteEditor autoCompleteEditor) {
            this.autoCompEditor = autoCompleteEditor;
        }

        protected AutoCompleteEditor getAutoCompleteEditor() {
            return this.autoCompEditor;
        }

        public void updateUI() {
            this.setUI(new ComboBoxCellEditorUI());
        }

        public Component add(Component component) {
            if (component != null) {
                return super.add(component);
            }
            return null;
        }

        public void setSelectedItem(Object object) {
            if (object instanceof UnselectableItem) {
                return;
            }
            super.setSelectedItem(object);
        }

        public void configureEditor(ComboBoxEditor comboBoxEditor, Object object) {
            comboBoxEditor.setItem(object);
        }
    }

    public static class AutoCompleteComboBoxEditor
    extends BasicComboBoxEditor {
        private AutoCompleteComboBox comboBox;

        public AutoCompleteComboBoxEditor(AutoCompleteComboBox autoCompleteComboBox) {
            this.editor = this.createEditorComponent();
            this.editor.setBorder(null);
            this.comboBox = autoCompleteComboBox;
        }

        protected JTextField createEditorComponent() {
            TextField textField = new TextField("", 9);
            textField.setBorder(null);
            return textField;
        }

        public void setItem(Object object) {
            if (object instanceof UnselectableItem) {
                return;
            }
            if (object == null) {
                return;
            }
            this.editor.setText(this.comboBox.getAutoCompleteEditor().getStringValue(object));
        }

        public Object getItem() {
            String string = this.editor.getText();
            return new DisplayItem(string);
        }
    }

    protected static class AutoCompleteComboBoxModel
    extends AbstractListModel
    implements MutableComboBoxModel {
        protected Vector<Object> objects = new Vector();
        protected Object selectedObject;
        protected String searchText;

        public void setSelectedItem(Object object) {
            if (object instanceof UnselectableItem) {
                return;
            }
            if (this.selectedObject != null && !this.selectedObject.equals(object) || this.selectedObject == null && object != null) {
                this.selectedObject = object;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            return this.selectedObject;
        }

        public int getSize() {
            return this.objects.size();
        }

        public Object getElementAt(int n) {
            if (n >= 0 && n < this.objects.size()) {
                return this.objects.elementAt(n);
            }
            return null;
        }

        public int getIndexOf(Object object) {
            return this.objects.indexOf(object);
        }

        public void addElement(Object object) {
            this.objects.addElement(object);
            this.fireIntervalAdded(this, this.objects.size() - 1, this.objects.size() - 1);
        }

        public void insertElementAt(Object object, int n) {
            this.objects.insertElementAt(object, n);
            this.fireIntervalAdded(this, n, n);
        }

        public void removeElementAt(int n) {
            this.objects.removeElementAt(n);
            this.fireIntervalRemoved(this, n, n);
        }

        public void removeElement(Object object) {
            int n = this.objects.indexOf(object);
            if (n != -1) {
                this.removeElementAt(n);
            }
        }

        public void removeAllElements() {
            if (this.objects.size() > 0) {
                this.objects.removeAllElements();
                this.selectedObject = null;
            } else {
                this.selectedObject = null;
            }
            this.searchText = null;
        }

        public String getSearchText() {
            return this.searchText;
        }

        void setSearchText(String string) {
            this.searchText = string;
        }
    }

    public static class AutoCompleteComboPopup
    extends BasicComboPopup {
        public AutoCompleteComboPopup(JComboBox jComboBox) {
            super(jComboBox);
        }

        public void show() {
            this.setListSelection(this.comboBox.getSelectedIndex());
            Point point = this.getPopupLocation();
            this.show(this.comboBox, point.x, point.y);
        }

        private void setListSelection(int n) {
            if (n == -1) {
                this.list.clearSelection();
            } else {
                this.list.setSelectedIndex(n);
                this.list.ensureIndexIsVisible(n);
            }
        }

        private Point getPopupLocation() {
            Cloneable cloneable;
            Dimension dimension = this.comboBox.getSize();
            Dimension dimension2 = this.list.getPreferredSize();
            int n = dimension.width;
            if (this.scroller.getVerticalScrollBar().isEnabled()) {
                dimension2.width += this.scroller.getVerticalScrollBar().getWidth();
            }
            if ((n = Math.max(dimension2.width, dimension.width)) == dimension.width) {
                cloneable = this.getInsets();
                n = dimension.width - (((Insets)cloneable).right + ((Insets)cloneable).left);
            }
            dimension.setSize(n, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
            cloneable = this.computePopupBounds(0, this.comboBox.getBounds().height, n, dimension.height);
            Dimension dimension3 = ((Rectangle)cloneable).getSize();
            Point point = ((Rectangle)cloneable).getLocation();
            this.scroller.setMaximumSize(dimension3);
            this.scroller.setPreferredSize(dimension3);
            this.scroller.setMinimumSize(dimension3);
            this.list.revalidate();
            return point;
        }
    }

    protected class AutoCompleteThread
    extends Thread {
        String text;
        boolean stopCellEditingRequested;
        Object[] result = null;

        AutoCompleteThread(String string, boolean bl) {
            this.text = string;
            this.stopCellEditingRequested = bl;
        }

        public void run() {
            this.result = null;
            try {
                this.result = AutoCompleteEditor.this.doSearch(this.text, false);
                if (!AutoCompleteEditor.this.active || AutoCompleteThread.interrupted()) {
                    throw new InterruptedException();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AutoCompleteThread.this.showResult(AutoCompleteThread.this.stopCellEditingRequested);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AutoCompleteThread.this.searchFailed(exception);
                    }
                });
            }
        }

        protected void searchFailed(Throwable throwable) {
            this.showResult(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void showResult(boolean bl) {
            if (!AutoCompleteEditor.this.active) {
                return;
            }
            if (this.result == null) {
                this.result = new Object[0];
            }
            AutoCompleteThread autoCompleteThread = this;
            synchronized (autoCompleteThread) {
                if (AutoCompleteEditor.this.currentSearch != this) {
                    return;
                }
                AutoCompleteEditor.this.setPopupVisible(false);
                AutoCompleteComboBoxModel autoCompleteComboBoxModel = (AutoCompleteComboBoxModel)AutoCompleteEditor.this.getCombo().getModel();
                autoCompleteComboBoxModel.removeAllElements();
                if (this.result.length == 0) {
                    autoCompleteComboBoxModel.addElement(new DisplayItem(Workbench.getNLSString("no_results", new Object[0])));
                } else {
                    autoCompleteComboBoxModel.setSearchText(this.text);
                    for (int i = 0; i < this.result.length; ++i) {
                        autoCompleteComboBoxModel.addElement(this.result[i]);
                    }
                }
                AutoCompleteEditor.this.setPopupVisible(true);
                if (bl) {
                    if (this.result.length == 0) {
                        AutoCompleteEditor.this.selectValueForText(this.text);
                    } else if (this.result.length == 1 && AutoCompleteEditor.this.acceptUniqueValue(this.result[0], this.text)) {
                        AutoCompleteEditor.this.selectValue(this.result[0]);
                    }
                }
            }
        }
    }

    protected static class ComboBoxCellEditorUI
    extends BasicComboBoxUI {
        protected ComboBoxCellEditorUI() {
        }

        protected ComboPopup createPopup() {
            return new AutoCompleteComboPopup(this.comboBox);
        }

        protected JButton createArrowButton() {
            return null;
        }

        protected ComboBoxEditor createEditor() {
            return new AutoCompleteComboBoxEditor((AutoCompleteComboBox)this.comboBox);
        }

        protected void installListeners() {
            super.installListeners();
            this.listBox.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    int n = ComboBoxCellEditorUI.this.popup.getList().getSelectedIndex();
                    if (n != -1 && n < ComboBoxCellEditorUI.this.comboBox.getItemCount()) {
                        ComboBoxCellEditorUI.this.comboBox.setSelectedIndex(n);
                    }
                }
            });
            this.listBox.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent mouseEvent) {
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                }

                public void mouseExited(MouseEvent mouseEvent) {
                }

                public void mousePressed(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    Object object;
                    if (mouseEvent.getSource() == ComboBoxCellEditorUI.this.listBox && ComboBoxCellEditorUI.this.listBox.getModel().getSize() > 0 && (object = ComboBoxCellEditorUI.this.comboBox.getSelectedItem()) != null) {
                        ((AutoCompleteComboBox)ComboBoxCellEditorUI.this.comboBox).getAutoCompleteEditor().selectValue(object);
                        mouseEvent.consume();
                    }
                }
            });
        }

        public void focusLost(FocusEvent focusEvent) {
            ComboBoxEditor comboBoxEditor = this.comboBox.getEditor();
            if (comboBoxEditor != null && focusEvent.getSource() == comboBoxEditor.getEditorComponent()) {
                Object object = comboBoxEditor.getItem();
                Object object2 = this.comboBox.getSelectedItem();
                if (!focusEvent.isTemporary() && object != null && !object.equals(object2 == null ? "" : object2)) {
                    this.comboBox.actionPerformed(new ActionEvent(comboBoxEditor, 0, "", EventQueue.getMostRecentEventTime(), 0));
                }
            }
            this.hasFocus = false;
            if (!focusEvent.isTemporary()) {
                this.setPopupVisible(this.comboBox, false);
            }
            this.comboBox.repaint();
            ((AutoCompleteComboBox)this.comboBox).getAutoCompleteEditor().cancelCellEditing();
        }
    }

    public static class DisplayItem
    implements UnselectableItem {
        private String label;

        public DisplayItem(String string) {
            this.label = string;
        }

        public String toString() {
            return this.label;
        }
    }

    public static class TextField
    extends JTextField {
        public TextField(String string, int n) {
            super(string, n);
        }

        public boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            return super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }
    }

    public static interface UnselectableItem {
    }
}

