/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.st;

import com.flowbuilder.util.TString;
import com.triloggroup.gantt.Resource;
import com.triloggroup.project.components.resourceeditor.ProjectResource;
import com.triloggroup.util.UString;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class SametimeSupport {
    public static boolean ENABLED = false;
    private boolean debug = true;
    private Icon[] icons;
    private boolean stLocalWebServerStarted;
    private String baseUrl;

    public void init() {
        String string = "http://localhost:59449/stwebapi/";
        if (!this.callUrl(string + "listservices") && !this.callUrl((string = "https://localhost:59669/stwebapi/") + "listservices")) {
            string = null;
        }
        if (string != null) {
            this.baseUrl = string;
            this.stLocalWebServerStarted = true;
            this.icons = new Icon[6];
            this.icons[1] = new ImageIcon(this.getClass().getResource("/com/triloggroup/project/components/st/resources/active.gif"));
            this.icons[2] = new ImageIcon(this.getClass().getResource("/com/triloggroup/project/components/st/resources/away.gif"));
            this.icons[3] = new ImageIcon(this.getClass().getResource("/com/triloggroup/project/components/st/resources/dnd.gif"));
            this.icons[5] = new ImageIcon(this.getClass().getResource("/com/triloggroup/project/components/st/resources/meeting.gif"));
        } else {
            this.baseUrl = null;
            this.stLocalWebServerStarted = false;
        }
    }

    public Icon getIcon(int n) {
        if (this.icons == null) {
            return null;
        }
        return this.icons[n];
    }

    public boolean isEnabled() {
        return this.stLocalWebServerStarted;
    }

    public Status getStatus(Resource resource) {
        return this.callSametime(resource);
    }

    public void chat(Resource resource) {
        String string = this.getId(resource);
        if (UString.isEmpty(string)) {
            return;
        }
        try {
            String string2 = this.baseUrl + "chat?userId=" + URLEncoder.encode(string, "UTF-8");
            this.callUrl(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void call(Resource resource) {
    }

    private String getId(Resource resource) {
        if (resource instanceof ProjectResource && ((ProjectResource)resource).isRegistered()) {
            return this.encodeDN(resource.getDn());
        }
        return resource.getEmail();
    }

    private String encodeDN(String string) {
        StringBuilder stringBuilder = null;
        boolean bl = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case '\"': 
                case '\'': 
                case '\\': {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder(string.substring(0, i));
                    }
                    stringBuilder.append('\\').append(c);
                    break;
                }
                case ',': {
                    if (!bl) {
                        if (stringBuilder == null) {
                            stringBuilder = new StringBuilder(string.substring(0, i));
                        }
                        stringBuilder.append('/');
                        break;
                    }
                    if (stringBuilder == null) break;
                    stringBuilder.append(c);
                    break;
                }
                case '/': {
                    if (stringBuilder == null) break;
                    stringBuilder.append(c);
                    break;
                }
                default: {
                    if (c < ' ' || c > '\u00ff') {
                        if (stringBuilder == null) {
                            stringBuilder = new StringBuilder(string.substring(0, i));
                        }
                        stringBuilder.append("\\u");
                        stringBuilder.append(TString.toUnsignedHex(c, 4));
                        break;
                    }
                    if (stringBuilder == null) break;
                    stringBuilder.append(c);
                }
            }
            bl = c == '\\' ? !bl : false;
        }
        return stringBuilder == null ? string : stringBuilder.toString();
    }

    private Status callSametime(Resource resource) {
        String string = this.baseUrl;
        String string2 = "getstatusshort";
        string = string + string2;
        String string3 = this.getId(resource);
        if (TString.isEmpty(string3)) {
            return Status.UNKNOWN;
        }
        URLConnection uRLConnection = null;
        try {
            int n;
            string = string + "?userId=" + URLEncoder.encode(string3, "UTF-8");
            URL uRL = new URL(string);
            uRLConnection = uRL.openConnection();
            if (uRLConnection instanceof HttpURLConnection && (n = ((HttpURLConnection)uRLConnection).getResponseCode()) != 200) {
                String string4 = ((HttpURLConnection)uRLConnection).getResponseMessage();
                System.out.println("Response msg: " + string4);
                throw new Exception("HttpURLConnection error: " + n + " - " + string4);
            }
            InputStream inputStream = uRLConnection.getInputStream();
            String string5 = this.read(inputStream);
            System.out.println("Response:");
            System.out.println(string5);
            int n2 = string5.indexOf("\"status\"");
            if (n2 >= 0) {
                char c = string5.charAt(n2 + 9);
                switch (c) {
                    case '1': {
                        return Status.AVAILABLE;
                    }
                    case '2': {
                        return Status.AWAY;
                    }
                    case '3': {
                        return Status.DO_NOT_DISTURB;
                    }
                    case '5': {
                        return Status.IN_A_MEETING;
                    }
                }
            }
            return Status.UNKNOWN;
        }
        catch (Exception exception) {
            if (uRLConnection instanceof HttpURLConnection) {
                InputStream inputStream = ((HttpURLConnection)uRLConnection).getErrorStream();
                String string6 = this.read(inputStream);
                System.out.println("content of errorStream = " + string6);
            } else {
                exception.printStackTrace();
            }
            return Status.UNKNOWN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean callUrl(String string) {
        InputStream inputStream = null;
        try {
            URL uRL = new URL(string);
            inputStream = uRL.openStream();
            byte[] byArray = new byte[255];
            int n = inputStream.read(byArray);
            boolean bl = n > 0;
            return bl;
        }
        catch (Exception exception) {
            if (this.debug) {
                exception.printStackTrace();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            block13: {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        if (!this.debug) break block13;
                        exception.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String read(InputStream inputStream) {
        StringBuilder stringBuilder = new StringBuilder();
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            char[] cArray = new char[512];
            int n = inputStreamReader.read(cArray);
            while (n != -1) {
                stringBuilder.append(cArray, 0, n);
                n = inputStreamReader.read(cArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        UNKNOWN(0),
        AVAILABLE(1),
        AWAY(2),
        DO_NOT_DISTURB(3),
        IN_A_MEETING(5);

        public final int code;

        private Status(int n2) {
            this.code = n2;
        }
    }
}

