/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.schedulecalendar;

import com.triloggroup.project.components.schedulecalendar.DayData;
import java.awt.Color;
import javax.swing.table.DefaultTableCellRenderer;

class DayRenderer
extends DefaultTableCellRenderer {
    private Color NULL_BACKGROUND = new Color(228, 228, 228);
    private Color NON_WORKING_BACKGROUND = Color.LIGHT_GRAY;
    private Color SELECTED_BACKGROUND = Color.BLACK;

    public DayRenderer() {
        this.setHorizontalAlignment(4);
        this.setVerticalAlignment(1);
    }

    protected void setValue(Object object) {
        DayData dayData = (DayData)object;
        if (object == null) {
            this.setText("");
            this.setBackground(this.NULL_BACKGROUND);
        } else {
            if (dayData.edited) {
                this.setText("<html><b><u>" + dayData.date + "</u></b></html>");
            } else {
                this.setText(String.valueOf(dayData.date));
            }
            if (dayData.selected) {
                this.setBackground(this.SELECTED_BACKGROUND);
                this.setForeground(Color.WHITE);
            } else {
                this.setBackground(dayData.isWorkingDay() ? Color.WHITE : this.NON_WORKING_BACKGROUND);
                this.setForeground(Color.BLACK);
            }
        }
    }
}

