/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.resourceeditor.table.costrate;

import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.project.components.resourceeditor.CostRate;
import com.triloggroup.project.components.resourceeditor.CostRateUnit;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.project.components.ui.table.TGTableCellRenderer;
import com.triloggroup.project.components.util.format.FormatUtil;
import com.triloggroup.project.financial.CostRates;
import com.triloggroup.project.financial.FinancialSettings;
import com.triloggroup.project.financial.ICostRate;
import com.triloggroup.project.financial.VariableCost;
import java.awt.Rectangle;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.JComponent;
import javax.swing.JTable;

public class CostRatesRenderer
extends TGTableCellRenderer {
    private static final boolean IS_ICON_LEFT = false;
    private static final String ICON_NAME = "dots.gif";
    private NumberFormat fmt;
    private boolean financialEditable;
    private FinancialSettings financialSettings;
    private Date now;
    private CostRates currentValue;

    public CostRatesRenderer(Locale locale, FinancialSettings financialSettings) {
        this.fmt = FormatUtil.getCostFormat(locale, financialSettings);
        this.financialSettings = financialSettings;
        this.setHorizontalAlignment(4);
        this.setHorizontalTextPosition(2);
    }

    public JComponent getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        this.setIcon(null);
        if (object == null) {
            this.setText("");
        } else {
            CostRates costRates = (CostRates)object;
            CostRate costRate = (CostRate)costRates.getCostRate(this.now != null ? this.now : new Date());
            StringBuilder stringBuilder = new StringBuilder();
            this.format(costRate, stringBuilder, false);
            if (costRates.hasVariableCostRateDefined()) {
                stringBuilder.append(" (").append(costRates.variableCosts.length + 1).append(')');
            }
            if (this.financialEditable && bl2) {
                this.setIcon(WDUtil.getIcon(ICON_NAME));
            }
            this.setText(stringBuilder.toString());
        }
        return this;
    }

    protected void setValue(Object object) {
        this.currentValue = (CostRates)object;
    }

    public void setReferenceDate(Date date) {
        this.now = date;
    }

    public void setFinancialEditable(boolean bl) {
        this.financialEditable = bl;
    }

    public void updateUI() {
        super.updateUI();
    }

    public String getToolTipText() {
        boolean bl;
        if (this.currentValue == null || !this.currentValue.hasVariableCostRateDefined()) {
            return null;
        }
        ICostRate iCostRate = this.currentValue.getCostRate(this.now != null ? this.now : new Date());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><table><tr><td></td><td>");
        boolean bl2 = bl = this.currentValue.defaultCost == iCostRate;
        if (bl) {
            stringBuilder.append("<b>");
        }
        this.format((CostRate)this.currentValue.defaultCost, stringBuilder, true);
        if (bl) {
            stringBuilder.append("</b>");
        }
        stringBuilder.append("</td></tr>");
        Locale locale = Workbench.get().getFormatLocale();
        TimeZone timeZone = Workbench.get().getTimeZone();
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        dateFormat.setTimeZone(timeZone);
        for (int i = 0; i < this.currentValue.variableCosts.length; ++i) {
            VariableCost variableCost = this.currentValue.variableCosts[i];
            bl = variableCost.costRate == iCostRate;
            stringBuilder.append("<tr><td>");
            if (bl) {
                stringBuilder.append("<b>");
            }
            stringBuilder.append(WDUtil.swingHtmlEscape(Workbench.getNLSString("fromDate", new Object[0])));
            stringBuilder.append(' ');
            stringBuilder.append(WDUtil.swingHtmlEscape(dateFormat.format(variableCost.from)));
            stringBuilder.append(':');
            if (bl) {
                stringBuilder.append("</b>");
            }
            stringBuilder.append("</td><td>");
            if (bl) {
                stringBuilder.append("<b>");
            }
            this.format((CostRate)variableCost.costRate, stringBuilder, true);
            if (bl) {
                stringBuilder.append("</b>");
            }
            stringBuilder.append("</td></tr>");
        }
        stringBuilder.append("</table></html>");
        return stringBuilder.toString();
    }

    private void format(CostRate costRate, StringBuilder stringBuilder, boolean bl) {
        CostRateUnit costRateUnit;
        String string = null;
        if (this.financialSettings != null) {
            if ("before".equals(this.financialSettings.getCurrencySymbolPlacement())) {
                this.append(stringBuilder, this.financialSettings.getCurrencySymbol(), bl);
                stringBuilder.append(' ');
            } else {
                string = this.financialSettings.getCurrencySymbol();
            }
        }
        this.append(stringBuilder, this.fmt.format(costRate.getCost()), bl);
        if (string != null) {
            stringBuilder.append(' ');
            this.append(stringBuilder, this.financialSettings.getCurrencySymbol(), bl);
        }
        if ((costRateUnit = costRate.getRateUnit()) != null) {
            stringBuilder.append(' ');
            this.append(stringBuilder, costRateUnit.label, bl);
        }
    }

    private void append(StringBuilder stringBuilder, String string, boolean bl) {
        stringBuilder.append(bl ? WDUtil.swingHtmlEscape(string) : string);
    }

    static boolean isLocationInEditHint(int n, int n2, Rectangle rectangle) {
        int n3 = WDUtil.getIcon(ICON_NAME).getIconWidth();
        return (double)n >= rectangle.getMaxX() - (double)n3;
    }
}

