/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.resourceeditor.table.costrate;

import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.treetable.DateEditor;
import com.triloggroup.gantt.app.ui.WDButton;
import com.triloggroup.gantt.app.ui.WDCmdButton;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.project.components.resourceeditor.CostRate;
import com.triloggroup.project.components.resourceeditor.ResourceView;
import com.triloggroup.project.components.resourceeditor.table.costrate.SimpleCostRateEditor;
import com.triloggroup.project.components.resourceeditor.table.costrate.SimpleCostRateRenderer;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.project.components.ui.table.DateTableCellRenderer;
import com.triloggroup.project.components.ui.table.ITGTableModel;
import com.triloggroup.project.components.ui.table.LeftLineBorder;
import com.triloggroup.project.components.ui.table.TGTable;
import com.triloggroup.project.financial.CostRates;
import com.triloggroup.project.financial.FinancialSettings;
import com.triloggroup.project.financial.ICostRate;
import com.triloggroup.project.financial.VariableCost;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

class CostRatesEditorDialog
extends WDDialog
implements ActionListener,
ListSelectionListener {
    protected static Icon addIcon = WDUtil.getIcon("table_add.gif");
    protected static Icon deleteIcon = WDUtil.getIcon("table_remove.gif");
    protected JTable table;
    protected DateTableCellRenderer dateRenderer;
    protected JPanel buttonsPanel;
    protected JButton addButton;
    protected JButton deleteButton;
    private WDButton okButton;
    private CostRates currentValue;
    private boolean editable;
    private ResourceView resourceView;

    public static CostRatesEditorDialog create(Component component) {
        Window window = SwingUtilities.getWindowAncestor(component);
        GraphicsConfiguration graphicsConfiguration = WDUtil.getGraphicsConfiguration(component);
        return new CostRatesEditorDialog(window, graphicsConfiguration);
    }

    protected CostRatesEditorDialog(Window window, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
    }

    public void init(CostRates costRates, boolean bl, ResourceView resourceView) {
        Serializable serializable;
        Object object;
        this.currentValue = costRates;
        this.editable = bl;
        this.resourceView = resourceView;
        this.table = new TGTable(new TableModel());
        Locale locale = Workbench.get().getFormatLocale();
        TimeZone timeZone = Workbench.get().getTimeZone();
        FinancialSettings financialSettings = resourceView.getProjectModel().getFinancialSettings();
        this.dateRenderer = new DateTableCellRenderer(locale, timeZone);
        this.table.setDefaultRenderer(Date.class, this.dateRenderer);
        this.table.setDefaultRenderer(ICostRate.class, new SimpleCostRateRenderer(locale, financialSettings));
        if (bl) {
            this.table.setDefaultEditor(Date.class, new DateEditor(locale));
            this.table.setDefaultEditor(ICostRate.class, new SimpleCostRateEditor(locale, financialSettings));
            object = new JPanel();
            ((Container)object).setLayout(new FlowLayout(0));
            this.addButton = new WDCmdButton(addIcon);
            this.deleteButton = new WDCmdButton(deleteIcon);
            this.deleteButton.setEnabled(false);
            this.addButton.addActionListener(this);
            this.deleteButton.addActionListener(this);
            ((Container)object).add(this.addButton);
            ((Container)object).add(this.deleteButton);
            this.getContentPane().add((Component)object, "North");
            this.table.getSelectionModel().addListSelectionListener(this);
        }
        object = new LeftLineBorder();
        this.table.setBorder((Border)object);
        this.table.getTableHeader().setBorder((Border)object);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        JPanel jPanel = new JPanel(new FlowLayout(1));
        this.okButton = WDUtil.createOkButton();
        jPanel.add(this.okButton);
        this.okButton.addActionListener(this);
        if (bl) {
            serializable = WDUtil.createCancelButton();
            jPanel.add((Component)serializable);
            serializable.addActionListener(this);
        }
        this.getContentPane().add((Component)jPanel, "South");
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.setDragHeader(true);
        this.setMaximizable(false);
        this.setResizable(true);
        serializable = new Dimension(this.table.getPreferredSize());
        if (bl) {
            int n = 5;
            if (this.table.getRowCount() < n) {
                ((Dimension)serializable).height = n * this.table.getRowHeight();
            }
            ((Dimension)serializable).width += 45;
        }
        this.table.setPreferredScrollableViewportSize((Dimension)serializable);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.addButton) {
            this.getTableModel().addRow();
            return;
        }
        if (object == this.deleteButton) {
            int[] nArray = this.table.getSelectedRows();
            this.getTableModel().deleteRows(nArray);
            return;
        }
        if (object == this.okButton) {
            TableCellEditor tableCellEditor = this.table.getCellEditor();
            if (tableCellEditor != null && !tableCellEditor.stopCellEditing()) {
                return;
            }
            Object[] objectArray = this.getTableModel().vcs.toArray(VariableCost.NO_VARIABLE_COSTS);
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length - 1; ++i) {
                if (!((VariableCost)objectArray[i]).from.equals(((VariableCost)objectArray[i + 1]).from)) continue;
                WDDialog.showMsgDialog(this, Workbench.getNLSString("date_defined_more_than_once", this.dateRenderer.getDateFormat().format(((VariableCost)objectArray[i]).from)));
                return;
            }
            this.currentValue = new CostRates(this.getTableModel().defaultCostRate, (VariableCost[])objectArray);
        } else {
            this.currentValue = null;
        }
        this.dispose();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl;
        int[] nArray = this.table.getSelectedRows();
        boolean bl2 = bl = nArray.length > 0;
        if (bl) {
            for (int n : nArray) {
                if (n != 0) continue;
                bl = false;
                break;
            }
        }
        this.deleteButton.setEnabled(bl);
    }

    private TableModel getTableModel() {
        return (TableModel)this.table.getModel();
    }

    public CostRates getSelectedValue() {
        return this.editable ? this.currentValue : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TableModel
    extends AbstractTableModel
    implements ITGTableModel {
        ICostRate defaultCostRate;
        final ArrayList<VariableCost> vcs;
        final String[] colNames;

        TableModel() {
            this.defaultCostRate = ((CostRatesEditorDialog)CostRatesEditorDialog.this).currentValue.defaultCost;
            this.vcs = new ArrayList();
            for (VariableCost variableCost : ((CostRatesEditorDialog)CostRatesEditorDialog.this).currentValue.variableCosts) {
                this.vcs.add(variableCost);
            }
            FinancialSettings financialSettings = CostRatesEditorDialog.this.resourceView.getProjectModel().getFinancialSettings();
            String string = AppGanttChart.NLS_BUNDLE.getString("CostRate") + " (" + financialSettings.getCurrencySymbol() + ')';
            this.colNames = new String[]{AppGanttChart.NLS_BUNDLE.getString("fromDate"), string};
        }

        @Override
        public String getColumnName(int n) {
            return this.colNames[n];
        }

        @Override
        public int getRowCount() {
            return this.vcs.size() + 1;
        }

        @Override
        public int getColumnCount() {
            return this.colNames.length;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Date.class;
            }
            if (n == 1) {
                return ICostRate.class;
            }
            return Object.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n == 0) {
                if (n2 == 1) {
                    return this.defaultCostRate;
                }
                return null;
            }
            if (n2 == 0) {
                return this.vcs.get((int)(n - 1)).from;
            }
            if (n2 == 1) {
                return this.vcs.get((int)(n - 1)).costRate;
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n == 0) {
                if (n2 == 1) {
                    this.defaultCostRate = (ICostRate)object;
                }
                return;
            }
            VariableCost variableCost = this.vcs.get(n - 1);
            if (n2 == 0) {
                variableCost = new VariableCost((Date)object, variableCost.costRate);
            } else if (n2 == 1) {
                variableCost = new VariableCost(variableCost.from, (ICostRate)object);
            }
            this.vcs.set(n - 1, variableCost);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return CostRatesEditorDialog.this.editable && (n > 0 || n2 == 1);
        }

        @Override
        public boolean isEditable() {
            return CostRatesEditorDialog.this.editable;
        }

        @Override
        public boolean isLeaf(int n) {
            return true;
        }

        @Override
        public boolean isValidElement(int n) {
            return true;
        }

        private void deleteRows(int[] nArray) {
            if (nArray.length > 0) {
                Arrays.sort(nArray);
                if (nArray[0] == 0) {
                    return;
                }
                for (int i = nArray.length - 1; i >= 0; --i) {
                    this.vcs.remove(nArray[i] - 1);
                }
                this.fireTableRowsDeleted(nArray[0] - 1, nArray[nArray.length - 1] - 1);
            }
        }

        private void addRow() {
            int n = this.vcs.size();
            this.vcs.add(this.getDefaultVariableCost());
            this.fireTableRowsInserted(n, n);
        }

        private VariableCost getDefaultVariableCost() {
            CostRate costRate;
            Workbench workbench = Workbench.get();
            GregorianCalendar gregorianCalendar = new GregorianCalendar(workbench.getTimeZone(), workbench.getFormatLocale());
            if (this.vcs.size() > 0) {
                VariableCost variableCost = this.vcs.get(this.vcs.size() - 1);
                CostRate costRate2 = (CostRate)variableCost.costRate;
                costRate = costRate2.clone();
                gregorianCalendar.setTime(variableCost.from);
                gregorianCalendar.set(5, 1);
                gregorianCalendar.add(2, 1);
            } else {
                costRate = ((CostRate)this.defaultCostRate).clone();
            }
            gregorianCalendar.set(11, 0);
            gregorianCalendar.set(12, 0);
            gregorianCalendar.set(13, 0);
            gregorianCalendar.set(14, 0);
            return new VariableCost(gregorianCalendar.getTime(), costRate);
        }
    }
}

