/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.resourceeditor.table;

import com.triloggroup.gantt.app.ui.WDButton;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.project.SecurityProfile;
import com.triloggroup.project.components.resourceeditor.NewRoleDialog;
import com.triloggroup.project.components.resourceeditor.ProjectRole;
import com.triloggroup.project.components.resourceeditor.ResourceView;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.project.components.ui.table.ComboEditorWithEditLink;
import com.triloggroup.util.UString;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RoleEditor
extends ComboEditorWithEditLink {
    private HashSet<ProjectRole> availableValues;
    private ResourceView resourceView;
    private Object valueToRemove;
    private JPanel editPanel;
    private JTextField textfield;
    private JComboBox securityProfileCombo;
    private WDButton saveButton;
    private Border defaultTextBorder;
    private Border errorTextBorder = new LineBorder(Color.red);
    private static Comparator<ProjectRole> ROLE_COMPARATOR_FOR_SELECT = new Comparator<ProjectRole>(){

        @Override
        public int compare(ProjectRole projectRole, ProjectRole projectRole2) {
            if (projectRole == null) {
                return projectRole2 == null ? 0 : 1;
            }
            if (projectRole2 == null) {
                return -1;
            }
            String string = projectRole.getId();
            String string2 = projectRole2.getId();
            if ("pe_teammember".equals(string)) {
                return "pe_teammember".equals(string2) ? 0 : -1;
            }
            if ("pe_teammember".equals(string2)) {
                return 1;
            }
            if ("pe_projectmanager".equals(string)) {
                return "pe_projectmanager".equals(string2) ? 0 : -1;
            }
            if ("pe_projectmanager".equals(string2)) {
                return 1;
            }
            return projectRole.compareTo(projectRole2);
        }
    };

    private static ProjectRole[] computeRoleList(ResourceView resourceView) {
        ProjectRole[] projectRoleArray = resourceView.getProjectModel().getProjectRoles();
        int n = 0;
        for (int i = 0; i < projectRoleArray.length; ++i) {
            ProjectRole projectRole = projectRoleArray[i];
            if (projectRole.isHidden()) {
                ++n;
                continue;
            }
            if (n <= 0) continue;
            projectRoleArray[i - n] = projectRole;
        }
        if (n > 0) {
            ProjectRole[] projectRoleArray2 = new ProjectRole[projectRoleArray.length - n];
            System.arraycopy(projectRoleArray, 0, projectRoleArray2, 0, projectRoleArray.length - n);
            projectRoleArray = projectRoleArray2;
        }
        Arrays.sort(projectRoleArray, ROLE_COMPARATOR_FOR_SELECT);
        return projectRoleArray;
    }

    public RoleEditor(ResourceView resourceView) {
        super(RoleEditor.computeRoleList(resourceView), Workbench.getNLSString("newRole", new Object[0]));
        this.resourceView = resourceView;
        ComboEditorWithEditLink.ComboBoxModel comboBoxModel = (ComboEditorWithEditLink.ComboBoxModel)((ComboEditorWithEditLink.InternalComboBox)this.editorComponent).getModel();
        Object[] objectArray = new ProjectRole[comboBoxModel.getSize()];
        objectArray = (ProjectRole[])comboBoxModel.getValues(objectArray);
        this.availableValues = new HashSet(objectArray.length);
        Collections.addAll(this.availableValues, objectArray);
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (this.valueToRemove != null) {
            ((JComboBox)this.editorComponent).removeItem(this.valueToRemove);
            this.valueToRemove = null;
        }
        if (object != null && !this.availableValues.contains(object)) {
            ((JComboBox)this.editorComponent).addItem(object);
            this.valueToRemove = object;
        }
        return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
    }

    protected JComponent getEditionPanel() {
        if (this.editPanel == null) {
            this.editPanel = new JPanel();
            this.editPanel.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel(Workbench.getNLSString("roleName", new Object[0]));
            this.editPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.textfield = new JTextField(30);
            this.editPanel.add((Component)this.textfield, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 5, 5), 0, 0));
            JLabel jLabel2 = new JLabel(Workbench.getNLSString("roleProfile", new Object[0]));
            this.editPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.securityProfileCombo = new JComboBox<SecurityProfile>(this.resourceView.getSecurityProfiles());
            this.editPanel.add((Component)this.securityProfileCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 5), 0, 0));
            ImageIcon imageIcon = WDUtil.getIcon("saveSmall.gif");
            this.saveButton = new WDButton(imageIcon);
            this.editPanel.add((Component)this.saveButton, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
            this.saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RoleEditor.this.setNewCreatedValue(RoleEditor.this.createNewRoleObject());
                }
            });
            this.defaultTextBorder = this.textfield.getBorder();
            this.textfield.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.resetTextFieldError();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.resetTextFieldError();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.resetTextFieldError();
                }

                protected void resetTextFieldError() {
                    if (!UString.isEmpty(RoleEditor.this.textfield.getToolTipText())) {
                        RoleEditor.this.textfield.setBorder(RoleEditor.this.defaultTextBorder);
                        RoleEditor.this.textfield.setToolTipText(null);
                    }
                }
            });
            KeyListener keyListener = new KeyListener(){

                public void keyPressed(KeyEvent keyEvent) {
                    switch (keyEvent.getKeyCode()) {
                        case 10: {
                            if (RoleEditor.this.securityProfileCombo.isPopupVisible()) break;
                            keyEvent.consume();
                            RoleEditor.this.setNewCreatedValue(RoleEditor.this.createNewRoleObject());
                            break;
                        }
                        case 27: {
                            if (RoleEditor.this.securityProfileCombo.isPopupVisible()) break;
                            keyEvent.consume();
                            RoleEditor.this.cancelEditionPanel();
                        }
                    }
                }

                public void keyReleased(KeyEvent keyEvent) {
                }

                public void keyTyped(KeyEvent keyEvent) {
                }
            };
            this.textfield.addKeyListener(keyListener);
            this.saveButton.addKeyListener(keyListener);
            this.securityProfileCombo.addKeyListener(keyListener);
        } else {
            this.textfield.setText("");
            this.textfield.setToolTipText(null);
            this.textfield.setBorder(this.defaultTextBorder);
        }
        return this.editPanel;
    }

    protected void showCreationPanel() {
        super.showCreationPanel();
        this.creationDialog.getContentPane().setFocusCycleRoot(true);
        this.creationDialog.getContentPane().setFocusTraversalPolicy(new PageFocusTraversalPolicy());
        this.textfield.requestFocus();
    }

    protected void setNewCreatedValue(Object object) {
        if (object != null && object instanceof ProjectRole) {
            this.creationDialog.setVisible(false);
            this.resourceView.addProjectRole((ProjectRole)object);
            this.availableValues.add((ProjectRole)object);
            ComboEditorWithEditLink.ComboBoxModel comboBoxModel = (ComboEditorWithEditLink.ComboBoxModel)((ComboEditorWithEditLink.InternalComboBox)this.editorComponent).getModel();
            comboBoxModel.insertElementAt(object, 0);
            comboBoxModel.setSelectedItem(object);
            ((ComboEditorWithEditLink.InternalComboBox)this.editorComponent).hidePopup();
            this.stopCellEditing();
        }
    }

    protected ProjectRole createNewRoleObject() {
        ProjectRole projectRole = null;
        String string = UString.trim(this.textfield.getText());
        String string2 = NewRoleDialog.isValidRoleName(string, this.resourceView.getProjectModel());
        if (string2 != null) {
            this.textfield.setBorder(this.errorTextBorder);
            this.textfield.requestFocus();
            this.textfield.setToolTipText(string2);
        } else {
            projectRole = new ProjectRole(NewRoleDialog.generateRoleId(), string, false, this.resourceView.getProjectModel().getProjectContext());
            projectRole.setSecurityProfileId(((SecurityProfile)this.securityProfileCombo.getSelectedItem()).getId());
        }
        return projectRole;
    }

    private class PageFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private PageFocusTraversalPolicy() {
        }

        public Component getComponentAfter(Container container, Component component) {
            if (component == RoleEditor.this.textfield) {
                return RoleEditor.this.securityProfileCombo;
            }
            if (component == RoleEditor.this.securityProfileCombo) {
                return RoleEditor.this.saveButton;
            }
            return RoleEditor.this.textfield;
        }

        public Component getComponentBefore(Container container, Component component) {
            if (component == RoleEditor.this.textfield) {
                return RoleEditor.this.saveButton;
            }
            if (component == RoleEditor.this.securityProfileCombo) {
                return RoleEditor.this.textfield;
            }
            return RoleEditor.this.securityProfileCombo;
        }

        public Component getDefaultComponent(Container container) {
            return RoleEditor.this.textfield;
        }

        public Component getFirstComponent(Container container) {
            return RoleEditor.this.textfield;
        }

        public Component getLastComponent(Container container) {
            return RoleEditor.this.saveButton;
        }
    }
}

