/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.resourceeditor;

import com.triloggroup.gantt.app.applet.GanttAppletBase;
import com.triloggroup.gantt.app.applet.IJSCallBack;
import com.triloggroup.gantt.app.applet.JSCallBack;
import com.triloggroup.gantt.app.xsp.XSPActions;
import com.triloggroup.project.components.resourceeditor.ProjectResource;
import com.triloggroup.project.components.resourceeditor.ResourceView;
import com.triloggroup.util.UString;
import javax.swing.SwingUtilities;

public class XSPResourceActions
extends XSPActions {
    private ResourceView view;

    public XSPResourceActions(ResourceView resourceView) {
        super(resourceView.getComponent(), resourceView.getWorkbenchPage().getApplet());
        this.view = resourceView;
    }

    private void cancelEdit() {
        this.view.getMainTable().cancelCellEditing();
    }

    public void addResource() {
        JSCallBack jSCallBack = new JSCallBack(){

            public void actionPerformed(final String string) {
                if (UString.isEmpty(string)) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        XSPResourceActions.this.view.addResource(string);
                    }
                });
            }
        };
        this.showResourceFinder(jSCallBack);
    }

    public void replaceResource(final ProjectResource projectResource) {
        JSCallBack jSCallBack = new JSCallBack(){

            public void actionPerformed(final String string) {
                if (UString.isEmpty(string)) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        XSPResourceActions.this.view.replaceResource(projectResource, string);
                    }
                });
            }
        };
        this.showResourceFinder(jSCallBack);
    }

    private void showResourceFinder(IJSCallBack iJSCallBack) {
        this.cancelEdit();
        GanttAppletBase ganttAppletBase = this.getApplet();
        if (ganttAppletBase == null) {
            return;
        }
        this.exitFullScreenMode();
        ganttAppletBase.callJS("showResourceFinder(\"" + ganttAppletBase.getHtmlTagId() + "\")", iJSCallBack);
    }
}

