/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.resourceeditor;

import com.triloggroup.gantt.GanttChartException;
import com.triloggroup.gantt.app.AppGanttChartModel;
import com.triloggroup.gantt.app.GanttWorkbenchPage;
import com.triloggroup.gantt.app.change.Change;
import com.triloggroup.gantt.app.change.ChangeException;
import com.triloggroup.gantt.app.change.ChangeManager;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.pe.app.PEAppProjectContext;
import com.triloggroup.project.SecurityProfile;
import com.triloggroup.project.components.IProjectListener;
import com.triloggroup.project.components.IProjectResourceModel;
import com.triloggroup.project.components.resourceeditor.ProjectResource;
import com.triloggroup.project.components.resourceeditor.ProjectRole;
import com.triloggroup.project.components.resourceeditor.ProjectTeam;
import com.triloggroup.project.components.resourceeditor.ReplaceUserOptionsDialog;
import com.triloggroup.project.components.resourceeditor.ResourceActions;
import com.triloggroup.project.components.resourceeditor.ResourcesWSHelper;
import com.triloggroup.project.components.resourceeditor.change.DeleteResourceChange;
import com.triloggroup.project.components.resourceeditor.change.ReplaceOptions;
import com.triloggroup.project.components.resourceeditor.change.ResourceChangeHandler;
import com.triloggroup.project.components.resourceeditor.invitation.InvitationDialog;
import com.triloggroup.project.components.resourceeditor.table.ResourceTable;
import com.triloggroup.project.components.resourceeditor.table.ResourceTableModel;
import com.triloggroup.project.components.resourceeditor.table.SearchedResource;
import com.triloggroup.project.components.st.SametimeSupport;
import com.triloggroup.project.components.ui.AbstractView;
import com.triloggroup.project.components.ui.UIConstants;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.util.UString;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public class ResourceView
extends AbstractView
implements IProjectListener {
    private ResourceTable table;
    private IProjectResourceModel currentPrjModel;
    protected ResourceActions actions;
    protected SecurityProfile[] securityProfiles;
    private SametimeSupport stSupport;
    private AppGanttChartModel chartModel;
    protected boolean securityProfilesLoading = false;

    public ResourceView(AppGanttChartModel appGanttChartModel, IProjectResourceModel iProjectResourceModel) {
        super(Workbench.getNLSString("resources_view_title", new Object[0]) + " - " + iProjectResourceModel.getProjectContext().getProjectName());
        this.chartModel = appGanttChartModel;
        this.currentPrjModel = iProjectResourceModel;
        iProjectResourceModel.addProjectListener(this);
        this.loadSecurityProfilesAsync();
        ResourceTableModel resourceTableModel = new ResourceTableModel(this, Workbench.get().getNLSBundle());
        this.table = new ResourceTable(this, resourceTableModel);
        ResourceChangeHandler resourceChangeHandler = new ResourceChangeHandler(this);
        this.getChangeManager().registerHandler(resourceChangeHandler);
        this.body = new JScrollPane(this.table);
        this.body.setBackground(UIConstants.BACKGROUND_HEADER_COLOR);
        this.mainComponent.add((Component)this.body, "Center");
        this.actions = new ResourceActions(this);
        this.actions.initToolBarItems();
    }

    public void setProject(IProjectResourceModel iProjectResourceModel) {
        if (iProjectResourceModel == this.currentPrjModel) {
            return;
        }
        if (this.currentPrjModel != null) {
            this.currentPrjModel.removeProjectListener(this);
        }
        this.currentPrjModel = iProjectResourceModel;
        this.setTitle(Workbench.getNLSString("resources_view_title", new Object[0]) + " - " + iProjectResourceModel.getProjectContext().getProjectName());
        iProjectResourceModel.addProjectListener(this);
        this.table.getModel().projectChanged();
        this.actions.updateActions();
    }

    public ResourcesWSHelper getWSHelper() {
        return new ResourcesWSHelper((PEAppProjectContext)this.currentPrjModel.getProjectContext());
    }

    public ChangeManager getChangeManager() {
        return this.chartModel.getChangeManager();
    }

    public AppGanttChartModel getChartModel() {
        return this.chartModel;
    }

    public boolean isSametimeActive() {
        SametimeSupport sametimeSupport = this.getSametimeSupport();
        return sametimeSupport != null && sametimeSupport.isEnabled();
    }

    public SametimeSupport getSametimeSupport() {
        return this.stSupport;
    }

    public void setSametimeSupport(SametimeSupport sametimeSupport) {
        this.stSupport = sametimeSupport;
    }

    public IProjectResourceModel getProjectModel() {
        return this.currentPrjModel;
    }

    public JComponent getMainFocusableComponent() {
        return this.table;
    }

    public JComponent[] getToolBarItems() {
        return this.actions.toolbarItems;
    }

    public Action getAction(int n) {
        if (n == 1) {
            return this.actions.deleteAction;
        }
        if (n == 2) {
            return this.actions.newAction;
        }
        return null;
    }

    void deleteSelectedResources() throws ChangeException {
        this.getWorkbenchPage().stopEditInProgress(true);
        ProjectResource[] projectResourceArray = this.table.getSelectedResources();
        if (projectResourceArray.length == 0) {
            return;
        }
        if (!WDDialog.showOkCancelDialog(this.getComponent(), Workbench.getNLSString("deleteRes_confirm", new Object[0]), null)) {
            return;
        }
        DeleteResourceChange[] deleteResourceChangeArray = this.currentPrjModel.deleteResources(projectResourceArray);
        for (int i = 0; i < projectResourceArray.length; ++i) {
            if (i > 0) {
                deleteResourceChangeArray[i].setLinkedToPreviousChange(true);
            }
            this.getChangeManager().addChange(deleteResourceChangeArray[i]);
        }
    }

    public ResourceTable getMainTable() {
        return this.table;
    }

    public void nodesUpdated(IProjectListener.ProjectEvent projectEvent) {
    }

    public void resourcesUpdated(IProjectListener.ProjectEvent projectEvent) {
        this.resourcesUpdated(projectEvent.change);
    }

    public void resourcesUpdated(int n) {
        switch (n) {
            case 65535: {
                this.table.rebuildTable();
                break;
            }
            case 1: {
                this.table.rebuildTableKeepOrder();
                break;
            }
            case 4: 
            case 8: {
                this.table.repaint();
            }
        }
    }

    public void replaceResource(ProjectResource projectResource, String string) {
        if (projectResource.getDn().equals(string)) {
            return;
        }
        try {
            SearchedResource searchedResource = this.createSearchedResource(string);
            this.replaceResource(projectResource, searchedResource);
        }
        catch (Exception exception) {
            WDDialog.showErrorMsgDialog(this.mainComponent, exception);
        }
    }

    public void replaceResource(ProjectResource projectResource, SearchedResource searchedResource) throws ChangeException {
        Change change;
        ProjectResource projectResource2;
        ReplaceOptions replaceOptions;
        if (projectResource.isRegistered()) {
            replaceOptions = ReplaceUserOptionsDialog.show(this.getComponent());
            if (replaceOptions == null) {
                return;
            }
        } else {
            replaceOptions = new ReplaceOptions();
            replaceOptions.includeHistory = true;
        }
        boolean bl = searchedResource.dn == null;
        ProjectResource projectResource3 = projectResource2 = bl ? null : this.currentPrjModel.getProjectResource(searchedResource.dn);
        if (projectResource2 == null) {
            if (bl) {
                searchedResource.dn = this.generatedDummyDn();
            }
            projectResource2 = new ProjectResource(searchedResource.cn, searchedResource.dn, null, this.currentPrjModel.getProjectContext());
            projectResource2.setRegistered(searchedResource.registered);
            projectResource2.setEnabled(true);
            projectResource2.setEmail(searchedResource.email);
            projectResource2.setProfileUrl(searchedResource.profileUrl);
            projectResource2.setCostRates(ProjectResource.createDefaultCostRates());
            projectResource2.setRoleId(projectResource.getRoleId());
            projectResource2.setTeamId(projectResource.getTeamId());
            if (bl) {
                change = this.addResource(projectResource2);
                this.getChangeManager().addChange(change);
            }
        }
        change = this.currentPrjModel.replaceResource(projectResource, projectResource2, replaceOptions);
        if (bl) {
            change.setLinkedToPreviousChange(true);
        }
        this.getChangeManager().addChange(change);
        this.table.selectAndScroll(projectResource2.getDn());
        this.currentPrjModel.updateResourcesCost();
        this.table.requestFocus();
    }

    public void addResource(String string) {
        if (this.currentPrjModel.getProjectResource(string) != null) {
            WDDialog.showMsgDialog(this.getComponent(), Workbench.getNLSString("resourceExists", new Object[0]));
            return;
        }
        try {
            SearchedResource searchedResource = this.createSearchedResource(string);
            this.addResource(searchedResource, null, null);
        }
        catch (Exception exception) {
            WDDialog.showErrorMsgDialog(this.mainComponent, exception);
        }
    }

    public void addResource(SearchedResource searchedResource, String string, String string2) {
        String string3 = searchedResource.dn;
        if (string3 == null || string3.length() == 0) {
            string3 = this.generatedDummyDn();
        }
        ProjectResource projectResource = new ProjectResource(searchedResource.cn, string3, null, this.currentPrjModel.getProjectContext());
        projectResource.setRegistered(searchedResource.registered);
        projectResource.setEnabled(true);
        projectResource.setEmail(searchedResource.email);
        projectResource.setCostRates(ProjectResource.createDefaultCostRates());
        projectResource.setTeamId(string);
        projectResource.setProfileUrl(searchedResource.profileUrl);
        Change change = this.addResource(projectResource);
        this.getChangeManager().addChange(change);
        this.currentPrjModel.updateResourcesCost();
        this.table.scrollTo(string3);
    }

    public Change addResource(ProjectResource projectResource) {
        if (this.currentPrjModel.getProjectResource(projectResource.getDn()) != null) {
            throw new IllegalStateException("Resource already on the project: " + projectResource.getDn());
        }
        Change change = this.currentPrjModel.addResourceForChange(projectResource);
        int n = this.table.getModel().getIndexForResourceDn(projectResource.getDn());
        this.table.getSelectionModel().setSelectionInterval(n, n);
        this.table.requestFocus();
        return change;
    }

    private String generatedDummyDn() {
        String string;
        int n = 0;
        while (this.currentPrjModel.getProjectResource(string = "uid=" + n++ + ",dc=new,dc=resourceseditor") != null) {
        }
        return string;
    }

    public void setResourceEnabled(ProjectResource projectResource, boolean bl) {
        if (projectResource.isEnabled() == bl) {
            return;
        }
        projectResource.setEnabled(bl);
        Change change = Change.newUpdateChange(projectResource);
        change.addBooleanModification("Enabled", !bl, bl);
        this.getChangeManager().addChange(change);
    }

    private SearchedResource createSearchedResource(String string) throws Exception {
        String string2 = this.getWSHelper().getResourceInfo(string);
        String[] stringArray = UString.splitString(string2, '|');
        String string3 = stringArray[0];
        SearchedResource searchedResource = new SearchedResource(string3, string, stringArray[2]);
        searchedResource.registered = "true".equals(stringArray[3]);
        searchedResource.profileUrl = stringArray[4];
        return searchedResource;
    }

    protected void loadSecurityProfilesAsync() {
        new Thread(){

            public void run() {
                try {
                    ResourceView.this.loadSecurityProfiles();
                }
                catch (GanttChartException ganttChartException) {
                    ganttChartException.printStackTrace();
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSecurityProfiles() throws GanttChartException {
        ResourceView resourceView = this;
        synchronized (resourceView) {
            if (this.securityProfilesLoading) {
                return;
            }
            this.securityProfilesLoading = true;
        }
        try {
            this.securityProfiles = this.getWSHelper().getSecurityProfiles();
            resourceView = this;
            synchronized (resourceView) {
                this.notifyAll();
            }
        }
        catch (Exception exception) {
            if (exception instanceof GanttChartException) {
                throw (GanttChartException)exception;
            }
            throw new GanttChartException(2, "Error to get task alerts metadata", exception);
        }
        finally {
            this.securityProfilesLoading = false;
        }
    }

    public SecurityProfile[] getSecurityProfiles() {
        return this.securityProfiles;
    }

    public void addProjectTeam(ProjectTeam projectTeam) {
        Change change = this.currentPrjModel.addProjectTeam(projectTeam);
        this.getChangeManager().addChange(change);
    }

    public void addProjectRole(ProjectRole projectRole) {
        Change change = this.currentPrjModel.addProjectRole(projectRole);
        this.getChangeManager().addChange(change);
    }

    public void inviteUsers(ProjectResource[] projectResourceArray) {
        this.table.cancelCellEditing();
        if (projectResourceArray == null) {
            projectResourceArray = this.table.getSelectedResources();
        }
        for (ProjectResource projectResource : projectResourceArray) {
            if (!UString.isEmpty(projectResource.getEmail())) continue;
            WDDialog.showMsgDialog(this.mainComponent, Workbench.getNLSString("inviteNoEmail", new Object[0]));
            return;
        }
        for (ProjectResource projectResource : projectResourceArray) {
            if (!this.isResourceModifiedLocally(projectResource)) continue;
            WDDialog.showMsgDialog(this.mainComponent, Workbench.getNLSString("inviteNeedSaving", new Object[0]));
            return;
        }
        InvitationDialog.show(this.mainComponent, projectResourceArray, this);
    }

    private boolean isResourceModifiedLocally(ProjectResource projectResource) {
        String string = projectResource.getDn();
        if (this.currentPrjModel.getProjectResource(string) == null) {
            return false;
        }
        ArrayList<Change> arrayList = this.getChangeManager().getAllChanges();
        for (Change change : arrayList) {
            if (change.getTarget() != projectResource) continue;
            return true;
        }
        return false;
    }

    public GanttWorkbenchPage getWorkbenchPage() {
        return (GanttWorkbenchPage)super.getWorkbenchPage();
    }
}

