/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.resourceeditor;

import com.triloggroup.gantt.Debug;
import com.triloggroup.gantt.app.GanttKeyStrokes;
import com.triloggroup.gantt.app.ui.UToolBar;
import com.triloggroup.gantt.app.ui.WDCmdButton;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.project.components.resourceeditor.NewRoleDialog;
import com.triloggroup.project.components.resourceeditor.NewTeamDialog;
import com.triloggroup.project.components.resourceeditor.ProjectResource;
import com.triloggroup.project.components.resourceeditor.ResourceView;
import com.triloggroup.project.components.resourceeditor.XSPResourceActions;
import com.triloggroup.project.components.ui.Workbench;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResourceActions {
    protected JComponent[] toolbarItems;
    protected Action deleteAction;
    protected Action newAction;
    protected Action addResourceInlineAction;
    protected Action addResourceWithPicker;
    protected Action inviteAction;
    private ResourceView view;

    ResourceActions(ResourceView resourceView) {
        this.view = resourceView;
    }

    protected void initToolBarItems() {
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        ImageIcon imageIcon = WDUtil.getIcon("expandcollapse.png");
        final WDCmdButton wDCmdButton = new WDCmdButton(imageIcon);
        wDCmdButton.setToolTipText(Workbench.getNLSString("categorize", new Object[0]));
        wDCmdButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(new CategoryRadio("byRole", "Role", "resources_view_title_by_role"));
                jPopupMenu.add(new CategoryRadio("byTeam", "Team", "resources_view_title_by_team"));
                jPopupMenu.add(new CategoryRadio("noCategory", null, "resources_view_title"));
                jPopupMenu.show(wDCmdButton, 0, wDCmdButton.getHeight());
            }
        });
        arrayList.add(wDCmdButton);
        if (this.view.getProjectModel().isResourceEditable()) {
            imageIcon = WDUtil.getIcon("delete.png");
            this.deleteAction = new AbstractAction(null, imageIcon){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        ResourceActions.this.view.deleteSelectedResources();
                    }
                    catch (Exception exception) {
                        WDDialog.showErrorMsgDialog(ResourceActions.this.view.getMainFocusableComponent(), exception);
                    }
                }
            };
            this.deleteAction.setEnabled(false);
            UToolBar.setActionText(this.deleteAction, "deleteResource", GanttKeyStrokes.DELETE);
            this.view.getMainTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    ResourceActions.this.updateActionsForSelectionChanged();
                }
            });
            imageIcon = WDUtil.getIcon("new.png");
            this.newAction = new AbstractAction(null, imageIcon){

                public void actionPerformed(ActionEvent actionEvent) {
                    final JComponent jComponent = actionEvent.getSource() instanceof JComponent ? (JComponent)actionEvent.getSource() : null;
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem = new JMenuItem(Workbench.getNLSString("newTeam", new Object[0]));
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            ResourceActions.this.view.getWorkbenchPage().stopEditInProgress(true);
                            NewTeamDialog.showDialog(ResourceActions.this.view, jComponent);
                        }
                    });
                    jPopupMenu.add(jMenuItem);
                    JMenuItem jMenuItem2 = new JMenuItem(Workbench.getNLSString("newRole", new Object[0]));
                    jMenuItem2.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            ResourceActions.this.view.getWorkbenchPage().stopEditInProgress(true);
                            NewRoleDialog.showDialog(ResourceActions.this.view, jComponent);
                        }
                    });
                    jPopupMenu.add(jMenuItem2);
                    JComponent jComponent2 = (JComponent)actionEvent.getSource();
                    jPopupMenu.show(jComponent2, 0, jComponent2.getHeight());
                }
            };
            UToolBar.setActionText(this.newAction, "new_button", null);
            imageIcon = WDUtil.getIcon("add_resource.gif");
            this.addResourceWithPicker = new AbstractAction(null, imageIcon){

                public void actionPerformed(ActionEvent actionEvent) {
                    ResourceActions.this.addResourceWithUserFinder();
                }
            };
            UToolBar.setActionText(this.addResourceWithPicker, "addResource", null);
            WDCmdButton wDCmdButton2 = new WDCmdButton(this.addResourceWithPicker);
            arrayList.add(wDCmdButton2);
            imageIcon = WDUtil.getIcon("invite_users.gif");
            this.inviteAction = new AbstractAction(null, imageIcon){

                public void actionPerformed(ActionEvent actionEvent) {
                    ResourceActions.this.view.inviteUsers(null);
                }
            };
            UToolBar.setActionText(this.inviteAction, "inviteResource", null);
            WDCmdButton wDCmdButton3 = new WDCmdButton(this.inviteAction);
            arrayList.add(wDCmdButton3);
            this.addResourceInlineAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ResourceActions.this.addResourceInline();
                }
            };
            ActionMap actionMap = this.view.getComponent().getActionMap();
            InputMap inputMap = this.view.getComponent().getInputMap(1);
            actionMap.put("newInlineResource", this.addResourceInlineAction);
            inputMap.put(GanttKeyStrokes.NEW_TASK, "newInlineResource");
        }
        this.initTestAction(arrayList);
        this.toolbarItems = UToolBar.disableFocus(arrayList);
    }

    protected void addResourceWithUserFinder() {
        XSPResourceActions xSPResourceActions = new XSPResourceActions(this.view);
        xSPResourceActions.addResource();
    }

    protected void addResourceInline() {
        this.view.getMainTable().addResourceInline();
    }

    private void initTestAction(ArrayList<JComponent> arrayList) {
        if (!Debug.DEBUG) {
            return;
        }
    }

    void updateActions() {
        boolean bl = this.view.getProjectModel().isResourceEditable();
        if (this.newAction != null) {
            this.newAction.setEnabled(bl);
        }
        if (this.addResourceWithPicker != null) {
            this.addResourceWithPicker.setEnabled(bl);
        }
        this.updateActionsForSelectionChanged();
    }

    private void updateActionsForSelectionChanged() {
        ProjectResource[] projectResourceArray;
        boolean bl = false;
        boolean bl2 = false;
        if (this.view.getProjectModel().isResourceEditable() && this.view.getWSHelper() != null && (projectResourceArray = this.view.getMainTable().getSelectedResources()).length > 0) {
            bl = true;
            bl2 = true;
            int n = this.view.getProjectModel().getProjectResources().length;
            if (n == projectResourceArray.length) {
                bl = false;
            }
        }
        if (this.deleteAction != null) {
            this.deleteAction.setEnabled(bl);
        }
        if (this.inviteAction != null) {
            this.inviteAction.setEnabled(bl2);
        }
    }

    protected class CategoryRadio
    extends JRadioButtonMenuItem
    implements ActionListener {
        private String category;
        private String viewNameKey;

        CategoryRadio(String string, String string2, String string3) {
            super(Workbench.getNLSString(string, new Object[0]));
            this.category = string2;
            this.viewNameKey = string3;
            this.setSelected(ResourceActions.this.view.getMainTable().getCategorization() == string2);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ResourceActions.this.view.getMainTable().categorizeBy(this.category);
            ResourceActions.this.view.setTitle(Workbench.getNLSString(this.viewNameKey, new Object[0]));
        }
    }
}

