/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.resourceeditor;

import com.triloggroup.gantt.app.ui.WDButton;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.gantt.pe.app.AppScheduleComputation;
import com.triloggroup.project.components.IProjectResourceModel;
import com.triloggroup.project.components.resourceeditor.ProjectTeam;
import com.triloggroup.project.components.resourceeditor.ResourceView;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.util.UString;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class NewTeamDialog
extends WDDialog
implements ActionListener {
    private ResourceView view;
    private WDButton okButton;
    private JTextField tfName;

    public static void showDialog(ResourceView resourceView, Point point) {
        NewTeamDialog.showDialog(resourceView, null, point);
    }

    public static void showDialog(ResourceView resourceView, Component component) {
        NewTeamDialog.showDialog(resourceView, component, null);
    }

    private static void showDialog(ResourceView resourceView, Component component, Point point) {
        if (component == null) {
            component = resourceView.getComponent();
        }
        if (point == null) {
            point = component.getLocationOnScreen();
            point.y += component.getHeight() / 2;
            point.x += component.getWidth() / 2;
        }
        GraphicsConfiguration graphicsConfiguration = WDUtil.getGraphicsConfiguration(point);
        Window window = SwingUtilities.getWindowAncestor(component);
        NewTeamDialog newTeamDialog = new NewTeamDialog(resourceView, window, graphicsConfiguration);
        newTeamDialog.setLocation(point);
        newTeamDialog.setModal(true);
        newTeamDialog.setVisible(true);
    }

    protected NewTeamDialog(ResourceView resourceView, Window window, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
        this.view = resourceView;
        this.createUI();
    }

    protected void createUI() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBorder(new EmptyBorder(0, 5, 5, 5));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        this.okButton = WDUtil.createOkButton();
        jPanel2.add(this.okButton);
        WDButton wDButton = WDUtil.createCancelButton();
        jPanel2.add(wDButton);
        this.okButton.addActionListener(this);
        wDButton.addActionListener(this);
        jPanel.add((Component)jPanel2, "North");
        JLabel jLabel = new JLabel(Workbench.getNLSString("teamName", new Object[0]));
        jPanel.add((Component)jLabel, "West");
        this.tfName = new JTextField(30);
        jPanel.add((Component)this.tfName, "Center");
        this.getContentPane().add(jPanel);
        this.setDragHeader(true);
        this.setMaximizable(false);
        this.pack();
        this.tfName.requestFocusInWindow();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            String string = UString.trim(this.tfName.getText());
            String string2 = NewTeamDialog.isValidTeamName(string, this.view.getProjectModel());
            if (string2 != null) {
                WDDialog.showMsgDialog(this, string2);
                this.tfName.requestFocus();
                return;
            }
            ProjectTeam projectTeam = new ProjectTeam(NewTeamDialog.generateTeamId(), string, this.view.getProjectModel().getProjectContext());
            this.view.addProjectTeam(projectTeam);
        }
        this.dispose();
    }

    public static String isValidTeamName(String string, IProjectResourceModel iProjectResourceModel) {
        if (UString.isEmpty(string)) {
            return Workbench.getNLSString("name_empty", new Object[0]);
        }
        if (string.length() > 120) {
            return Workbench.getNLSString("nameTooLong", new Object[0]);
        }
        String string2 = Workbench.checkInvalidCharacters(string);
        if (string2 != null) {
            return string2;
        }
        ProjectTeam[] projectTeamArray = iProjectResourceModel.getProjectTeams();
        if (projectTeamArray != null) {
            for (int i = 0; i < projectTeamArray.length; ++i) {
                if (!UString.equals(projectTeamArray[i].getLabel(), string)) continue;
                return Workbench.getNLSString("nameAlreadyExist", new Object[0]);
            }
        }
        return null;
    }

    public static String generateTeamId() {
        return AppScheduleComputation.newObjectId("Team_");
    }
}

