/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.resourceeditor;

import com.triloggroup.gantt.app.ui.WDButton;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.gantt.pe.app.AppScheduleComputation;
import com.triloggroup.project.SecurityProfile;
import com.triloggroup.project.components.IProjectResourceModel;
import com.triloggroup.project.components.resourceeditor.ProjectRole;
import com.triloggroup.project.components.resourceeditor.ResourceView;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.util.UString;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class NewRoleDialog
extends WDDialog
implements ActionListener {
    private ResourceView view;
    private WDButton okButton;
    private JTextField tfName;
    private JComboBox securityProfileCombo;

    public static void showDialog(ResourceView resourceView, Point point) {
        NewRoleDialog.showDialog(resourceView, null, point);
    }

    public static void showDialog(ResourceView resourceView, Component component) {
        NewRoleDialog.showDialog(resourceView, component, null);
    }

    private static void showDialog(ResourceView resourceView, Component component, Point point) {
        if (component == null) {
            component = resourceView.getComponent();
        }
        if (point == null) {
            point = component.getLocationOnScreen();
            point.y += component.getHeight() / 2;
            point.x += component.getWidth() / 2;
        }
        GraphicsConfiguration graphicsConfiguration = WDUtil.getGraphicsConfiguration(point);
        Window window = SwingUtilities.getWindowAncestor(component);
        NewRoleDialog newRoleDialog = new NewRoleDialog(resourceView, window, graphicsConfiguration);
        newRoleDialog.setLocation(point);
        newRoleDialog.setModal(true);
        newRoleDialog.setVisible(true);
    }

    protected NewRoleDialog(ResourceView resourceView, Window window, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
        this.view = resourceView;
        this.createUI();
    }

    protected void createUI() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(0, 5, 5, 5));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        this.okButton = WDUtil.createOkButton();
        jPanel2.add(this.okButton);
        WDButton wDButton = WDUtil.createCancelButton();
        jPanel2.add(wDButton);
        this.okButton.addActionListener(this);
        wDButton.addActionListener(this);
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        JLabel jLabel = new JLabel(Workbench.getNLSString("roleName", new Object[0]));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.tfName = new JTextField(30);
        jPanel.add((Component)this.tfName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 5, 5), 0, 0));
        JLabel jLabel2 = new JLabel(Workbench.getNLSString("roleProfile", new Object[0]));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.securityProfileCombo = new JComboBox<SecurityProfile>(this.view.getSecurityProfiles());
        jPanel.add((Component)this.securityProfileCombo, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.getContentPane().add(jPanel);
        this.setDragHeader(true);
        this.setMaximizable(false);
        this.pack();
        this.tfName.requestFocusInWindow();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            String string = UString.trim(this.tfName.getText());
            String string2 = NewRoleDialog.isValidRoleName(string, this.view.getProjectModel());
            if (string2 != null) {
                WDDialog.showMsgDialog(this, string2);
                this.tfName.requestFocus();
                return;
            }
            ProjectRole projectRole = new ProjectRole(NewRoleDialog.generateRoleId(), string, false, this.view.getProjectModel().getProjectContext());
            projectRole.setSecurityProfileId(((SecurityProfile)this.securityProfileCombo.getSelectedItem()).getId());
            this.view.addProjectRole(projectRole);
        }
        this.dispose();
    }

    public static String isValidRoleName(String string, IProjectResourceModel iProjectResourceModel) {
        if (UString.isEmpty(string)) {
            return Workbench.getNLSString("name_empty", new Object[0]);
        }
        if (string.length() > 120) {
            return Workbench.getNLSString("nameTooLong", new Object[0]);
        }
        String string2 = Workbench.checkInvalidCharacters(string);
        if (string2 != null) {
            return string2;
        }
        ProjectRole[] projectRoleArray = iProjectResourceModel.getProjectRoles();
        if (projectRoleArray != null) {
            for (int i = 0; i < projectRoleArray.length; ++i) {
                if (!UString.equals(projectRoleArray[i].getLabel(), string)) continue;
                return Workbench.getNLSString("nameAlreadyExist", new Object[0]);
            }
        }
        return null;
    }

    public static String generateRoleId() {
        return AppScheduleComputation.newObjectId("Role_");
    }
}

